/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.event;

import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.RespawnAnchor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;
import org.koin.core.annotation.Single;
import xyz.atrius.waystones.advancement.UnlimitedPowerAdvancement;
import xyz.atrius.waystones.kotlin.Metadata;
import xyz.atrius.waystones.kotlin.jvm.internal.Intrinsics;
import xyz.atrius.waystones.manager.AdvancementManager;
import xyz.atrius.waystones.service.WaystoneService;

@Single
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lxyz/atrius/waystones/event/ExplodeEvent;", "Lorg/bukkit/event/Listener;", "advancementManager", "Lxyz/atrius/waystones/manager/AdvancementManager;", "waystoneService", "Lxyz/atrius/waystones/service/WaystoneService;", "unlimitedPowerAdvancement", "Lxyz/atrius/waystones/advancement/UnlimitedPowerAdvancement;", "<init>", "(Lxyz/atrius/waystones/manager/AdvancementManager;Lxyz/atrius/waystones/service/WaystoneService;Lxyz/atrius/waystones/advancement/UnlimitedPowerAdvancement;)V", "onClick", "", "event", "Lorg/bukkit/event/player/PlayerInteractEvent;", "waystones"})
public final class ExplodeEvent
implements Listener {
    @NotNull
    private final AdvancementManager advancementManager;
    @NotNull
    private final WaystoneService waystoneService;
    @NotNull
    private final UnlimitedPowerAdvancement unlimitedPowerAdvancement;

    public ExplodeEvent(@NotNull AdvancementManager advancementManager, @NotNull WaystoneService waystoneService, @NotNull UnlimitedPowerAdvancement unlimitedPowerAdvancement) {
        Intrinsics.checkNotNullParameter(advancementManager, "advancementManager");
        Intrinsics.checkNotNullParameter(waystoneService, "waystoneService");
        Intrinsics.checkNotNullParameter(unlimitedPowerAdvancement, "unlimitedPowerAdvancement");
        this.advancementManager = advancementManager;
        this.waystoneService = waystoneService;
        this.unlimitedPowerAdvancement = unlimitedPowerAdvancement;
    }

    @EventHandler
    public final void onClick(@NotNull PlayerInteractEvent event) {
        Block block;
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        Block block2 = block = event.getClickedBlock();
        if ((block2 != null ? block2.getType() : null) != Material.RESPAWN_ANCHOR || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        BlockData blockData = block.getBlockData();
        Intrinsics.checkNotNull(blockData, "null cannot be cast to non-null type org.bukkit.block.data.type.RespawnAnchor");
        RespawnAnchor anchor = (RespawnAnchor)blockData;
        boolean canExplode = block.getWorld().getEnvironment() == World.Environment.NORMAL;
        Block block3 = block.getWorld().getBlockAt(block.getLocation().add(0.0, 1.0, 0.0));
        Intrinsics.checkNotNullExpressionValue(block3, "getBlockAt(...)");
        Block above = block3;
        if (anchor.getCharges() == anchor.getMaximumCharges() && this.waystoneService.isWaystone(above) && canExplode) {
            this.advancementManager.awardAdvancement(player2, this.unlimitedPowerAdvancement);
        }
    }
}

