/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.data;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import xyz.atrius.waystones.data.struct.SizedHashSet;
import xyz.atrius.waystones.data.struct.StackSet;
import xyz.atrius.waystones.kotlin.Metadata;
import xyz.atrius.waystones.kotlin.collections.ArraysKt;
import xyz.atrius.waystones.kotlin.collections.CollectionsKt;
import xyz.atrius.waystones.kotlin.collections.SetsKt;
import xyz.atrius.waystones.kotlin.jvm.internal.DefaultConstructorMarker;
import xyz.atrius.waystones.kotlin.jvm.internal.Intrinsics;
import xyz.atrius.waystones.utility.LocationKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\u0013\u001a\u00020\u00142\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0082\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lxyz/atrius/waystones/data/FloodFill;", "Lxyz/atrius/waystones/data/struct/SizedHashSet;", "Lorg/bukkit/block/Block;", "startPosition", "Lorg/bukkit/Location;", "maxFill", "", "materials", "", "Lorg/bukkit/Material;", "<init>", "(Lorg/bukkit/Location;I[Lorg/bukkit/Material;)V", "[Lorg/bukkit/Material;", "breakdown", "Lxyz/atrius/waystones/data/struct/StackSet;", "getBreakdown", "()Lxyz/atrius/waystones/data/struct/StackSet;", "setBreakdown", "(Lxyz/atrius/waystones/data/struct/StackSet;)V", "fill", "", "blocks", "", "waystones"})
public final class FloodFill
extends SizedHashSet<Block> {
    @NotNull
    private final Location startPosition;
    @NotNull
    private final Material[] materials;
    @NotNull
    private StackSet<Block> breakdown;

    public FloodFill(@NotNull Location startPosition, int maxFill, Material ... materials) {
        Intrinsics.checkNotNullParameter(startPosition, "startPosition");
        Intrinsics.checkNotNullParameter(materials, "materials");
        super(maxFill);
        this.startPosition = startPosition;
        this.materials = materials;
        FloodFill.fill$default(this, null, 1, null);
        this.breakdown = new StackSet(CollectionsKt.toList(this));
    }

    public /* synthetic */ FloodFill(Location location, int n, Material[] materialArray, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        this(location, n, materialArray);
    }

    @NotNull
    public final StackSet<Block> getBreakdown() {
        return this.breakdown;
    }

    public final void setBreakdown(@NotNull StackSet<Block> stackSet) {
        Intrinsics.checkNotNullParameter(stackSet, "<set-?>");
        this.breakdown = stackSet;
    }

    private final void fill(Set<? extends Block> blocks) {
        FloodFill floodFill = this;
        while (!blocks.isEmpty()) {
            Set next = new LinkedHashSet();
            for (Block block : blocks) {
                if (ArraysKt.contains(floodFill.materials, block.getType()) && !floodFill.add(block)) continue;
                Location location = block.getLocation();
                Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
                Iterator<Location> iterator2 = LocationKt.getNeighbors(location).iterator();
                while (iterator2.hasNext()) {
                    Block block2;
                    Location n;
                    Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                    World world = n.getWorld();
                    if (world == null || (block2 = world.getBlockAt(n)) == null) continue;
                    Block neighbor = block2;
                    if (!ArraysKt.contains(floodFill.materials, neighbor.getType())) continue;
                    next.add(neighbor);
                }
            }
            blocks = next;
        }
        return;
    }

    static /* synthetic */ void fill$default(FloodFill floodFill, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            set = SetsKt.setOf(floodFill.startPosition.getBlock());
        }
        floodFill.fill((Set<? extends Block>)set);
    }
}

