/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.service;

import arrow.core.Either;
import arrow.core.NonFatalOrThrowKt;
import arrow.core.raise.DefaultRaise;
import arrow.core.raise.Raise;
import arrow.core.raise.RaiseCancellationException;
import arrow.core.raise.RaiseKt;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.koin.core.annotation.Single;
import xyz.atrius.KotlinNothingValueException;
import xyz.atrius.Metadata;
import xyz.atrius.Unit;
import xyz.atrius.collections.CollectionsKt;
import xyz.atrius.jvm.functions.Function0;
import xyz.atrius.jvm.functions.Function1;
import xyz.atrius.jvm.internal.DefaultConstructorMarker;
import xyz.atrius.jvm.internal.Intrinsics;
import xyz.atrius.jvm.internal.SourceDebugExtension;
import xyz.atrius.waystones.dao.WaystoneInfo;
import xyz.atrius.waystones.data.config.property.RelinkableKeysProperty;
import xyz.atrius.waystones.manager.LocalizationManager;
import xyz.atrius.waystones.manager.LocalizedString;
import xyz.atrius.waystones.provider.DefaultKeyProvider;
import xyz.atrius.waystones.repository.WaystoneInfoRepository;
import xyz.atrius.waystones.service.KeyService;
import xyz.atrius.waystones.utility.ItemKt;
import xyz.atrius.waystones.utility.LocationKt;
import xyz.atrius.waystones.utility.PlayerKt;

@Single
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0019B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ*\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u001c\u0010\u0018\u001a\u00020\u0015*\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lxyz/atrius/waystones/service/LinkService;", "", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "relinkableKeys", "Lxyz/atrius/waystones/data/config/property/RelinkableKeysProperty;", "keyService", "Lxyz/atrius/waystones/service/KeyService;", "defaultKeyProvider", "Lxyz/atrius/waystones/provider/DefaultKeyProvider;", "waystoneInfoRepository", "Lxyz/atrius/waystones/repository/WaystoneInfoRepository;", "<init>", "(Lxyz/atrius/waystones/manager/LocalizationManager;Lxyz/atrius/waystones/data/config/property/RelinkableKeysProperty;Lxyz/atrius/waystones/service/KeyService;Lxyz/atrius/waystones/provider/DefaultKeyProvider;Lxyz/atrius/waystones/repository/WaystoneInfoRepository;)V", "process", "Larrow/core/Either;", "Lxyz/atrius/waystones/service/LinkService$LinkServiceError;", "", "player", "Lorg/bukkit/entity/Player;", "item", "Lorg/bukkit/inventory/ItemStack;", "block", "Lorg/bukkit/block/Block;", "link", "LinkServiceError", "waystones"})
@SourceDebugExtension(value={"SMAP\nLinkService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinkService.kt\nxyz/atrius/waystones/service/LinkService\n+ 2 Builders.kt\narrow/core/raise/RaiseKt__BuildersKt\n+ 3 Fold.kt\narrow/core/raise/RaiseKt__FoldKt\n+ 4 Raise.kt\narrow/core/raise/RaiseKt__RaiseKt\n+ 5 Data.kt\nxyz/atrius/waystones/utility/DataKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n53#2:87\n115#3:88\n142#3,3:89\n145#3,8:96\n584#4:92\n629#4:93\n584#4:94\n584#4:95\n15#5,3:104\n18#5,2:108\n1#6:107\n*S KotlinDebug\n*F\n+ 1 LinkService.kt\nxyz/atrius/waystones/service/LinkService\n*L\n34#1:87\n34#1:88\n34#1:89,3\n34#1:96,8\n35#1:92\n39#1:93\n44#1:94\n49#1:95\n61#1:104,3\n61#1:108,2\n*E\n"})
public final class LinkService {
    @NotNull
    private final LocalizationManager localization;
    @NotNull
    private final RelinkableKeysProperty relinkableKeys;
    @NotNull
    private final KeyService keyService;
    @NotNull
    private final DefaultKeyProvider defaultKeyProvider;
    @NotNull
    private final WaystoneInfoRepository waystoneInfoRepository;

    public LinkService(@NotNull LocalizationManager localization, @NotNull RelinkableKeysProperty relinkableKeys, @NotNull KeyService keyService, @NotNull DefaultKeyProvider defaultKeyProvider, @NotNull WaystoneInfoRepository waystoneInfoRepository) {
        Intrinsics.checkNotNullParameter(localization, "localization");
        Intrinsics.checkNotNullParameter(relinkableKeys, "relinkableKeys");
        Intrinsics.checkNotNullParameter(keyService, "keyService");
        Intrinsics.checkNotNullParameter(defaultKeyProvider, "defaultKeyProvider");
        Intrinsics.checkNotNullParameter(waystoneInfoRepository, "waystoneInfoRepository");
        this.localization = localization;
        this.relinkableKeys = relinkableKeys;
        this.keyService = keyService;
        this.defaultKeyProvider = defaultKeyProvider;
        this.waystoneInfoRepository = waystoneInfoRepository;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Either<LinkServiceError, Unit> process(@NotNull Player player, @NotNull ItemStack item, @NotNull Block block) {
        Either either;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$either = false;
        boolean $i$f$_foldOrThrow = false;
        boolean $i$f$_fold = false;
        DefaultRaise raise$iv$iv$iv = new DefaultRaise(false);
        try {
            Raise $this$ensure$iv;
            boolean $i$f$ensure;
            Raise $this$ensureNotNull$iv;
            Raise $this$process_u24lambda_u244 = (Raise)raise$iv$iv$iv;
            boolean bl = false;
            Raise raise = $this$process_u24lambda_u244;
            boolean condition$iv22 = this.keyService.isWarpKey(item) && block.getType() == Material.LODESTONE;
            boolean $i$f$ensure22 = false;
            if (!condition$iv22) {
                void $this$ensure$iv2;
                void var13_17 = $this$ensure$iv2;
                boolean bl2 = false;
                var13_17.raise((Object)LinkServiceError.Ignore.INSTANCE);
                throw new KotlinNothingValueException();
            }
            Raise condition$iv22 = $this$process_u24lambda_u244;
            ItemMeta $i$f$ensure22 = item.getItemMeta();
            CompassMeta value$iv = $i$f$ensure22 instanceof CompassMeta ? (CompassMeta)$i$f$ensure22 : null;
            boolean $i$f$ensureNotNull = false;
            CompassMeta compassMeta = value$iv;
            if (compassMeta == null) {
                void var13_18 = $this$ensureNotNull$iv;
                boolean bl3 = false;
                var13_18.raise((Object)LinkServiceError.Ignore.INSTANCE);
                throw new KotlinNothingValueException();
            }
            CompassMeta meta = compassMeta;
            if (!((Boolean)this.relinkableKeys.value()).booleanValue()) {
                $this$ensureNotNull$iv = $this$process_u24lambda_u244;
                boolean condition$iv = !meta.hasLodestone();
                $i$f$ensure = false;
                if (!condition$iv) {
                    Raise raise2 = $this$ensure$iv;
                    boolean bl4 = false;
                    raise2.raise((Object)new LinkServiceError.NotRelinkable(this.localization));
                    throw new KotlinNothingValueException();
                }
            }
            $this$ensure$iv = $this$process_u24lambda_u244;
            boolean condition$iv = !Intrinsics.areEqual(meta.getLodestone(), block.getLocation());
            $i$f$ensure = false;
            if (!condition$iv) {
                Raise raise3 = $this$ensure$iv;
                boolean bl5 = false;
                raise3.raise((Object)new LinkServiceError.AlreadyLinked(this.localization));
                throw new KotlinNothingValueException();
            }
            ItemStack key = this.link(DefaultKeyProvider.getKey$default(this.defaultKeyProvider, player, 0, 2, null), player, block);
            PlayerInventory playerInventory = player.getInventory();
            Intrinsics.checkNotNullExpressionValue(playerInventory, "getInventory(...)");
            ItemKt.addItemNaturally(playerInventory, item, key);
            Sound sound = Sound.ITEM_LODESTONE_COMPASS_LOCK;
            Intrinsics.checkNotNullExpressionValue(sound, "ITEM_LODESTONE_COMPASS_LOCK");
            PlayerKt.playSound$default(player, sound, 0.0f, 0.0f, 6, null);
            Unit res$iv$iv$iv = Unit.INSTANCE;
            raise$iv$iv$iv.complete();
            Unit it$iv = res$iv$iv$iv;
            boolean bl6 = false;
            either = (Either)new Either.Right((Object)it$iv);
        }
        catch (RaiseCancellationException e$iv$iv$iv) {
            raise$iv$iv$iv.complete();
            Object it$iv = RaiseKt.raisedOrRethrow((CancellationException)((CancellationException)((Object)e$iv$iv$iv)), (DefaultRaise)raise$iv$iv$iv);
            boolean bl = false;
            either = (Either)new Either.Left(it$iv);
        }
        catch (Throwable e$iv$iv$iv) {
            raise$iv$iv$iv.complete();
            Throwable it$iv$iv = NonFatalOrThrowKt.nonFatalOrThrow((Throwable)e$iv$iv$iv);
            boolean bl = false;
            throw it$iv$iv;
        }
        return either;
    }

    private final ItemStack link(ItemStack $this$link, Player player, Block block) {
        ItemStack itemStack;
        ItemStack $this$update$iv = $this$link;
        boolean $i$f$update = false;
        ItemStack it$iv = itemStack = $this$update$iv;
        boolean bl = false;
        ItemMeta itemMeta = $this$update$iv.getItemMeta();
        if (itemMeta == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.bukkit.inventory.meta.CompassMeta");
        }
        ItemMeta data$iv = (ItemMeta)((CompassMeta)itemMeta);
        CompassMeta $this$link_u24lambda_u247 = (CompassMeta)data$iv;
        boolean bl2 = false;
        $this$link_u24lambda_u247.setLodestone(block.getLocation());
        $this$link_u24lambda_u247.setLodestoneTracked(true);
        Location location = block.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        CompletionStage name = this.waystoneInfoRepository.getWaystone(location).thenApplyAsync(arg_0 -> LinkService.link$lambda$7$lambda$6(arg_0 -> LinkService.link$lambda$7$lambda$5(this, player, arg_0), arg_0));
        Object[] objectArray = new Object[2];
        objectArray[0] = ((CompletableFuture)name).get();
        Location location2 = $this$link_u24lambda_u247.getLodestone();
        objectArray[1] = location2 != null ? LocationKt.getLocationCode(location2) : null;
        String p0 = this.localization.get("link-key-lore", objectArray).format(player);
        boolean bl3 = false;
        TextComponent textComponent = Component.text((String)p0);
        Intrinsics.checkNotNullExpressionValue(textComponent, "let(...)");
        TextComponent lore = textComponent;
        $this$link_u24lambda_u247.lore(CollectionsKt.listOf(lore));
        $this$update$iv.setItemMeta(data$iv);
        return itemStack;
    }

    private static final String link$lambda$7$lambda$5(LinkService this$0, Player $player, WaystoneInfo it) {
        Object object = it;
        if (object == null || (object = ((WaystoneInfo)object).getName()) == null) {
            object = this$0.localization.get("unnamed-waystone", new Object[0]).format($player);
        }
        return object;
    }

    private static final String link$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\t\n\u000bB\u0019\b\u0004\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0003\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lxyz/atrius/waystones/service/LinkService$LinkServiceError;", "", "message", "Lxyz/atrius/Function0;", "Lxyz/atrius/waystones/manager/LocalizedString;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "getMessage", "()Lkotlin/jvm/functions/Function0;", "Ignore", "NotRelinkable", "AlreadyLinked", "Lxyz/atrius/waystones/service/LinkService$LinkServiceError$AlreadyLinked;", "Lxyz/atrius/waystones/service/LinkService$LinkServiceError$Ignore;", "Lxyz/atrius/waystones/service/LinkService$LinkServiceError$NotRelinkable;", "waystones"})
    public static abstract sealed class LinkServiceError {
        @NotNull
        private final Function0<LocalizedString> message;

        private LinkServiceError(Function0<LocalizedString> message) {
            this.message = message;
        }

        @NotNull
        public final Function0<LocalizedString> getMessage() {
            return this.message;
        }

        public /* synthetic */ LinkServiceError(Function0 message, DefaultConstructorMarker $constructor_marker) {
            this(message);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lxyz/atrius/waystones/service/LinkService$LinkServiceError$AlreadyLinked;", "Lxyz/atrius/waystones/service/LinkService$LinkServiceError;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "<init>", "(Lxyz/atrius/waystones/manager/LocalizationManager;)V", "waystones"})
        public static final class AlreadyLinked
        extends LinkServiceError {
            public AlreadyLinked(@NotNull LocalizationManager localization) {
                Intrinsics.checkNotNullParameter(localization, "localization");
                super(() -> AlreadyLinked._init_$lambda$0(localization), null);
            }

            private static final LocalizedString _init_$lambda$0(LocalizationManager $localization) {
                return $localization.get("link-already-linked", new Object[0]);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lxyz/atrius/waystones/service/LinkService$LinkServiceError$Ignore;", "Lxyz/atrius/waystones/service/LinkService$LinkServiceError;", "<init>", "()V", "waystones"})
        public static final class Ignore
        extends LinkServiceError {
            @NotNull
            public static final Ignore INSTANCE = new Ignore();

            private Ignore() {
                super(Ignore::_init_$lambda$0, null);
            }

            private static final LocalizedString _init_$lambda$0() {
                return null;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lxyz/atrius/waystones/service/LinkService$LinkServiceError$NotRelinkable;", "Lxyz/atrius/waystones/service/LinkService$LinkServiceError;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "<init>", "(Lxyz/atrius/waystones/manager/LocalizationManager;)V", "waystones"})
        public static final class NotRelinkable
        extends LinkServiceError {
            public NotRelinkable(@NotNull LocalizationManager localization) {
                Intrinsics.checkNotNullParameter(localization, "localization");
                super(() -> NotRelinkable._init_$lambda$0(localization), null);
            }

            private static final LocalizedString _init_$lambda$0(LocalizationManager $localization) {
                return $localization.get("link-not-relinkable", new Object[0]);
            }
        }
    }
}

