/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.utility;

import java.util.Arrays;
import java.util.Collection;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.GameMode;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.atrius.Metadata;
import xyz.atrius.collections.CollectionsKt;
import xyz.atrius.jvm.internal.Intrinsics;
import xyz.atrius.waystones.manager.LocalizedString;
import xyz.atrius.waystones.utility.StringKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\t\u001a\u0014\u0010\n\u001a\u00020\u0006*\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\u0014\u0010\n\u001a\u00020\u0006*\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\t\u001a&\u0010\u000b\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\u0002\u001a#\u0010\u0012\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\"\u00020\u0015\u00a2\u0006\u0002\u0010\u0016\u001a\u001c\u0010\u0007\u001a\u00020\u0006*\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u001a\u001c\u0010\u0007\u001a\u00020\u0006*\u00020\u00172\u0006\u0010\u0007\u001a\u00020\t2\b\b\u0002\u0010\u0018\u001a\u00020\u0019\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001a"}, d2={"immortal", "", "Lorg/bukkit/entity/Player;", "getImmortal", "(Lorg/bukkit/entity/Player;)Z", "sendActionMessage", "", "message", "Lxyz/atrius/waystones/manager/LocalizedString;", "", "sendActionError", "playSound", "sound", "Lorg/bukkit/Sound;", "volume", "", "pitch", "hasPortalSickness", "addPotionEffects", "effects", "", "Lorg/bukkit/potion/PotionEffect;", "(Lorg/bukkit/entity/Player;[Lorg/bukkit/potion/PotionEffect;)Z", "Lorg/bukkit/command/CommandSender;", "colorCode", "", "waystones"})
public final class PlayerKt {
    public static final boolean getImmortal(@NotNull Player $this$immortal) {
        Intrinsics.checkNotNullParameter($this$immortal, "<this>");
        GameMode[] gameModeArray = new GameMode[]{GameMode.CREATIVE, GameMode.SPECTATOR};
        return CollectionsKt.listOf(gameModeArray).contains($this$immortal.getGameMode());
    }

    public static final void sendActionMessage(@NotNull Player $this$sendActionMessage, @Nullable LocalizedString message) {
        Intrinsics.checkNotNullParameter($this$sendActionMessage, "<this>");
        if (message != null) {
            PlayerKt.sendActionMessage($this$sendActionMessage, message.format($this$sendActionMessage));
        }
    }

    public static final void sendActionMessage(@NotNull Player $this$sendActionMessage, @Nullable String message) {
        Intrinsics.checkNotNullParameter($this$sendActionMessage, "<this>");
        if (message != null) {
            $this$sendActionMessage.sendActionBar(() -> PlayerKt.sendActionMessage$lambda$0(message));
        }
    }

    public static final void sendActionError(@NotNull Player $this$sendActionError, @Nullable LocalizedString message) {
        Intrinsics.checkNotNullParameter($this$sendActionError, "<this>");
        if (message != null) {
            PlayerKt.sendActionError($this$sendActionError, message.format($this$sendActionError));
        }
    }

    public static final void sendActionError(@NotNull Player $this$sendActionError, @Nullable String message) {
        Intrinsics.checkNotNullParameter($this$sendActionError, "<this>");
        if (message != null) {
            $this$sendActionError.sendActionBar(() -> PlayerKt.sendActionError$lambda$1(message));
        }
    }

    public static final void playSound(@NotNull Player $this$playSound, @NotNull Sound sound, float volume, float pitch) {
        Intrinsics.checkNotNullParameter($this$playSound, "<this>");
        Intrinsics.checkNotNullParameter(sound, "sound");
        $this$playSound.playSound($this$playSound.getLocation(), sound, volume, pitch);
    }

    public static /* synthetic */ void playSound$default(Player player, Sound sound, float f, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        if ((n & 4) != 0) {
            f2 = 1.0f;
        }
        PlayerKt.playSound(player, sound, f, f2);
    }

    public static final boolean hasPortalSickness(@NotNull Player $this$hasPortalSickness) {
        Intrinsics.checkNotNullParameter($this$hasPortalSickness, "<this>");
        PotionEffect potionEffect = $this$hasPortalSickness.getPotionEffect(PotionEffectType.NAUSEA);
        return (potionEffect != null ? potionEffect.getAmplifier() : 0) >= 4;
    }

    public static final boolean addPotionEffects(@NotNull Player $this$addPotionEffects, PotionEffect ... effects) {
        Intrinsics.checkNotNullParameter($this$addPotionEffects, "<this>");
        Intrinsics.checkNotNullParameter(effects, "effects");
        return $this$addPotionEffects.addPotionEffects((Collection)CollectionsKt.arrayListOf(Arrays.copyOf(effects, effects.length)));
    }

    public static final void message(@NotNull CommandSender $this$message, @NotNull LocalizedString message, char colorCode) {
        Intrinsics.checkNotNullParameter($this$message, "<this>");
        Intrinsics.checkNotNullParameter(message, "message");
        PlayerKt.message($this$message, message.format($this$message instanceof Player ? (Player)$this$message : null), colorCode);
    }

    public static /* synthetic */ void message$default(CommandSender commandSender, LocalizedString localizedString, char c, int n, Object object) {
        if ((n & 2) != 0) {
            c = (char)38;
        }
        PlayerKt.message(commandSender, localizedString, c);
    }

    public static final void message(@NotNull CommandSender $this$message, @NotNull String message, char colorCode) {
        Intrinsics.checkNotNullParameter($this$message, "<this>");
        Intrinsics.checkNotNullParameter(message, "message");
        $this$message.sendMessage(StringKt.translateColors(message, colorCode));
    }

    public static /* synthetic */ void message$default(CommandSender commandSender, String string, char c, int n, Object object) {
        if ((n & 2) != 0) {
            c = (char)38;
        }
        PlayerKt.message(commandSender, string, c);
    }

    private static final Component sendActionMessage$lambda$0(String $message) {
        return (Component)Component.text((String)$message);
    }

    private static final Component sendActionError$lambda$1(String $message) {
        Style.Builder builder = Style.style().color(TextColor.color((int)255, (int)0, (int)0)).decorate(TextDecoration.BOLD);
        Intrinsics.checkNotNullExpressionValue(builder, "decorate(...)");
        Style.Builder style = builder;
        return Component.text((String)$message).style(style);
    }
}

