/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.service;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.annotation.Single;
import xyz.atrius.Metadata;
import xyz.atrius.collections.CollectionsKt;
import xyz.atrius.collections.MapsKt;
import xyz.atrius.jvm.internal.Intrinsics;
import xyz.atrius.jvm.internal.Reflection;
import xyz.atrius.jvm.internal.SourceDebugExtension;
import xyz.atrius.jvm.internal.markers.KMappedMarker;
import xyz.atrius.ranges.RangesKt;
import xyz.atrius.waystones.data.JsonFile;
import xyz.atrius.waystones.data.config.property.WorldRatioProperty;
import xyz.atrius.waystones.data.json.RatioConfig;
import xyz.atrius.waystones.internal.KotlinPlugin;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Single
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010(\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003B\u001f\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005J\u0018\u0010\u0013\u001a\u00020\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u0006J\u0010\u0010\u0016\u001a\u00020\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0017\u001a\u00020\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0005J\u001d\u0010\u0019\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u001cJ\u001b\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u001eH\u0096\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lxyz/atrius/waystones/service/WorldRatioService;", "Lxyz/atrius/waystones/data/JsonFile;", "Lxyz/atrius/waystones/data/json/RatioConfig;", "", "", "Lorg/bukkit/World;", "", "gson", "Lcom/google/gson/Gson;", "plugin", "Lxyz/atrius/waystones/internal/KotlinPlugin;", "defaultRatioProperty", "Lxyz/atrius/waystones/data/config/property/WorldRatioProperty;", "<init>", "(Lcom/google/gson/Gson;Lxyz/atrius/waystones/internal/KotlinPlugin;Lxyz/atrius/waystones/data/config/property/WorldRatioProperty;)V", "load", "", "get", "world", "add", "", "ratio", "remove", "default", "isDefault", "getRatio", "from", "to", "(Lorg/bukkit/World;Lorg/bukkit/World;)Ljava/lang/Double;", "iterator", "", "waystones"})
@SourceDebugExtension(value={"SMAP\nWorldRatioService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldRatioService.kt\nxyz/atrius/waystones/service/WorldRatioService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n295#2,2:129\n1285#2,2:131\n1299#2,4:133\n*S KotlinDebug\n*F\n+ 1 WorldRatioService.kt\nxyz/atrius/waystones/service/WorldRatioService\n*L\n28#1:129,2\n122#1:131,2\n122#1:133,4\n*E\n"})
public final class WorldRatioService
extends JsonFile<RatioConfig>
implements Iterable<Map.Entry<? extends World, ? extends Double>>,
KMappedMarker {
    @NotNull
    private final WorldRatioProperty defaultRatioProperty;

    public WorldRatioService(@NotNull Gson gson, @NotNull KotlinPlugin plugin, @NotNull WorldRatioProperty defaultRatioProperty) {
        Intrinsics.checkNotNullParameter(gson, "gson");
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(defaultRatioProperty, "defaultRatioProperty");
        super("ratios", gson, plugin, Reflection.getOrCreateKotlinClass(RatioConfig.class));
        this.defaultRatioProperty = defaultRatioProperty;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void load() {
        Object v2;
        RatioConfig ratioConfig;
        block2: {
            void $this$firstOrNull$iv;
            super.load();
            if (((RatioConfig)this.getData()).getDefaultWorld() != null) {
                return;
            }
            RatioConfig ratioConfig2 = (RatioConfig)this.getData();
            List list = Bukkit.getWorlds();
            Intrinsics.checkNotNullExpressionValue(list, "getWorlds(...)");
            Iterable iterable = list;
            ratioConfig = ratioConfig2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                World it = (World)element$iv;
                boolean bl = false;
                if (!(it.getEnvironment() == World.Environment.NORMAL)) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        World world = v2;
        ratioConfig.setDefaultWorld(world != null ? world.getUID() : null);
        this.save();
    }

    public final double get(@Nullable World world) {
        Double d;
        HashMap<UUID, Double> hashMap;
        if (world == null) {
            return -1.0;
        }
        UUID uUID = world.getUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUID(...)");
        UUID uuid = uUID;
        if (Intrinsics.areEqual(((RatioConfig)this.getData()).getDefaultWorld(), uuid)) {
            return 1.0;
        }
        if (((RatioConfig)this.getData()).getRatios() == null) {
            ((RatioConfig)this.getData()).setRatios(new HashMap<UUID, Double>());
        }
        return (hashMap = ((RatioConfig)this.getData()).getRatios()) != null && (d = hashMap.get(uuid)) != null ? d.doubleValue() : ((Number)this.defaultRatioProperty.value()).doubleValue();
    }

    public final boolean add(@Nullable World world, double ratio) {
        if (world == null || Intrinsics.areEqual(((RatioConfig)this.getData()).getDefaultWorld(), world.getUID())) {
            return false;
        }
        if (((RatioConfig)this.getData()).getRatios() == null) {
            Intrinsics.areEqual(((RatioConfig)this.getData()).getRatios(), new HashMap());
        }
        HashMap<UUID, Double> hashMap = ((RatioConfig)this.getData()).getRatios();
        if (hashMap != null) {
            ((Map)hashMap).put(world.getUID(), ratio);
        }
        this.save();
        return true;
    }

    public final boolean remove(@Nullable World world) {
        if (world == null) {
            return false;
        }
        HashMap<UUID, Double> hashMap = ((RatioConfig)this.getData()).getRatios();
        Double removed = hashMap != null ? hashMap.remove(world.getUID()) : null;
        this.save();
        return removed != null;
    }

    public final boolean default(@Nullable World world) {
        if (world == null) {
            return false;
        }
        UUID uUID = world.getUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUID(...)");
        UUID uuid = uUID;
        if (((RatioConfig)this.getData()).getRatios() == null) {
            Intrinsics.areEqual(((RatioConfig)this.getData()).getRatios(), new HashMap());
        }
        ((RatioConfig)this.getData()).setDefaultWorld(uuid);
        HashMap<UUID, Double> hashMap = ((RatioConfig)this.getData()).getRatios();
        if ((hashMap != null ? (Map)hashMap : MapsKt.emptyMap()).containsKey(uuid)) {
            HashMap<UUID, Double> hashMap2 = ((RatioConfig)this.getData()).getRatios();
            if (hashMap2 != null) {
                hashMap2.remove(uuid);
            }
        }
        this.save();
        return true;
    }

    public final boolean isDefault(@NotNull World world) {
        Intrinsics.checkNotNullParameter(world, "world");
        return Intrinsics.areEqual(((RatioConfig)this.getData()).getDefaultWorld(), world.getUID());
    }

    @Nullable
    public final Double getRatio(@NotNull World from, @NotNull World to) {
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        if (Intrinsics.areEqual(from, to)) {
            return 1.0;
        }
        double fromRatio = this.get(from);
        double toRatio = this.get(to);
        if (fromRatio <= 0.0 || toRatio <= 0.0) {
            return null;
        }
        return toRatio / fromRatio;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterator<Map.Entry<World, Double>> iterator() {
        List list = Bukkit.getWorlds();
        Intrinsics.checkNotNullExpressionValue(list, "getWorlds(...)");
        Iterable $this$associateWith$iv = list;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            World world = (World)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Double d = this.get((World)it);
            map.put(t, d);
        }
        Map worlds = result$iv;
        return worlds.entrySet().iterator();
    }
}

