/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.jetbrains.annotations.NotNull;
import org.koin.core.annotation.Single;
import xyz.atrius.Metadata;
import xyz.atrius.collections.CollectionsKt;
import xyz.atrius.jvm.internal.Intrinsics;
import xyz.atrius.jvm.internal.SourceDebugExtension;
import xyz.atrius.waystones.repository.WaystoneInfoRepository;

@Single
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0007J&\u0010\u000e\u001a\u0012\u0012\u000e\u0012\f0\u0010\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\b\u00120\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lxyz/atrius/waystones/event/DestroyEvent;", "Lorg/bukkit/event/Listener;", "waystoneInfoRepository", "Lxyz/atrius/waystones/repository/WaystoneInfoRepository;", "<init>", "(Lxyz/atrius/waystones/repository/WaystoneInfoRepository;)V", "onBreak", "", "event", "Lorg/bukkit/event/block/BlockBreakEvent;", "onExplode", "Lorg/bukkit/event/block/BlockExplodeEvent;", "onEntityExplode", "Lorg/bukkit/event/entity/EntityExplodeEvent;", "destroy", "", "Lorg/bukkit/Location;", "Lorg/jetbrains/annotations/NotNull;", "Lxyz/atrius/jvm/internal/EnhancedNullability;", "blocks", "Lorg/bukkit/block/Block;", "waystones"})
@SourceDebugExtension(value={"SMAP\nDestroyEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DestroyEvent.kt\nxyz/atrius/waystones/event/DestroyEvent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n774#2:46\n865#2,2:47\n1563#2:49\n1634#2,3:50\n2756#2:53\n1#3:54\n*S KotlinDebug\n*F\n+ 1 DestroyEvent.kt\nxyz/atrius/waystones/event/DestroyEvent\n*L\n41#1:46\n41#1:47,2\n42#1:49\n42#1:50,3\n43#1:53\n43#1:54\n*E\n"})
public final class DestroyEvent
implements Listener {
    @NotNull
    private final WaystoneInfoRepository waystoneInfoRepository;

    public DestroyEvent(@NotNull WaystoneInfoRepository waystoneInfoRepository) {
        Intrinsics.checkNotNullParameter(waystoneInfoRepository, "waystoneInfoRepository");
        this.waystoneInfoRepository = waystoneInfoRepository;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onBreak(@NotNull BlockBreakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Block block = event.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        if (block2.getType() != Material.LODESTONE) {
            return;
        }
        Location location = block2.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.waystoneInfoRepository.deleteByLocation(location);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onExplode(@NotNull BlockExplodeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        List list = event.blockList();
        Intrinsics.checkNotNullExpressionValue(list, "blockList(...)");
        this.destroy(list);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onEntityExplode(@NotNull EntityExplodeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        List list = event.blockList();
        Intrinsics.checkNotNullExpressionValue(list, "blockList(...)");
        this.destroy(list);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Location> destroy(List<? extends Block> blocks) {
        void $this$mapTo$iv$iv;
        Block it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = blocks;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Block)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == Material.LODESTONE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Block)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getLocation());
        }
        Iterable $this$onEach$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2418$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
            it = (Location)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull(it);
            this.waystoneInfoRepository.deleteByLocation((Location)it);
        }
        return (List)iterable;
    }
}

