/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.command.waystones;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.koin.core.annotation.Single;
import xyz.atrius.Metadata;
import xyz.atrius.NoWhenBranchMatchedException;
import xyz.atrius.collections.CollectionsKt;
import xyz.atrius.jvm.JvmClassMappingKt;
import xyz.atrius.jvm.internal.Intrinsics;
import xyz.atrius.waystones.command.waystones.WaystoneSubcommand;
import xyz.atrius.waystones.data.config.ConfigProperty;
import xyz.atrius.waystones.data.config.ConfigPropertyBase;
import xyz.atrius.waystones.data.config.ListConfigProperty;
import xyz.atrius.waystones.manager.ConfigManager;
import xyz.atrius.waystones.manager.LocalizationManager;
import xyz.atrius.waystones.utility.CommandUtilsKt;
import xyz.atrius.waystones.utility.PlayerKt;

@Single
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\u0010\u0012\u0002\b\u00030\u000f2\u0010\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\u0010\u0012\u0002\b\u00030\u000fH\u0016J\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013\"\b\b\u0000\u0010\u0014*\u00020\u0015*\b\u0012\u0004\u0012\u0002H\u00140\u0016H\u0002J\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013\"\b\b\u0000\u0010\u0014*\u00020\u0015*\b\u0012\u0004\u0012\u0002H\u00140\u0017H\u0002JK\u0010\u0018\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00100\u0010 \u0019*\u0012\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\u00130\u0013\"\b\b\u0000\u0010\u0014*\u00020\u00152\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u0002H\u0014H\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J.\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001a\u001a\u00020\t2\u0012\u0010\u001b\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030%H\u0002J\"\u0010&\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0015H\u0002J\"\u0010'\u001a\u00020\u001e\"\b\b\u0000\u0010\u0014*\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006("}, d2={"Lxyz/atrius/waystones/command/waystones/ConfigCommand;", "Lxyz/atrius/waystones/command/waystones/WaystoneSubcommand;", "configManager", "Lxyz/atrius/waystones/manager/ConfigManager;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "<init>", "(Lxyz/atrius/waystones/manager/ConfigManager;Lxyz/atrius/waystones/manager/LocalizationManager;)V", "name", "", "getName", "()Ljava/lang/String;", "basePermission", "getBasePermission", "build", "Lcom/mojang/brigadier/builder/ArgumentBuilder;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "base", "toPropertySubcommand", "Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "T", "", "Lxyz/atrius/waystones/data/config/ConfigProperty;", "Lxyz/atrius/waystones/data/config/ListConfigProperty;", "resetArgument", "xyz.atrius.jvm.PlatformType", "property", "value", "(Ljava/lang/String;Ljava/lang/Object;)Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "listOptions", "", "sender", "Lorg/bukkit/command/CommandSender;", "getConfigPropertyMessage", "Lnet/kyori/adventure/text/Component;", "player", "Lorg/bukkit/entity/Player;", "Lxyz/atrius/waystones/data/config/ConfigPropertyBase;", "updatedPropertyMessage", "viewConfigValue", "waystones"})
public final class ConfigCommand
implements WaystoneSubcommand {
    @NotNull
    private final ConfigManager configManager;
    @NotNull
    private final LocalizationManager localization;
    @NotNull
    private final String name;
    @NotNull
    private final String basePermission;

    public ConfigCommand(@NotNull ConfigManager configManager, @NotNull LocalizationManager localization) {
        Intrinsics.checkNotNullParameter(configManager, "configManager");
        Intrinsics.checkNotNullParameter(localization, "localization");
        this.configManager = configManager;
        this.localization = localization;
        this.name = "config";
        this.basePermission = "waystones.config";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getBasePermission() {
        return this.basePermission;
    }

    @Override
    @NotNull
    public ArgumentBuilder<CommandSourceStack, ?> build(@NotNull ArgumentBuilder<CommandSourceStack, ?> base) {
        Intrinsics.checkNotNullParameter(base, "base");
        ArgumentBuilder configCommand = base.requires(ConfigCommand::build$lambda$0).executes(arg_0 -> ConfigCommand.build$lambda$1(this, arg_0));
        Iterator<Map.Entry<String, ConfigPropertyBase<?, ?, ?>>> iterator2 = this.configManager.iterator();
        while (iterator2.hasNext()) {
            LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder;
            ConfigPropertyBase<?, ?, ?> option = iterator2.next().getValue();
            ConfigPropertyBase<?, ?, ?> configPropertyBase = option;
            if (configPropertyBase instanceof ConfigProperty) {
                literalArgumentBuilder = this.toPropertySubcommand((ConfigProperty)option);
            } else if (configPropertyBase instanceof ListConfigProperty) {
                literalArgumentBuilder = this.toPropertySubcommand((ListConfigProperty)option);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            LiteralArgumentBuilder<CommandSourceStack> configSubcommand = literalArgumentBuilder;
            configCommand.then((ArgumentBuilder)configSubcommand);
        }
        Intrinsics.checkNotNull(configCommand);
        return configCommand;
    }

    private final <T> LiteralArgumentBuilder<CommandSourceStack> toPropertySubcommand(ConfigProperty<T> $this$toPropertySubcommand) {
        LiteralArgumentBuilder base = (LiteralArgumentBuilder)Commands.literal((String)$this$toPropertySubcommand.getProperty()).executes(arg_0 -> ConfigCommand.toPropertySubcommand$lambda$2(this, $this$toPropertySubcommand, arg_0));
        RequiredArgumentBuilder configProperty = (RequiredArgumentBuilder)Commands.argument((String)"value", $this$toPropertySubcommand.getParser()).executes(arg_0 -> ConfigCommand.toPropertySubcommand$lambda$3($this$toPropertySubcommand, this, arg_0));
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)base.then((ArgumentBuilder)this.resetArgument($this$toPropertySubcommand.getProperty(), $this$toPropertySubcommand.getDefault()))).then((ArgumentBuilder)configProperty);
        Intrinsics.checkNotNullExpressionValue(argumentBuilder, "then(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    private final <T> LiteralArgumentBuilder<CommandSourceStack> toPropertySubcommand(ListConfigProperty<T> $this$toPropertySubcommand) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)Commands.literal((String)$this$toPropertySubcommand.getProperty()).executes(arg_0 -> ConfigCommand.toPropertySubcommand$lambda$4(this, $this$toPropertySubcommand, arg_0));
        int maxArgs = ((Number)CollectionsKt.maxOrThrow((Iterable)$this$toPropertySubcommand.getSizes())).intValue();
        if (maxArgs <= 0) {
            Intrinsics.checkNotNull(root);
            return root;
        }
        RequiredArgumentBuilder requiredArgumentBuilder = Commands.argument((String)("value-" + maxArgs), $this$toPropertySubcommand.getParser());
        Intrinsics.checkNotNullExpressionValue(requiredArgumentBuilder, "argument(...)");
        RequiredArgumentBuilder tail = requiredArgumentBuilder;
        for (int i = maxArgs; 0 < i; --i) {
            if ($this$toPropertySubcommand.getSizes().contains(i)) {
                tail.executes(arg_0 -> ConfigCommand.toPropertySubcommand$lambda$5($this$toPropertySubcommand, this, arg_0));
            }
            if (i <= 1) continue;
            ArgumentBuilder argumentBuilder = Commands.argument((String)("value-" + (i - 1)), $this$toPropertySubcommand.getParser()).then((ArgumentBuilder)tail);
            Intrinsics.checkNotNullExpressionValue(argumentBuilder, "then(...)");
            tail = (RequiredArgumentBuilder)argumentBuilder;
        }
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)root.then((ArgumentBuilder)this.resetArgument($this$toPropertySubcommand.getProperty(), $this$toPropertySubcommand.getDefault()))).then((ArgumentBuilder)tail);
        Intrinsics.checkNotNullExpressionValue(argumentBuilder, "then(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    private final <T> LiteralArgumentBuilder<CommandSourceStack> resetArgument(String property, T value) {
        return (LiteralArgumentBuilder)Commands.literal((String)"reset").executes(arg_0 -> ConfigCommand.resetArgument$lambda$6(this, property, value, arg_0));
    }

    private final void listOptions(CommandSender sender) {
        Player player = sender instanceof Player ? (Player)sender : null;
        PlayerKt.message$default(sender, this.localization.get("plugin-header", new Object[0]).format(player), '\u0000', 2, null);
        Iterator<Map.Entry<String, ConfigPropertyBase<?, ?, ?>>> iterator2 = this.configManager.iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, ConfigPropertyBase<?, ?, ?>> entry = iterator2.next();
            String prop = entry.getKey();
            ConfigPropertyBase<?, ?, ?> value = entry.getValue();
            Component component = this.getConfigPropertyMessage(player, prop, value);
            sender.sendMessage(component);
        }
        PlayerKt.message$default(sender, this.localization.get("plugin-footer", new Object[0]).format(player), '\u0000', 2, null);
    }

    private final Component getConfigPropertyMessage(Player player, String property, ConfigPropertyBase<?, ?, ?> value) {
        Component component = Component.text((String)this.localization.get(value.getLocalizedInfoKey(), new Object[0]).format(player)).color(TextColor.color((int)0xFF00FF));
        Intrinsics.checkNotNullExpressionValue(component, "color(...)");
        TextComponent propertyInfo = (TextComponent)component;
        HoverEvent hoverEvent = HoverEvent.hoverEvent((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Object)propertyInfo);
        Intrinsics.checkNotNullExpressionValue(hoverEvent, "hoverEvent(...)");
        HoverEvent hover = hoverEvent;
        Component component2 = Component.text((String)value.format()).color(TextColor.color((int)65535));
        Intrinsics.checkNotNullExpressionValue(component2, "color(...)");
        TextComponent value2 = (TextComponent)component2;
        Component component3 = ((TextComponent)Component.text((String)(property + ": ")).hoverEvent((HoverEventSource)hover)).append((Component)value2);
        Intrinsics.checkNotNullExpressionValue(component3, "append(...)");
        return component3;
    }

    private final void updatedPropertyMessage(CommandSender sender, String property, Object value) {
        Object[] objectArray = new Object[]{property, value};
        PlayerKt.message$default(sender, this.localization.get("command-config-set", objectArray), '\u0000', 2, null);
    }

    private final <T> void viewConfigValue(CommandSender sender, String property) {
        ConfigProperty configProperty = this.configManager.getValueOrNull(property);
        ConfigPropertyBase prop = configProperty != null ? (ConfigPropertyBase)configProperty : (ConfigPropertyBase)this.configManager.getListValueOrNull(property);
        Object[] objectArray = new Object[2];
        objectArray[0] = property;
        ConfigPropertyBase configPropertyBase = prop;
        objectArray[1] = configPropertyBase != null ? configPropertyBase.format() : null;
        PlayerKt.message$default(sender, this.localization.get("command-config-view", objectArray), '\u0000', 2, null);
    }

    private static final boolean build$lambda$0(CommandSourceStack it) {
        return it.getSender().hasPermission("waystones.config");
    }

    private static final int build$lambda$1(ConfigCommand this$0, CommandContext it) {
        CommandSender commandSender = ((CommandSourceStack)it.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        this$0.listOptions(commandSender);
        return 1;
    }

    private static final int toPropertySubcommand$lambda$2(ConfigCommand this$0, ConfigProperty $this_toPropertySubcommand, CommandContext it) {
        CommandSender commandSender = ((CommandSourceStack)it.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        this$0.viewConfigValue(commandSender, $this_toPropertySubcommand.getProperty());
        return 1;
    }

    private static final int toPropertySubcommand$lambda$3(ConfigProperty $this_toPropertySubcommand, ConfigCommand this$0, CommandContext it) {
        Object value = it.getArgument("value", JvmClassMappingKt.getJavaClass($this_toPropertySubcommand.getPropertyType()));
        ConfigManager configManager = this$0.configManager;
        String string = $this_toPropertySubcommand.getProperty();
        Intrinsics.checkNotNull(value);
        ConfigProperty<Object> update = configManager.setProperty(string, value);
        CommandSender commandSender = ((CommandSourceStack)it.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        ConfigProperty<Object> configProperty = update;
        this$0.updatedPropertyMessage(commandSender, $this_toPropertySubcommand.getProperty(), configProperty != null ? configProperty.format() : null);
        return 1;
    }

    private static final int toPropertySubcommand$lambda$4(ConfigCommand this$0, ListConfigProperty $this_toPropertySubcommand, CommandContext it) {
        CommandSender commandSender = ((CommandSourceStack)it.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        this$0.viewConfigValue(commandSender, $this_toPropertySubcommand.getProperty());
        return 1;
    }

    private static final int toPropertySubcommand$lambda$5(ListConfigProperty $this_toPropertySubcommand, ConfigCommand this$0, CommandContext it) {
        Intrinsics.checkNotNull(it);
        List values = CommandUtilsKt.getArguments((CommandContext<CommandSourceStack>)it, "value", $this_toPropertySubcommand.getJavaClass());
        ListConfigProperty update = this$0.configManager.setProperty($this_toPropertySubcommand.getProperty(), values);
        CommandSender commandSender = ((CommandSourceStack)it.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        ListConfigProperty listConfigProperty = update;
        this$0.updatedPropertyMessage(commandSender, $this_toPropertySubcommand.getProperty(), listConfigProperty != null ? listConfigProperty.format() : null);
        return 1;
    }

    private static final int resetArgument$lambda$6(ConfigCommand this$0, String $property, Object $value, CommandContext it) {
        ConfigProperty<Object> update = this$0.configManager.setProperty($property, $value);
        CommandSender commandSender = ((CommandSourceStack)it.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        ConfigProperty<Object> configProperty = update;
        this$0.updatedPropertyMessage(commandSender, $property, configProperty != null ? configProperty.format() : null);
        return 1;
    }
}

