/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.utility;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.atrius.waystones.kotlin.Metadata;
import xyz.atrius.waystones.kotlin.jvm.internal.Intrinsics;
import xyz.atrius.waystones.utility.LocationKt;
import xyz.atrius.waystones.utility.PlayerKt;
import xyz.atrius.waystones.utility.StringKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a!\u0010\u0000\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0086\u0002\u00a2\u0006\u0002\u0010\u0006\u001a<\u0010\u0007\u001a\u00020\b\"\u0004\b\u0000\u0010\t*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\t0\u000b2\u0006\u0010\f\u001a\u0002H\tH\u0086\u0002\u00a2\u0006\u0002\u0010\r\u001a\u001a\u0010\u000e\u001a\u00020\b*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011\u00a8\u0006\u0013"}, d2={"get", "", "Lorg/jspecify/annotations/Nullable;", "Lorg/bukkit/inventory/meta/ItemMeta;", "key", "", "(Lorg/bukkit/inventory/meta/ItemMeta;Ljava/lang/String;)Ljava/lang/Integer;", "set", "", "T", "type", "Lorg/bukkit/persistence/PersistentDataType;", "value", "(Lorg/bukkit/inventory/meta/ItemMeta;Ljava/lang/String;Lorg/bukkit/persistence/PersistentDataType;Ljava/lang/Object;)V", "addItemNaturally", "Lorg/bukkit/inventory/PlayerInventory;", "original", "Lorg/bukkit/inventory/ItemStack;", "new", "waystones"})
public final class ItemKt {
    @Nullable
    public static final Integer get(@NotNull ItemMeta $this$get, @NotNull String key) {
        Intrinsics.checkNotNullParameter($this$get, "<this>");
        Intrinsics.checkNotNullParameter(key, "key");
        return (Integer)$this$get.getPersistentDataContainer().get(StringKt.toKey$default(key, null, 1, null), PersistentDataType.INTEGER);
    }

    public static final <T> void set(@NotNull ItemMeta $this$set, @NotNull String key, @NotNull PersistentDataType<T, T> type, T value) {
        Intrinsics.checkNotNullParameter($this$set, "<this>");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(type, "type");
        T t = value;
        if (t == null) {
            throw new IllegalStateException("Value must be provided!".toString());
        }
        $this$set.getPersistentDataContainer().set(StringKt.toKey$default(key, null, 1, null), type, t);
    }

    public static final void addItemNaturally(@NotNull PlayerInventory $this$addItemNaturally, @NotNull ItemStack original, @NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter($this$addItemNaturally, "<this>");
        Intrinsics.checkNotNullParameter(original, "original");
        Intrinsics.checkNotNullParameter(itemStack, "new");
        HumanEntity humanEntity = $this$addItemNaturally.getHolder();
        Intrinsics.checkNotNull(humanEntity, "null cannot be cast to non-null type org.bukkit.entity.Player");
        Player player = (Player)humanEntity;
        if (PlayerKt.getImmortal(player)) {
            ItemStack[] itemStackArray = new ItemStack[]{itemStack};
            $this$addItemNaturally.addItem(itemStackArray);
            return;
        }
        if (original.getAmount() == 1 && original.getType() == itemStack.getType()) {
            original.setItemMeta(itemStack.getItemMeta());
            return;
        }
        ItemStack[] itemStackArray = new ItemStack[]{itemStack};
        HashMap hashMap = $this$addItemNaturally.addItem(itemStackArray);
        Intrinsics.checkNotNullExpressionValue(hashMap, "addItem(...)");
        if (!((Map)hashMap).isEmpty()) {
            World world = player.getWorld();
            Location location = player.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            world.dropItem(LocationKt.getUP(location), itemStack);
        }
        int n = original.getAmount();
        original.setAmount(n + -1);
    }
}

