/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.service;

import arrow.core.Either;
import arrow.core.NonFatalOrThrowKt;
import arrow.core.raise.DefaultRaise;
import arrow.core.raise.Raise;
import arrow.core.raise.RaiseCancellationException;
import arrow.core.raise.RaiseKt;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Beacon;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.RespawnAnchor;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.annotation.Single;
import xyz.atrius.waystones.advancement.CleanEnergyAdvancement;
import xyz.atrius.waystones.advancement.GigawarpsAdvancement;
import xyz.atrius.waystones.dao.WaystoneInfo;
import xyz.atrius.waystones.data.FloodFill;
import xyz.atrius.waystones.data.config.property.BaseDistanceProperty;
import xyz.atrius.waystones.data.config.property.JumpWorldsProperty;
import xyz.atrius.waystones.data.config.property.LimitDistanceProperty;
import xyz.atrius.waystones.data.config.property.MaxWarpSizeProperty;
import xyz.atrius.waystones.data.config.property.PowerCostProperty;
import xyz.atrius.waystones.data.config.property.RequirePowerProperty;
import xyz.atrius.waystones.data.config.property.type.Power;
import xyz.atrius.waystones.kotlin.KotlinNothingValueException;
import xyz.atrius.waystones.kotlin.Metadata;
import xyz.atrius.waystones.kotlin.NoWhenBranchMatchedException;
import xyz.atrius.waystones.kotlin.jvm.functions.Function0;
import xyz.atrius.waystones.kotlin.jvm.functions.Function1;
import xyz.atrius.waystones.kotlin.jvm.internal.DefaultConstructorMarker;
import xyz.atrius.waystones.kotlin.jvm.internal.Intrinsics;
import xyz.atrius.waystones.kotlin.jvm.internal.SourceDebugExtension;
import xyz.atrius.waystones.kotlin.jvm.internal.SpreadBuilder;
import xyz.atrius.waystones.manager.AdvancementManager;
import xyz.atrius.waystones.manager.LocalizationManager;
import xyz.atrius.waystones.manager.LocalizedString;
import xyz.atrius.waystones.repository.WaystoneInfoRepository;
import xyz.atrius.waystones.service.BoostBlockService;
import xyz.atrius.waystones.service.WorldRatioService;
import xyz.atrius.waystones.utility.BlockKt;
import xyz.atrius.waystones.utility.LocationKt;

@Single
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0003?@ABo\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ*\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020'J,\u0010+\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020,0\u001f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010-\u001a\u00020.H\u0002J\u0016\u0010\u0014\u001a\u00020/2\u0006\u0010\"\u001a\u00020#2\u0006\u00100\u001a\u00020!J\u0016\u0010\u0012\u001a\u00020/2\u0006\u0010\"\u001a\u00020#2\u0006\u00100\u001a\u00020!J \u00101\u001a\u00020,2\u0006\u00102\u001a\u00020'2\u0006\u00103\u001a\u00020'2\u0006\u00104\u001a\u00020,H\u0002J\u0010\u00105\u001a\u0002062\b\u0010$\u001a\u0004\u0018\u00010%J\u0010\u00109\u001a\u0002062\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010:\u001a\u0002062\u0006\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010;\u001a\u0002062\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010<\u001a\u0002062\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u00107\u001a\u000206*\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108\u00a8\u0006B"}, d2={"Lxyz/atrius/waystones/service/WaystoneService;", "", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "jumpWorlds", "Lxyz/atrius/waystones/data/config/property/JumpWorldsProperty;", "maxWarpSize", "Lxyz/atrius/waystones/data/config/property/MaxWarpSizeProperty;", "baseDistance", "Lxyz/atrius/waystones/data/config/property/BaseDistanceProperty;", "requirePower", "Lxyz/atrius/waystones/data/config/property/RequirePowerProperty;", "powerCost", "Lxyz/atrius/waystones/data/config/property/PowerCostProperty;", "boostBlockService", "Lxyz/atrius/waystones/service/BoostBlockService;", "advancementManager", "Lxyz/atrius/waystones/manager/AdvancementManager;", "cleanEnergyAdvancement", "Lxyz/atrius/waystones/advancement/CleanEnergyAdvancement;", "gigawarpsAdvancement", "Lxyz/atrius/waystones/advancement/GigawarpsAdvancement;", "worldRatioService", "Lxyz/atrius/waystones/service/WorldRatioService;", "limitDistance", "Lxyz/atrius/waystones/data/config/property/LimitDistanceProperty;", "waystoneInfoRepository", "Lxyz/atrius/waystones/repository/WaystoneInfoRepository;", "<init>", "(Lxyz/atrius/waystones/manager/LocalizationManager;Lxyz/atrius/waystones/data/config/property/JumpWorldsProperty;Lxyz/atrius/waystones/data/config/property/MaxWarpSizeProperty;Lxyz/atrius/waystones/data/config/property/BaseDistanceProperty;Lxyz/atrius/waystones/data/config/property/RequirePowerProperty;Lxyz/atrius/waystones/data/config/property/PowerCostProperty;Lxyz/atrius/waystones/service/BoostBlockService;Lxyz/atrius/waystones/manager/AdvancementManager;Lxyz/atrius/waystones/advancement/CleanEnergyAdvancement;Lxyz/atrius/waystones/advancement/GigawarpsAdvancement;Lxyz/atrius/waystones/service/WorldRatioService;Lxyz/atrius/waystones/data/config/property/LimitDistanceProperty;Lxyz/atrius/waystones/repository/WaystoneInfoRepository;)V", "process", "Larrow/core/Either;", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneServiceError;", "Lxyz/atrius/waystones/service/WaystoneService$Warp;", "player", "Lorg/bukkit/entity/Player;", "block", "Lorg/bukkit/block/Block;", "keyLocation", "Lorg/bukkit/Location;", "range", "", "waystone", "validateWarp", "", "name", "", "", "warp", "calculateDistance", "from", "to", "ratio", "isWaystone", "", "isPowered", "(Lorg/bukkit/block/Block;)Z", "hasNormalPower", "hasPower", "isInhibited", "hasInfinitePower", "getWarpState", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneStatus;", "Warp", "WaystoneServiceError", "WaystoneStatus", "waystones"})
@SourceDebugExtension(value={"SMAP\nWaystoneService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaystoneService.kt\nxyz/atrius/waystones/service/WaystoneService\n+ 2 Builders.kt\narrow/core/raise/RaiseKt__BuildersKt\n+ 3 Fold.kt\narrow/core/raise/RaiseKt__FoldKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Raise.kt\narrow/core/raise/RaiseKt__RaiseKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,269:1\n53#2:270\n53#2:284\n115#3:271\n142#3,11:272\n115#3:285\n142#3,3:286\n145#3,8:292\n1#4:283\n584#5:289\n584#5:290\n584#5:291\n188#6,3:300\n*S KotlinDebug\n*F\n+ 1 WaystoneService.kt\nxyz/atrius/waystones/service/WaystoneService\n*L\n50#1:270\n82#1:284\n50#1:271\n50#1:272,11\n82#1:285\n82#1:286,3\n82#1:292,8\n83#1:289\n102#1:290\n114#1:291\n148#1:300,3\n*E\n"})
public final class WaystoneService {
    @NotNull
    private final LocalizationManager localization;
    @NotNull
    private final JumpWorldsProperty jumpWorlds;
    @NotNull
    private final MaxWarpSizeProperty maxWarpSize;
    @NotNull
    private final BaseDistanceProperty baseDistance;
    @NotNull
    private final RequirePowerProperty requirePower;
    @NotNull
    private final PowerCostProperty powerCost;
    @NotNull
    private final BoostBlockService boostBlockService;
    @NotNull
    private final AdvancementManager advancementManager;
    @NotNull
    private final CleanEnergyAdvancement cleanEnergyAdvancement;
    @NotNull
    private final GigawarpsAdvancement gigawarpsAdvancement;
    @NotNull
    private final WorldRatioService worldRatioService;
    @NotNull
    private final LimitDistanceProperty limitDistance;
    @NotNull
    private final WaystoneInfoRepository waystoneInfoRepository;

    public WaystoneService(@NotNull LocalizationManager localization, @NotNull JumpWorldsProperty jumpWorlds, @NotNull MaxWarpSizeProperty maxWarpSize, @NotNull BaseDistanceProperty baseDistance, @NotNull RequirePowerProperty requirePower, @NotNull PowerCostProperty powerCost, @NotNull BoostBlockService boostBlockService, @NotNull AdvancementManager advancementManager, @NotNull CleanEnergyAdvancement cleanEnergyAdvancement, @NotNull GigawarpsAdvancement gigawarpsAdvancement, @NotNull WorldRatioService worldRatioService, @NotNull LimitDistanceProperty limitDistance, @NotNull WaystoneInfoRepository waystoneInfoRepository) {
        Intrinsics.checkNotNullParameter(localization, "localization");
        Intrinsics.checkNotNullParameter(jumpWorlds, "jumpWorlds");
        Intrinsics.checkNotNullParameter(maxWarpSize, "maxWarpSize");
        Intrinsics.checkNotNullParameter(baseDistance, "baseDistance");
        Intrinsics.checkNotNullParameter(requirePower, "requirePower");
        Intrinsics.checkNotNullParameter(powerCost, "powerCost");
        Intrinsics.checkNotNullParameter(boostBlockService, "boostBlockService");
        Intrinsics.checkNotNullParameter(advancementManager, "advancementManager");
        Intrinsics.checkNotNullParameter(cleanEnergyAdvancement, "cleanEnergyAdvancement");
        Intrinsics.checkNotNullParameter(gigawarpsAdvancement, "gigawarpsAdvancement");
        Intrinsics.checkNotNullParameter(worldRatioService, "worldRatioService");
        Intrinsics.checkNotNullParameter(limitDistance, "limitDistance");
        Intrinsics.checkNotNullParameter(waystoneInfoRepository, "waystoneInfoRepository");
        this.localization = localization;
        this.jumpWorlds = jumpWorlds;
        this.maxWarpSize = maxWarpSize;
        this.baseDistance = baseDistance;
        this.requirePower = requirePower;
        this.powerCost = powerCost;
        this.boostBlockService = boostBlockService;
        this.advancementManager = advancementManager;
        this.cleanEnergyAdvancement = cleanEnergyAdvancement;
        this.gigawarpsAdvancement = gigawarpsAdvancement;
        this.worldRatioService = worldRatioService;
        this.limitDistance = limitDistance;
        this.waystoneInfoRepository = waystoneInfoRepository;
    }

    @NotNull
    public final Either<WaystoneServiceError, Warp> process(@NotNull Player player, @NotNull Block block, @NotNull Location keyLocation) {
        Either either;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(block, "block");
        Intrinsics.checkNotNullParameter(keyLocation, "keyLocation");
        boolean $i$f$either = false;
        boolean $i$f$_foldOrThrow = false;
        boolean $i$f$_fold = false;
        DefaultRaise raise$iv$iv$iv = new DefaultRaise(false);
        try {
            Raise $this$process_u24lambda_u242 = (Raise)raise$iv$iv$iv;
            boolean bl = false;
            String name = (String)((CompletableFuture)this.waystoneInfoRepository.getWaystone(keyLocation).thenApplyAsync(arg_0 -> WaystoneService.process$lambda$2$lambda$1(arg_0 -> WaystoneService.process$lambda$2$lambda$0(this, player, arg_0), arg_0))).get();
            Intrinsics.checkNotNull(name);
            double distance = ((Number)$this$process_u24lambda_u242.bind(this.validateWarp(player, block, name))).doubleValue();
            boolean usePower = switch (WhenMappings.$EnumSwitchMapping$0[((Power)((Object)this.requirePower.value())).ordinal()]) {
                case 1 -> true;
                case 2 -> {
                    if (!this.hasInfinitePower(block)) {
                        Location v1 = player.getLocation();
                        Intrinsics.checkNotNullExpressionValue(v1, "getLocation(...)");
                        if (!LocationKt.sameDimension(v1, block.getWorld())) {
                            yield true;
                        }
                    }
                    yield false;
                }
                case 3 -> false;
                default -> throw new NoWhenBranchMatchedException();
            };
            Location location = block.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            Warp res$iv$iv$iv = new Warp(name, player, location, distance, usePower);
            raise$iv$iv$iv.complete();
            Warp it$iv = res$iv$iv$iv;
            boolean bl2 = false;
            either = (Either)new Either.Right((Object)it$iv);
        }
        catch (RaiseCancellationException e$iv$iv$iv) {
            raise$iv$iv$iv.complete();
            Object it$iv = RaiseKt.raisedOrRethrow((CancellationException)((CancellationException)((Object)e$iv$iv$iv)), (DefaultRaise)raise$iv$iv$iv);
            boolean bl = false;
            either = (Either)new Either.Left(it$iv);
        }
        catch (Throwable e$iv$iv$iv) {
            raise$iv$iv$iv.complete();
            Throwable it$iv$iv = NonFatalOrThrowKt.nonFatalOrThrow((Throwable)e$iv$iv$iv);
            boolean bl = false;
            throw it$iv$iv;
        }
        return either;
    }

    public final int range(@NotNull Location waystone) {
        Intrinsics.checkNotNullParameter(waystone, "waystone");
        Material[] materialArray = this.boostBlockService.getDefaultBlocks();
        Set<Map.Entry<Block, Integer>> set = new FloodFill(waystone, ((Number)this.maxWarpSize.value()).intValue(), Arrays.copyOf(materialArray, materialArray.length)).getBreakdown().entrySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-entries>(...)");
        Iterable iterable = set;
        int n = 0;
        for (Object t : iterable) {
            Map.Entry entry = (Map.Entry)t;
            int n2 = n;
            boolean bl = false;
            Intrinsics.checkNotNull(entry);
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, "component1(...)");
            Block block = (Block)k;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, "component2(...)");
            Integer count = (Integer)v;
            Function0<Integer> function0 = this.boostBlockService.getBlockMappings().get(block.getType());
            int n3 = count * (function0 != null ? ((Number)function0.invoke()).intValue() : 1);
            n = n2 + n3;
        }
        int range = n;
        return ((Number)this.baseDistance.value()).intValue() + range;
    }

    /*
     * WARNING - void declaration
     */
    private final Either<WaystoneServiceError, Double> validateWarp(Player player, Block block, String name) {
        Either either;
        boolean $i$f$either = false;
        boolean $i$f$_foldOrThrow = false;
        boolean $i$f$_fold = false;
        DefaultRaise raise$iv$iv$iv = new DefaultRaise(false);
        try {
            WaystoneServiceError state;
            Raise $this$validateWarp_u24lambda_u249 = (Raise)raise$iv$iv$iv;
            boolean bl = false;
            Raise raise = $this$validateWarp_u24lambda_u249;
            boolean condition$iv22 = this.isWaystone(block);
            boolean $i$f$ensure2 = false;
            if (!condition$iv22) {
                void $this$ensure$iv;
                void var13_16 = $this$ensure$iv;
                boolean bl2 = false;
                var13_16.raise((Object)new WaystoneServiceError.WaystoneSevered(this.localization, name));
                throw new KotlinNothingValueException();
            }
            WaystoneStatus condition$iv22 = this.getWarpState(player, block);
            WaystoneServiceError waystoneServiceError = condition$iv22 == null ? (WaystoneServiceError)new WaystoneServiceError.WaystoneSevered(this.localization, name) : (condition$iv22 instanceof WaystoneStatus.Inhibited ? (WaystoneServiceError)new WaystoneServiceError.WaystoneInhibited(this.localization, name) : (condition$iv22 instanceof WaystoneStatus.Unpowered ? (WaystoneServiceError)new WaystoneServiceError.WaystoneUnpowered(this.localization, name) : (state = condition$iv22 instanceof WaystoneStatus.Obstructed ? (WaystoneServiceError)new WaystoneServiceError.WaystoneObstructed(this.localization, name) : null)));
            if (state != null) {
                $this$validateWarp_u24lambda_u249.raise((Object)state);
                throw new KotlinNothingValueException();
            }
            Location location = player.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            Location location2 = block.getLocation();
            Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
            boolean interDimension = LocationKt.sameDimension(location, location2);
            if (interDimension) {
                Raise $i$f$ensure2 = $this$validateWarp_u24lambda_u249;
                boolean condition$iv = (Boolean)this.jumpWorlds.value();
                boolean $i$f$ensure3 = false;
                if (!condition$iv) {
                    void $this$ensure$iv;
                    void var13_17 = $this$ensure$iv;
                    boolean bl3 = false;
                    var13_17.raise((Object)new WaystoneServiceError.WaystoneWorldJumpDisabled(this.localization));
                    throw new KotlinNothingValueException();
                }
            }
            World world = player.getWorld();
            Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
            World world2 = block.getWorld();
            Intrinsics.checkNotNullExpressionValue(world2, "getWorld(...)");
            Double d = this.worldRatioService.getRatio(world, world2);
            if (d == null) {
                $this$validateWarp_u24lambda_u249.raise((Object)new WaystoneServiceError.WaystoneWorldJumpDisabled(this.localization));
                throw new KotlinNothingValueException();
            }
            double ratio = d;
            Location location3 = block.getLocation();
            Intrinsics.checkNotNullExpressionValue(location3, "getLocation(...)");
            double range = (double)this.range(location3) / ratio;
            Location location4 = player.getLocation();
            Intrinsics.checkNotNullExpressionValue(location4, "getLocation(...)");
            Location location5 = block.getLocation();
            Intrinsics.checkNotNullExpressionValue(location5, "getLocation(...)");
            double distance = this.calculateDistance(location4, location5, 1.0);
            if (!this.hasInfinitePower(block) && ((Boolean)this.limitDistance.value()).booleanValue()) {
                Raise raise2 = $this$validateWarp_u24lambda_u249;
                boolean condition$iv = distance <= range;
                boolean $i$f$ensure4 = false;
                if (!condition$iv) {
                    void $this$ensure$iv;
                    void var13_18 = $this$ensure$iv;
                    boolean bl4 = false;
                    Location location6 = block.getLocation();
                    Intrinsics.checkNotNullExpressionValue(location6, "getLocation(...)");
                    CompletionStage name2 = this.waystoneInfoRepository.getWaystone(location6).thenApplyAsync(arg_0 -> WaystoneService.validateWarp$lambda$9$lambda$8$lambda$7(arg_0 -> WaystoneService.validateWarp$lambda$9$lambda$8$lambda$6(this, player, arg_0), arg_0));
                    String string = (String)((CompletableFuture)name2).get();
                    Location location7 = block.getLocation();
                    Intrinsics.checkNotNullExpressionValue(location7, "getLocation(...)");
                    var13_18.raise((Object)new WaystoneServiceError.WaystoneOutOfRange(this.localization, string, distance, range, location7));
                    throw new KotlinNothingValueException();
                }
            }
            Double res$iv$iv$iv = distance;
            raise$iv$iv$iv.complete();
            Double it$iv = res$iv$iv$iv;
            boolean bl5 = false;
            either = (Either)new Either.Right((Object)it$iv);
        }
        catch (RaiseCancellationException e$iv$iv$iv) {
            raise$iv$iv$iv.complete();
            Object it$iv = RaiseKt.raisedOrRethrow((CancellationException)((CancellationException)((Object)e$iv$iv$iv)), (DefaultRaise)raise$iv$iv$iv);
            boolean bl = false;
            either = (Either)new Either.Left(it$iv);
        }
        catch (Throwable e$iv$iv$iv) {
            raise$iv$iv$iv.complete();
            Throwable it$iv$iv = NonFatalOrThrowKt.nonFatalOrThrow((Throwable)e$iv$iv$iv);
            boolean bl = false;
            throw it$iv$iv;
        }
        return either;
    }

    public final void gigawarpsAdvancement(@NotNull Player player, @NotNull Warp warp) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(warp, "warp");
        if (this.advancementManager.hasAdvancement(player, this.gigawarpsAdvancement)) {
            return;
        }
        if (warp.getDistance() > (double)(this.boostBlockService.maxDistance() / 2)) {
            this.advancementManager.awardAdvancement(player, this.gigawarpsAdvancement);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void cleanEnergyAdvancement(@NotNull Player player, @NotNull Warp warp) {
        boolean activeBeaconPresent;
        block5: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(warp, "warp");
            if (this.advancementManager.hasAdvancement(player, this.cleanEnergyAdvancement)) {
                return;
            }
            Location location = warp.getWarpLocation();
            int n = ((Number)this.maxWarpSize.value()).intValue();
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.addSpread(this.boostBlockService.getDefaultBlocks());
            spreadBuilder.add(Material.BEACON);
            FloodFill fill = new FloodFill(location, n, (Material[])spreadBuilder.toArray(new Material[spreadBuilder.size()]));
            Map map = fill.getBreakdown();
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                v2 = false;
            } else {
                Iterator iterator2 = $this$any$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator2.next();
                    boolean bl = false;
                    Block block = (Block)entry.getKey();
                    BlockState blockState = block.getState();
                    Beacon beacon = blockState instanceof Beacon ? (Beacon)blockState : null;
                    boolean bl2 = beacon != null ? BlockKt.isActive(beacon) : false;
                    if (!bl2) continue;
                    v2 = true;
                    break block5;
                }
                v2 = activeBeaconPresent = false;
            }
        }
        if (activeBeaconPresent) {
            this.advancementManager.awardAdvancement(player, this.cleanEnergyAdvancement);
        }
    }

    private final double calculateDistance(Location from, Location to, double ratio) {
        Vector vector = to.toVector().multiply(new Vector(ratio, 1.0, ratio));
        Intrinsics.checkNotNullExpressionValue(vector, "multiply(...)");
        Vector toNormalized = vector;
        return from.toVector().distance(toNormalized);
    }

    public final boolean isWaystone(@Nullable Block block) {
        Block block2 = block;
        return (block2 != null ? block2.getType() : null) == Material.LODESTONE;
    }

    private final boolean isPowered(Block $this$isPowered) {
        return !this.isInhibited($this$isPowered) && (this.hasInfinitePower($this$isPowered) || this.hasNormalPower($this$isPowered));
    }

    private final boolean hasNormalPower(Block block) {
        Block block2 = BlockKt.getPowerBlock(block);
        BlockData blockData = block2 != null ? block2.getBlockData() : null;
        RespawnAnchor respawnAnchor = blockData instanceof RespawnAnchor ? (RespawnAnchor)blockData : null;
        int charges = respawnAnchor != null ? respawnAnchor.getCharges() : 0;
        return charges >= ((Number)this.powerCost.value()).intValue();
    }

    private final boolean hasPower(Block block, Player player) {
        return switch (WhenMappings.$EnumSwitchMapping$0[((Power)((Object)this.requirePower.value())).ordinal()]) {
            case 2 -> {
                Location v0 = block.getLocation();
                Intrinsics.checkNotNullExpressionValue(v0, "getLocation(...)");
                Location v1 = player.getLocation();
                Intrinsics.checkNotNullExpressionValue(v1, "getLocation(...)");
                if (LocationKt.sameDimension(v0, v1) || this.isPowered(block)) {
                    yield true;
                }
                yield false;
            }
            case 1 -> this.isPowered(block);
            default -> true;
        };
    }

    private final boolean isInhibited(Block block) {
        Block block2 = BlockKt.getPowerBlock(block);
        return (block2 != null ? block2.getType() : null) == Material.OBSIDIAN;
    }

    private final boolean hasInfinitePower(Block block) {
        Block block2 = BlockKt.getPowerBlock(block);
        return (block2 != null ? block2.getType() : null) == Material.COMMAND_BLOCK;
    }

    @Nullable
    public final WaystoneStatus getWarpState(@NotNull Player player, @NotNull Block block) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(block, "block");
        if (!this.isWaystone(block)) {
            return null;
        }
        if (this.isInhibited(block)) {
            return new WaystoneStatus.Inhibited(this.localization);
        }
        if (!this.hasPower(block, player)) {
            return new WaystoneStatus.Unpowered(this.localization);
        }
        Location location = block.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        if (!LocationKt.isSafe(location)) {
            return new WaystoneStatus.Obstructed(this.localization);
        }
        if (this.hasInfinitePower(block) || !((Boolean)this.limitDistance.value()).booleanValue()) {
            return new WaystoneStatus.Infinite(this.localization);
        }
        Location location2 = block.getLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
        return new WaystoneStatus.Active(this.localization, this.range(location2));
    }

    private static final String process$lambda$2$lambda$0(WaystoneService this$0, Player $player, WaystoneInfo it) {
        Object object = it;
        if (object == null || (object = ((WaystoneInfo)object).getName()) == null) {
            object = this$0.localization.get("unnamed-waystone", new Object[0]).format($player);
        }
        return object;
    }

    private static final String process$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String validateWarp$lambda$9$lambda$8$lambda$6(WaystoneService this$0, Player $player, WaystoneInfo it) {
        Object object = it;
        if (object == null || (object = ((WaystoneInfo)object).getName()) == null) {
            object = this$0.localization.get("unnamed-waystone", new Object[0]).format($player);
        }
        return object;
    }

    private static final String validateWarp$lambda$9$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u000bH\u00c6\u0003J;\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u000b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lxyz/atrius/waystones/service/WaystoneService$Warp;", "", "name", "", "player", "Lorg/bukkit/entity/Player;", "warpLocation", "Lorg/bukkit/Location;", "distance", "", "usePower", "", "<init>", "(Ljava/lang/String;Lorg/bukkit/entity/Player;Lorg/bukkit/Location;DZ)V", "getName", "()Ljava/lang/String;", "getPlayer", "()Lorg/bukkit/entity/Player;", "getWarpLocation", "()Lorg/bukkit/Location;", "getDistance", "()D", "getUsePower", "()Z", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "waystones"})
    public static final class Warp {
        @NotNull
        private final String name;
        @NotNull
        private final Player player;
        @NotNull
        private final Location warpLocation;
        private final double distance;
        private final boolean usePower;

        public Warp(@NotNull String name, @NotNull Player player, @NotNull Location warpLocation, double distance, boolean usePower) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(warpLocation, "warpLocation");
            this.name = name;
            this.player = player;
            this.warpLocation = warpLocation;
            this.distance = distance;
            this.usePower = usePower;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Player getPlayer() {
            return this.player;
        }

        @NotNull
        public final Location getWarpLocation() {
            return this.warpLocation;
        }

        public final double getDistance() {
            return this.distance;
        }

        public final boolean getUsePower() {
            return this.usePower;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final Player component2() {
            return this.player;
        }

        @NotNull
        public final Location component3() {
            return this.warpLocation;
        }

        public final double component4() {
            return this.distance;
        }

        public final boolean component5() {
            return this.usePower;
        }

        @NotNull
        public final Warp copy(@NotNull String name, @NotNull Player player, @NotNull Location warpLocation, double distance, boolean usePower) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(warpLocation, "warpLocation");
            return new Warp(name, player, warpLocation, distance, usePower);
        }

        public static /* synthetic */ Warp copy$default(Warp warp, String string, Player player, Location location, double d, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = warp.name;
            }
            if ((n & 2) != 0) {
                player = warp.player;
            }
            if ((n & 4) != 0) {
                location = warp.warpLocation;
            }
            if ((n & 8) != 0) {
                d = warp.distance;
            }
            if ((n & 0x10) != 0) {
                bl = warp.usePower;
            }
            return warp.copy(string, player, location, d, bl);
        }

        @NotNull
        public String toString() {
            return "Warp(name=" + this.name + ", player=" + this.player + ", warpLocation=" + this.warpLocation + ", distance=" + this.distance + ", usePower=" + this.usePower + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.player.hashCode();
            result = result * 31 + this.warpLocation.hashCode();
            result = result * 31 + Double.hashCode(this.distance);
            result = result * 31 + Boolean.hashCode(this.usePower);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Warp)) {
                return false;
            }
            Warp warp = (Warp)other;
            if (!Intrinsics.areEqual(this.name, warp.name)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.player, warp.player)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.warpLocation, warp.warpLocation)) {
                return false;
            }
            if (Double.compare(this.distance, warp.distance) != 0) {
                return false;
            }
            return this.usePower == warp.usePower;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0006\t\n\u000b\f\r\u000eB\u0019\b\u0004\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0006\u000f\u0010\u0011\u0012\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lxyz/atrius/waystones/service/WaystoneService$WaystoneServiceError;", "", "message", "Lxyz/atrius/waystones/kotlin/Function0;", "Lxyz/atrius/waystones/manager/LocalizedString;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "getMessage", "()Lkotlin/jvm/functions/Function0;", "WaystoneSevered", "WaystoneInhibited", "WaystoneUnpowered", "WaystoneObstructed", "WaystoneWorldJumpDisabled", "WaystoneOutOfRange", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneServiceError$WaystoneInhibited;", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneServiceError$WaystoneObstructed;", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneServiceError$WaystoneOutOfRange;", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneServiceError$WaystoneSevered;", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneServiceError$WaystoneUnpowered;", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneServiceError$WaystoneWorldJumpDisabled;", "waystones"})
    public static abstract sealed class WaystoneServiceError {
        @NotNull
        private final Function0<LocalizedString> message;

        private WaystoneServiceError(Function0<LocalizedString> message) {
            this.message = message;
        }

        @NotNull
        public final Function0<LocalizedString> getMessage() {
            return this.message;
        }

        public /* synthetic */ WaystoneServiceError(Function0 message, DefaultConstructorMarker $constructor_marker) {
            this(message);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lxyz/atrius/waystones/service/WaystoneService$WaystoneServiceError$WaystoneInhibited;", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneServiceError;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "name", "", "<init>", "(Lxyz/atrius/waystones/manager/LocalizationManager;Ljava/lang/String;)V", "waystones"})
        public static final class WaystoneInhibited
        extends WaystoneServiceError {
            public WaystoneInhibited(@NotNull LocalizationManager localization, @NotNull String name) {
                Intrinsics.checkNotNullParameter(localization, "localization");
                Intrinsics.checkNotNullParameter(name, "name");
                super(() -> WaystoneInhibited._init_$lambda$0(localization, name), null);
            }

            private static final LocalizedString _init_$lambda$0(LocalizationManager $localization, String $name) {
                Object[] objectArray = new Object[]{$name};
                return $localization.get("warp-error-inhibited", objectArray);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lxyz/atrius/waystones/service/WaystoneService$WaystoneServiceError$WaystoneObstructed;", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneServiceError;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "name", "", "<init>", "(Lxyz/atrius/waystones/manager/LocalizationManager;Ljava/lang/String;)V", "waystones"})
        public static final class WaystoneObstructed
        extends WaystoneServiceError {
            public WaystoneObstructed(@NotNull LocalizationManager localization, @NotNull String name) {
                Intrinsics.checkNotNullParameter(localization, "localization");
                Intrinsics.checkNotNullParameter(name, "name");
                super(() -> WaystoneObstructed._init_$lambda$0(localization, name), null);
            }

            private static final LocalizedString _init_$lambda$0(LocalizationManager $localization, String $name) {
                Object[] objectArray = new Object[]{$name};
                return $localization.get("warp-error-obstructed", objectArray);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lxyz/atrius/waystones/service/WaystoneService$WaystoneServiceError$WaystoneOutOfRange;", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneServiceError;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "name", "", "distance", "", "range", "location", "Lorg/bukkit/Location;", "<init>", "(Lxyz/atrius/waystones/manager/LocalizationManager;Ljava/lang/String;DDLorg/bukkit/Location;)V", "waystones"})
        public static final class WaystoneOutOfRange
        extends WaystoneServiceError {
            public WaystoneOutOfRange(@NotNull LocalizationManager localization, @Nullable String name, double distance, double range, @NotNull Location location) {
                Intrinsics.checkNotNullParameter(localization, "localization");
                Intrinsics.checkNotNullParameter(location, "location");
                super(() -> WaystoneOutOfRange._init_$lambda$0(localization, name, distance, range, location), null);
            }

            private static final LocalizedString _init_$lambda$0(LocalizationManager $localization, String $name, double $distance, double $range, Location $location) {
                Object[] objectArray = new Object[]{$name, $distance - $range, $range, $location.getX(), $location.getZ()};
                return $localization.get("warp-out-of-range", objectArray);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lxyz/atrius/waystones/service/WaystoneService$WaystoneServiceError$WaystoneSevered;", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneServiceError;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "name", "", "<init>", "(Lxyz/atrius/waystones/manager/LocalizationManager;Ljava/lang/String;)V", "waystones"})
        public static final class WaystoneSevered
        extends WaystoneServiceError {
            public WaystoneSevered(@NotNull LocalizationManager localization, @NotNull String name) {
                Intrinsics.checkNotNullParameter(localization, "localization");
                Intrinsics.checkNotNullParameter(name, "name");
                super(() -> WaystoneSevered._init_$lambda$0(localization, name), null);
            }

            private static final LocalizedString _init_$lambda$0(LocalizationManager $localization, String $name) {
                Object[] objectArray = new Object[]{$name};
                return $localization.get("warp-error", objectArray);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lxyz/atrius/waystones/service/WaystoneService$WaystoneServiceError$WaystoneUnpowered;", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneServiceError;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "name", "", "<init>", "(Lxyz/atrius/waystones/manager/LocalizationManager;Ljava/lang/String;)V", "waystones"})
        public static final class WaystoneUnpowered
        extends WaystoneServiceError {
            public WaystoneUnpowered(@NotNull LocalizationManager localization, @NotNull String name) {
                Intrinsics.checkNotNullParameter(localization, "localization");
                Intrinsics.checkNotNullParameter(name, "name");
                super(() -> WaystoneUnpowered._init_$lambda$0(localization, name), null);
            }

            private static final LocalizedString _init_$lambda$0(LocalizationManager $localization, String $name) {
                Object[] objectArray = new Object[]{$name};
                return $localization.get("warp-error-unpowered", objectArray);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lxyz/atrius/waystones/service/WaystoneService$WaystoneServiceError$WaystoneWorldJumpDisabled;", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneServiceError;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "<init>", "(Lxyz/atrius/waystones/manager/LocalizationManager;)V", "waystones"})
        public static final class WaystoneWorldJumpDisabled
        extends WaystoneServiceError {
            public WaystoneWorldJumpDisabled(@NotNull LocalizationManager localization) {
                Intrinsics.checkNotNullParameter(localization, "localization");
                super(() -> WaystoneWorldJumpDisabled._init_$lambda$0(localization), null);
            }

            private static final LocalizedString _init_$lambda$0(LocalizationManager $localization) {
                return $localization.get("world-jump-disabled", new Object[0]);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0005\t\n\u000b\f\rB\u0019\b\u0004\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0005\u000e\u000f\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lxyz/atrius/waystones/service/WaystoneService$WaystoneStatus;", "", "message", "Lxyz/atrius/waystones/kotlin/Function0;", "Lxyz/atrius/waystones/manager/LocalizedString;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "getMessage", "()Lkotlin/jvm/functions/Function0;", "Inhibited", "Unpowered", "Obstructed", "Active", "Infinite", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneStatus$Active;", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneStatus$Infinite;", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneStatus$Inhibited;", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneStatus$Obstructed;", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneStatus$Unpowered;", "waystones"})
    public static abstract sealed class WaystoneStatus {
        @NotNull
        private final Function0<LocalizedString> message;

        private WaystoneStatus(Function0<LocalizedString> message) {
            this.message = message;
        }

        @NotNull
        public final Function0<LocalizedString> getMessage() {
            return this.message;
        }

        public /* synthetic */ WaystoneStatus(Function0 message, DefaultConstructorMarker $constructor_marker) {
            this(message);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lxyz/atrius/waystones/service/WaystoneService$WaystoneStatus$Active;", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneStatus;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "range", "", "<init>", "(Lxyz/atrius/waystones/manager/LocalizationManager;I)V", "waystones"})
        public static final class Active
        extends WaystoneStatus {
            public Active(@NotNull LocalizationManager localization, int range) {
                Intrinsics.checkNotNullParameter(localization, "localization");
                super(() -> Active._init_$lambda$0(localization, range), null);
            }

            private static final LocalizedString _init_$lambda$0(LocalizationManager $localization, int $range) {
                Object[] objectArray = new Object[]{0, $range};
                return $localization.get("waystone-status", objectArray);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lxyz/atrius/waystones/service/WaystoneService$WaystoneStatus$Infinite;", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneStatus;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "<init>", "(Lxyz/atrius/waystones/manager/LocalizationManager;)V", "waystones"})
        public static final class Infinite
        extends WaystoneStatus {
            public Infinite(@NotNull LocalizationManager localization) {
                Intrinsics.checkNotNullParameter(localization, "localization");
                super(() -> Infinite._init_$lambda$0(localization), null);
            }

            private static final LocalizedString _init_$lambda$0(LocalizationManager $localization) {
                Object[] objectArray = new Object[]{1};
                return $localization.get("waystone-status", objectArray);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lxyz/atrius/waystones/service/WaystoneService$WaystoneStatus$Inhibited;", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneStatus;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "<init>", "(Lxyz/atrius/waystones/manager/LocalizationManager;)V", "waystones"})
        public static final class Inhibited
        extends WaystoneStatus {
            public Inhibited(@NotNull LocalizationManager localization) {
                Intrinsics.checkNotNullParameter(localization, "localization");
                super(() -> Inhibited._init_$lambda$0(localization), null);
            }

            private static final LocalizedString _init_$lambda$0(LocalizationManager $localization) {
                Object[] objectArray = new Object[]{-3};
                return $localization.get("waystone-status", objectArray);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lxyz/atrius/waystones/service/WaystoneService$WaystoneStatus$Obstructed;", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneStatus;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "<init>", "(Lxyz/atrius/waystones/manager/LocalizationManager;)V", "waystones"})
        public static final class Obstructed
        extends WaystoneStatus {
            public Obstructed(@NotNull LocalizationManager localization) {
                Intrinsics.checkNotNullParameter(localization, "localization");
                super(() -> Obstructed._init_$lambda$0(localization), null);
            }

            private static final LocalizedString _init_$lambda$0(LocalizationManager $localization) {
                Object[] objectArray = new Object[]{-1};
                return $localization.get("waystone-status", objectArray);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lxyz/atrius/waystones/service/WaystoneService$WaystoneStatus$Unpowered;", "Lxyz/atrius/waystones/service/WaystoneService$WaystoneStatus;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "<init>", "(Lxyz/atrius/waystones/manager/LocalizationManager;)V", "waystones"})
        public static final class Unpowered
        extends WaystoneStatus {
            public Unpowered(@NotNull LocalizationManager localization) {
                Intrinsics.checkNotNullParameter(localization, "localization");
                super(() -> Unpowered._init_$lambda$0(localization), null);
            }

            private static final LocalizedString _init_$lambda$0(LocalizationManager $localization) {
                Object[] objectArray = new Object[]{-2};
                return $localization.get("waystone-status", objectArray);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Power.values().length];
            try {
                nArray[Power.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Power.INTER_DIMENSION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Power.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

