/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.service;

import arrow.core.Either;
import arrow.core.NonFatalOrThrowKt;
import arrow.core.raise.DefaultRaise;
import arrow.core.raise.Raise;
import arrow.core.raise.RaiseCancellationException;
import arrow.core.raise.RaiseKt;
import java.util.concurrent.CancellationException;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.annotation.Single;
import xyz.atrius.waystones.data.config.property.EnableKeyItemsProperty;
import xyz.atrius.waystones.data.config.property.PortalSicknessWarpingProperty;
import xyz.atrius.waystones.data.config.property.SingleUseProperty;
import xyz.atrius.waystones.data.config.property.type.SicknessOption;
import xyz.atrius.waystones.kotlin.KotlinNothingValueException;
import xyz.atrius.waystones.kotlin.Metadata;
import xyz.atrius.waystones.kotlin.jvm.functions.Function0;
import xyz.atrius.waystones.kotlin.jvm.internal.DefaultConstructorMarker;
import xyz.atrius.waystones.kotlin.jvm.internal.Intrinsics;
import xyz.atrius.waystones.kotlin.jvm.internal.SourceDebugExtension;
import xyz.atrius.waystones.manager.LocalizationManager;
import xyz.atrius.waystones.manager.LocalizedString;
import xyz.atrius.waystones.utility.ItemKt;
import xyz.atrius.waystones.utility.PlayerKt;

@Single
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\"\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J$\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00190\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lxyz/atrius/waystones/service/KeyService;", "", "singleUse", "Lxyz/atrius/waystones/data/config/property/SingleUseProperty;", "portalSickWarping", "Lxyz/atrius/waystones/data/config/property/PortalSicknessWarpingProperty;", "enableKeyItems", "Lxyz/atrius/waystones/data/config/property/EnableKeyItemsProperty;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "<init>", "(Lxyz/atrius/waystones/data/config/property/SingleUseProperty;Lxyz/atrius/waystones/data/config/property/PortalSicknessWarpingProperty;Lxyz/atrius/waystones/data/config/property/EnableKeyItemsProperty;Lxyz/atrius/waystones/manager/LocalizationManager;)V", "process", "Larrow/core/Either;", "Lxyz/atrius/waystones/service/KeyService$KeyServiceError;", "Lxyz/atrius/waystones/service/KeyService$Key;", "player", "Lorg/bukkit/entity/Player;", "event", "Lorg/bukkit/event/player/PlayerInteractEvent;", "isWarpKey", "", "key", "Lorg/bukkit/inventory/ItemStack;", "validateKey", "Lorg/bukkit/Location;", "Key", "KeyServiceError", "waystones"})
@SourceDebugExtension(value={"SMAP\nKeyService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyService.kt\nxyz/atrius/waystones/service/KeyService\n+ 2 Builders.kt\narrow/core/raise/RaiseKt__BuildersKt\n+ 3 Fold.kt\narrow/core/raise/RaiseKt__FoldKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Raise.kt\narrow/core/raise/RaiseKt__RaiseKt\n*L\n1#1,94:1\n53#2:95\n53#2:109\n115#3:96\n142#3,3:97\n145#3,8:101\n115#3:110\n142#3,3:111\n145#3,8:118\n1#4:100\n584#5:114\n584#5:115\n584#5:116\n629#5:117\n*S KotlinDebug\n*F\n+ 1 KeyService.kt\nxyz/atrius/waystones/service/KeyService\n*L\n33#1:95\n50#1:109\n33#1:96\n33#1:97,3\n33#1:101,8\n50#1:110\n50#1:111,3\n50#1:118,8\n54#1:114\n58#1:115\n62#1:116\n66#1:117\n*E\n"})
public final class KeyService {
    @NotNull
    private final SingleUseProperty singleUse;
    @NotNull
    private final PortalSicknessWarpingProperty portalSickWarping;
    @NotNull
    private final EnableKeyItemsProperty enableKeyItems;
    @NotNull
    private final LocalizationManager localization;

    public KeyService(@NotNull SingleUseProperty singleUse, @NotNull PortalSicknessWarpingProperty portalSickWarping, @NotNull EnableKeyItemsProperty enableKeyItems, @NotNull LocalizationManager localization) {
        Intrinsics.checkNotNullParameter(singleUse, "singleUse");
        Intrinsics.checkNotNullParameter(portalSickWarping, "portalSickWarping");
        Intrinsics.checkNotNullParameter(enableKeyItems, "enableKeyItems");
        Intrinsics.checkNotNullParameter(localization, "localization");
        this.singleUse = singleUse;
        this.portalSickWarping = portalSickWarping;
        this.enableKeyItems = enableKeyItems;
        this.localization = localization;
    }

    @NotNull
    public final Either<KeyServiceError, Key> process(@NotNull Player player, @NotNull PlayerInteractEvent event) {
        Either either;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(event, "event");
        boolean $i$f$either = false;
        boolean $i$f$_foldOrThrow = false;
        boolean $i$f$_fold = false;
        DefaultRaise raise$iv$iv$iv = new DefaultRaise(false);
        try {
            ItemStack itemStack;
            Raise $this$process_u24lambda_u241 = (Raise)raise$iv$iv$iv;
            boolean bl = false;
            PlayerInventory playerInventory = player.getInventory();
            Intrinsics.checkNotNullExpressionValue(playerInventory, "getInventory(...)");
            PlayerInventory inventory = playerInventory;
            ItemStack it = itemStack = inventory.getItemInMainHand();
            boolean bl2 = false;
            Object object = event.getHand() == EquipmentSlot.HAND || it.getType() == Material.COMPASS ? itemStack : null;
            if (object == null) {
                ItemStack itemStack2 = inventory.getItemInOffHand();
                object = itemStack2;
                Intrinsics.checkNotNullExpressionValue(itemStack2, "getItemInOffHand(...)");
            }
            ItemStack item = object;
            Location lodestoneLocation = (Location)$this$process_u24lambda_u241.bind(this.validateKey(player, item));
            Key res$iv$iv$iv = new Key(lodestoneLocation, player, item, (Boolean)this.singleUse.value());
            raise$iv$iv$iv.complete();
            Key it$iv = res$iv$iv$iv;
            boolean bl3 = false;
            either = (Either)new Either.Right((Object)it$iv);
        }
        catch (RaiseCancellationException e$iv$iv$iv) {
            raise$iv$iv$iv.complete();
            Object it$iv = RaiseKt.raisedOrRethrow((CancellationException)((CancellationException)((Object)e$iv$iv$iv)), (DefaultRaise)raise$iv$iv$iv);
            boolean bl = false;
            either = (Either)new Either.Left(it$iv);
        }
        catch (Throwable e$iv$iv$iv) {
            raise$iv$iv$iv.complete();
            Throwable it$iv$iv = NonFatalOrThrowKt.nonFatalOrThrow((Throwable)e$iv$iv$iv);
            boolean bl = false;
            throw it$iv$iv;
        }
        return either;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isWarpKey(@NotNull ItemStack key) {
        Intrinsics.checkNotNullParameter(key, "key");
        if (((Boolean)this.enableKeyItems.value()).booleanValue()) {
            ItemMeta itemMeta = key.getItemMeta();
            if (itemMeta == null) return false;
            Integer n = ItemKt.get(itemMeta, "is_warp_key");
            int n2 = 1;
            if (n == null) return false;
            if (n != n2) return false;
            return true;
        }
        if (key.getType() != Material.COMPASS) return false;
        ItemMeta itemMeta = key.getItemMeta();
        if (!(itemMeta instanceof CompassMeta)) return false;
        CompassMeta compassMeta = (CompassMeta)itemMeta;
        if (compassMeta == null) return false;
        Location location = compassMeta.getLodestone();
        if (location == null) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final Either<KeyServiceError, Location> validateKey(Player player, ItemStack key) {
        $i$f$either = false;
        $i$f$_foldOrThrow = false;
        $i$f$_fold = false;
        raise$iv$iv$iv = new DefaultRaise(false);
        try {
            $this$validateKey_u24lambda_u246 = (Raise)raise$iv$iv$iv;
            $i$a$-either-KeyService$validateKey$1 = false;
            var9_9 = key.getItemMeta();
            v0 = meta = var9_9 instanceof CompassMeta != false ? (CompassMeta)var9_9 : null;
            lodestone = v0 != null ? v0.getLodestone() : null;
            var11_11 = $this$validateKey_u24lambda_u246;
            condition$iv = this.isWarpKey(key);
            $i$f$ensure = false;
            if (!condition$iv) {
                var14_15 = $this$ensure$iv;
                $i$a$-ensure-KeyService$validateKey$1$1 = false;
                var14_15.raise((Object)KeyServiceError.Ignore.INSTANCE);
                throw new KotlinNothingValueException();
            }
            $this$ensure$iv = $this$validateKey_u24lambda_u246;
            v1 = meta;
            if (v1 != null ? v1.hasLodestone() : false) ** GOTO lbl-1000
            v2 = meta;
            v3 = v2 != null ? !v2.isLodestoneTracked() : false;
            if (v3) lbl-1000:
            // 2 sources

            {
                v4 = true;
            } else {
                v4 = false;
            }
            condition$iv = v4;
            $i$f$ensure = false;
            if (!condition$iv) {
                var14_16 = $this$ensure$iv;
                $i$a$-ensure-KeyService$validateKey$1$2 = false;
                var14_16.raise((Object)new KeyServiceError.Severed(this.localization));
                throw new KotlinNothingValueException();
            }
            $this$ensure$iv = $this$validateKey_u24lambda_u246;
            condition$iv = PlayerKt.hasPortalSickness(player) == false && this.portalSickWarping.value() != SicknessOption.PREVENT_TELEPORT;
            $i$f$ensure = false;
            if (!condition$iv) {
                var14_17 = $this$ensure$iv;
                $i$a$-ensure-KeyService$validateKey$1$3 = false;
                var14_17.raise((Object)new KeyServiceError.Blocked(this.localization));
                throw new KotlinNothingValueException();
            }
            $this$ensure$iv = $this$validateKey_u24lambda_u246;
            value$iv = lodestone;
            $i$f$ensureNotNull = false;
            v5 = value$iv;
            if (v5 == null) {
                var14_18 = $this$ensureNotNull$iv;
                $i$a$-ensureNotNull-KeyService$validateKey$1$4 = false;
                var14_18.raise((Object)KeyServiceError.Ignore.INSTANCE);
                throw new KotlinNothingValueException();
            }
            res$iv$iv$iv = v5;
            raise$iv$iv$iv.complete();
            it$iv = res$iv$iv$iv;
            $i$a$-_foldOrThrow-RaiseKt__BuildersKt$either$2$iv = false;
            var16_23 = (Either)new Either.Right((Object)it$iv);
        }
        catch (RaiseCancellationException e$iv$iv$iv) {
            raise$iv$iv$iv.complete();
            it$iv = RaiseKt.raisedOrRethrow((CancellationException)((CancellationException)e$iv$iv$iv), (DefaultRaise)raise$iv$iv$iv);
            $i$a$-_foldOrThrow-RaiseKt__BuildersKt$either$1$iv = false;
            var16_23 = (Either)new Either.Left(it$iv);
        }
        catch (Throwable e$iv$iv$iv) {
            raise$iv$iv$iv.complete();
            it$iv$iv = NonFatalOrThrowKt.nonFatalOrThrow((Throwable)e$iv$iv$iv);
            $i$a$-_fold-RaiseKt__FoldKt$fold$10$iv$iv = false;
            throw it$iv$iv;
        }
        return var16_23;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c2\u0003J\t\u0010\u0013\u001a\u00020\tH\u00c2\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lxyz/atrius/waystones/service/KeyService$Key;", "", "location", "Lorg/bukkit/Location;", "player", "Lorg/bukkit/entity/Player;", "keyItem", "Lorg/bukkit/inventory/ItemStack;", "singleUse", "", "<init>", "(Lorg/bukkit/Location;Lorg/bukkit/entity/Player;Lorg/bukkit/inventory/ItemStack;Z)V", "getLocation", "()Lorg/bukkit/Location;", "useKey", "", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "waystones"})
    public static final class Key {
        @NotNull
        private final Location location;
        @NotNull
        private final Player player;
        @NotNull
        private final ItemStack keyItem;
        private final boolean singleUse;

        public Key(@NotNull Location location, @NotNull Player player, @NotNull ItemStack keyItem, boolean singleUse) {
            Intrinsics.checkNotNullParameter(location, "location");
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(keyItem, "keyItem");
            this.location = location;
            this.player = player;
            this.keyItem = keyItem;
            this.singleUse = singleUse;
        }

        @NotNull
        public final Location getLocation() {
            return this.location;
        }

        public final void useKey() {
            if (this.singleUse && !PlayerKt.getImmortal(this.player)) {
                ItemStack itemStack = this.keyItem;
                int n = itemStack.getAmount();
                itemStack.setAmount(n + -1);
            }
        }

        @NotNull
        public final Location component1() {
            return this.location;
        }

        private final Player component2() {
            return this.player;
        }

        private final ItemStack component3() {
            return this.keyItem;
        }

        private final boolean component4() {
            return this.singleUse;
        }

        @NotNull
        public final Key copy(@NotNull Location location, @NotNull Player player, @NotNull ItemStack keyItem, boolean singleUse) {
            Intrinsics.checkNotNullParameter(location, "location");
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(keyItem, "keyItem");
            return new Key(location, player, keyItem, singleUse);
        }

        public static /* synthetic */ Key copy$default(Key key, Location location, Player player, ItemStack itemStack, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                location = key.location;
            }
            if ((n & 2) != 0) {
                player = key.player;
            }
            if ((n & 4) != 0) {
                itemStack = key.keyItem;
            }
            if ((n & 8) != 0) {
                bl = key.singleUse;
            }
            return key.copy(location, player, itemStack, bl);
        }

        @NotNull
        public String toString() {
            return "Key(location=" + this.location + ", player=" + this.player + ", keyItem=" + this.keyItem + ", singleUse=" + this.singleUse + ")";
        }

        public int hashCode() {
            int result = this.location.hashCode();
            result = result * 31 + this.player.hashCode();
            result = result * 31 + this.keyItem.hashCode();
            result = result * 31 + Boolean.hashCode(this.singleUse);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key key = (Key)other;
            if (!Intrinsics.areEqual(this.location, key.location)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.player, key.player)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.keyItem, key.keyItem)) {
                return false;
            }
            return this.singleUse == key.singleUse;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\t\n\u000bB\u0019\b\u0004\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0003\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lxyz/atrius/waystones/service/KeyService$KeyServiceError;", "", "message", "Lxyz/atrius/waystones/kotlin/Function0;", "Lxyz/atrius/waystones/manager/LocalizedString;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "getMessage", "()Lkotlin/jvm/functions/Function0;", "Ignore", "Severed", "Blocked", "Lxyz/atrius/waystones/service/KeyService$KeyServiceError$Blocked;", "Lxyz/atrius/waystones/service/KeyService$KeyServiceError$Ignore;", "Lxyz/atrius/waystones/service/KeyService$KeyServiceError$Severed;", "waystones"})
    public static abstract sealed class KeyServiceError {
        @NotNull
        private final Function0<LocalizedString> message;

        private KeyServiceError(Function0<LocalizedString> message) {
            this.message = message;
        }

        @NotNull
        public final Function0<LocalizedString> getMessage() {
            return this.message;
        }

        public /* synthetic */ KeyServiceError(Function0 message, DefaultConstructorMarker $constructor_marker) {
            this(message);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lxyz/atrius/waystones/service/KeyService$KeyServiceError$Blocked;", "Lxyz/atrius/waystones/service/KeyService$KeyServiceError;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "<init>", "(Lxyz/atrius/waystones/manager/LocalizationManager;)V", "waystones"})
        public static final class Blocked
        extends KeyServiceError {
            public Blocked(@NotNull LocalizationManager localization) {
                Intrinsics.checkNotNullParameter(localization, "localization");
                super(() -> Blocked._init_$lambda$0(localization), null);
            }

            private static final LocalizedString _init_$lambda$0(LocalizationManager $localization) {
                return $localization.get("key-blocked", new Object[0]);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lxyz/atrius/waystones/service/KeyService$KeyServiceError$Ignore;", "Lxyz/atrius/waystones/service/KeyService$KeyServiceError;", "<init>", "()V", "waystones"})
        public static final class Ignore
        extends KeyServiceError {
            @NotNull
            public static final Ignore INSTANCE = new Ignore();

            private Ignore() {
                super(Ignore::_init_$lambda$0, null);
            }

            private static final LocalizedString _init_$lambda$0() {
                return null;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lxyz/atrius/waystones/service/KeyService$KeyServiceError$Severed;", "Lxyz/atrius/waystones/service/KeyService$KeyServiceError;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "<init>", "(Lxyz/atrius/waystones/manager/LocalizationManager;)V", "waystones"})
        public static final class Severed
        extends KeyServiceError {
            public Severed(@NotNull LocalizationManager localization) {
                Intrinsics.checkNotNullParameter(localization, "localization");
                super(() -> Severed._init_$lambda$0(localization), null);
            }

            private static final LocalizedString _init_$lambda$0(LocalizationManager $localization) {
                return $localization.get("key-severed", new Object[0]);
            }
        }
    }
}

