/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.event;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.koin.core.annotation.Single;
import xyz.atrius.waystones.dao.WaystoneInfo;
import xyz.atrius.waystones.kotlin.Metadata;
import xyz.atrius.waystones.kotlin.jvm.functions.Function1;
import xyz.atrius.waystones.kotlin.jvm.internal.Intrinsics;
import xyz.atrius.waystones.manager.LocalizationManager;
import xyz.atrius.waystones.manager.LocalizedString;
import xyz.atrius.waystones.repository.WaystoneInfoRepository;
import xyz.atrius.waystones.service.KeyService;
import xyz.atrius.waystones.service.WaystoneService;
import xyz.atrius.waystones.utility.EventKt;
import xyz.atrius.waystones.utility.PlayerKt;

@Single
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lxyz/atrius/waystones/event/InfoEvent;", "Lorg/bukkit/event/Listener;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "keyService", "Lxyz/atrius/waystones/service/KeyService;", "waystoneService", "Lxyz/atrius/waystones/service/WaystoneService;", "waystoneInfoRepository", "Lxyz/atrius/waystones/repository/WaystoneInfoRepository;", "<init>", "(Lxyz/atrius/waystones/manager/LocalizationManager;Lxyz/atrius/waystones/service/KeyService;Lxyz/atrius/waystones/service/WaystoneService;Lxyz/atrius/waystones/repository/WaystoneInfoRepository;)V", "onClick", "", "event", "Lorg/bukkit/event/player/PlayerInteractEvent;", "waystones"})
public final class InfoEvent
implements Listener {
    @NotNull
    private final LocalizationManager localization;
    @NotNull
    private final KeyService keyService;
    @NotNull
    private final WaystoneService waystoneService;
    @NotNull
    private final WaystoneInfoRepository waystoneInfoRepository;

    public InfoEvent(@NotNull LocalizationManager localization, @NotNull KeyService keyService, @NotNull WaystoneService waystoneService, @NotNull WaystoneInfoRepository waystoneInfoRepository) {
        Intrinsics.checkNotNullParameter(localization, "localization");
        Intrinsics.checkNotNullParameter(keyService, "keyService");
        Intrinsics.checkNotNullParameter(waystoneService, "waystoneService");
        Intrinsics.checkNotNullParameter(waystoneInfoRepository, "waystoneInfoRepository");
        this.localization = localization;
        this.keyService = keyService;
        this.waystoneService = waystoneService;
        this.waystoneInfoRepository = waystoneInfoRepository;
    }

    @EventHandler(ignoreCancelled=true)
    public final void onClick(@NotNull PlayerInteractEvent event) {
        String string;
        LocalizedString localizedString;
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        ItemStack itemStack = event.getItem();
        if (itemStack == null) {
            return;
        }
        ItemStack item = itemStack;
        Block block2 = block;
        if ((block2 != null ? block2.getType() : null) != Material.LODESTONE || !this.keyService.isWarpKey(item)) {
            return;
        }
        Location location = block.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        CompletionStage name = this.waystoneInfoRepository.getWaystone(location).thenApplyAsync(arg_0 -> InfoEvent.onClick$lambda$1(arg_0 -> InfoEvent.onClick$lambda$0(this, player2, arg_0), arg_0));
        Object[] objectArray = this.waystoneService.getWarpState(player2, block);
        if (objectArray == null || (localizedString = objectArray.getMessage().invoke()) == null || (string = localizedString.format(player2)) == null) {
            return;
        }
        String state = string;
        objectArray = new Object[]{((CompletableFuture)name).get(), state};
        PlayerKt.sendActionMessage(player2, this.localization.get("waystone-info", objectArray));
        EventKt.cancel((Cancellable)event);
    }

    private static final String onClick$lambda$0(InfoEvent this$0, Player $player, WaystoneInfo it) {
        Object object = it;
        if (object == null || (object = ((WaystoneInfo)object).getName()) == null) {
            object = this$0.localization.get("unnamed-waystone", new Object[0]).format($player);
        }
        return object;
    }

    private static final String onClick$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

