/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.utility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.atrius.waystones.data.TeleportType;
import xyz.atrius.waystones.kotlin.Metadata;
import xyz.atrius.waystones.kotlin.collections.CollectionsKt;
import xyz.atrius.waystones.kotlin.jvm.internal.Intrinsics;
import xyz.atrius.waystones.kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\u001a!\u0010\u001b\u001a\u00070\u0001\u00a2\u0006\u0002\b\u001c*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u001e\u001a\u0012\u0010 \u001a\u00020\u0019*\u00020\u00012\u0006\u0010!\u001a\u00020\u0001\u001a\u0012\u0010\"\u001a\u00020#*\u00020\u00012\u0006\u0010!\u001a\u00020\u0001\u001a\u0014\u0010 \u001a\u00020\u0019*\u00020\u00012\b\u0010$\u001a\u0004\u0018\u00010%\u001a&\u0010&\u001a\u00020'*\u00020\u00012\u0006\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020+2\b\b\u0002\u0010,\u001a\u00020+\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\"\u0015\u0010\u0006\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0003\"\u0015\u0010\b\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0003\"\u0015\u0010\n\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0003\"\u0015\u0010\f\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0003\"\u0015\u0010\u000e\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0003\"\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0015\u0010\u0014\u001a\u00020\u0015*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u0015\u0010\u0018\u001a\u00020\u0019*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001a\u00a8\u0006-"}, d2={"UP", "Lorg/bukkit/Location;", "getUP", "(Lorg/bukkit/Location;)Lorg/bukkit/Location;", "DOWN", "getDOWN", "NORTH", "getNORTH", "SOUTH", "getSOUTH", "WEST", "getWEST", "EAST", "getEAST", "center", "getCenter", "neighbors", "", "getNeighbors", "(Lorg/bukkit/Location;)Ljava/util/List;", "locationCode", "", "getLocationCode", "(Lorg/bukkit/Location;)Ljava/lang/String;", "isSafe", "", "(Lorg/bukkit/Location;)Z", "rotateY", "Lorg/jetbrains/annotations/NotNull;", "angle", "", "amp", "sameDimension", "other", "synchronize", "Lxyz/atrius/waystones/data/TeleportType;", "world", "Lorg/bukkit/World;", "playSound", "", "sound", "Lorg/bukkit/Sound;", "volume", "", "pitch", "waystones"})
@SourceDebugExtension(value={"SMAP\nLocation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Location.kt\nxyz/atrius/waystones/utility/LocationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1563#2:84\n1634#2,3:85\n1761#2,3:88\n1869#2,2:91\n*S KotlinDebug\n*F\n+ 1 Location.kt\nxyz/atrius/waystones/utility/LocationKt\n*L\n50#1:84\n50#1:85,3\n57#1:88,3\n82#1:91,2\n*E\n"})
public final class LocationKt {
    @NotNull
    public static final Location getUP(@NotNull Location $this$UP) {
        Intrinsics.checkNotNullParameter($this$UP, "<this>");
        Location location = $this$UP.clone().add(0.0, 1.0, 0.0);
        Intrinsics.checkNotNullExpressionValue(location, "add(...)");
        return location;
    }

    @NotNull
    public static final Location getDOWN(@NotNull Location $this$DOWN) {
        Intrinsics.checkNotNullParameter($this$DOWN, "<this>");
        Location location = $this$DOWN.clone().add(0.0, -1.0, 0.0);
        Intrinsics.checkNotNullExpressionValue(location, "add(...)");
        return location;
    }

    @NotNull
    public static final Location getNORTH(@NotNull Location $this$NORTH) {
        Intrinsics.checkNotNullParameter($this$NORTH, "<this>");
        Location location = $this$NORTH.clone().add(0.0, 0.0, -1.0);
        Intrinsics.checkNotNullExpressionValue(location, "add(...)");
        return location;
    }

    @NotNull
    public static final Location getSOUTH(@NotNull Location $this$SOUTH) {
        Intrinsics.checkNotNullParameter($this$SOUTH, "<this>");
        Location location = $this$SOUTH.clone().add(0.0, 0.0, 1.0);
        Intrinsics.checkNotNullExpressionValue(location, "add(...)");
        return location;
    }

    @NotNull
    public static final Location getWEST(@NotNull Location $this$WEST) {
        Intrinsics.checkNotNullParameter($this$WEST, "<this>");
        Location location = $this$WEST.clone().add(-1.0, 0.0, 0.0);
        Intrinsics.checkNotNullExpressionValue(location, "add(...)");
        return location;
    }

    @NotNull
    public static final Location getEAST(@NotNull Location $this$EAST) {
        Intrinsics.checkNotNullParameter($this$EAST, "<this>");
        Location location = $this$EAST.clone().add(1.0, 0.0, 0.0);
        Intrinsics.checkNotNullExpressionValue(location, "add(...)");
        return location;
    }

    @NotNull
    public static final Location getCenter(@NotNull Location $this$center) {
        Location location;
        Intrinsics.checkNotNullParameter($this$center, "<this>");
        Location $this$_get_center__u24lambda_u240 = location = $this$center;
        boolean bl = false;
        $this$_get_center__u24lambda_u240.setX(Math.floor($this$_get_center__u24lambda_u240.getX()) + 0.5);
        $this$_get_center__u24lambda_u240.setZ(Math.floor($this$_get_center__u24lambda_u240.getZ()) + 0.5);
        return location;
    }

    @NotNull
    public static final List<Location> getNeighbors(@NotNull Location $this$neighbors) {
        Intrinsics.checkNotNullParameter($this$neighbors, "<this>");
        Location[] locationArray = new Location[]{LocationKt.getUP($this$neighbors), LocationKt.getDOWN($this$neighbors), LocationKt.getNORTH($this$neighbors), LocationKt.getSOUTH($this$neighbors), LocationKt.getWEST($this$neighbors), LocationKt.getEAST($this$neighbors)};
        return CollectionsKt.listOf(locationArray);
    }

    @NotNull
    public static final String getLocationCode(@NotNull Location $this$locationCode) {
        Intrinsics.checkNotNullParameter($this$locationCode, "<this>");
        World world = $this$locationCode.getWorld();
        return (world != null ? world.getName() : null) + "@" + $this$locationCode.getBlockX() + ":" + $this$locationCode.getBlockY() + ":" + $this$locationCode.getBlockZ();
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isSafe(@NotNull Location $this$isSafe) {
        boolean bl;
        block4: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter($this$isSafe, "<this>");
            Location[] locationArray = new Location[]{LocationKt.getUP($this$isSafe), LocationKt.getUP(LocationKt.getUP($this$isSafe))};
            Iterable $this$map$iv = CollectionsKt.listOf(locationArray);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Material material;
                void it;
                Block block;
                Location location = (Location)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                World world = $this$isSafe.getWorld();
                collection.add(world != null && (block = world.getBlockAt((Location)it)) != null && (material = block.getType()) != null ? material.isSolid() : true);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean it = (Boolean)element$iv;
                    boolean bl3 = false;
                    if (!it) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return !bl;
    }

    @NotNull
    public static final Location rotateY(@NotNull Location $this$rotateY, double angle, double amp) {
        Intrinsics.checkNotNullParameter($this$rotateY, "<this>");
        Location location = $this$rotateY.add(new Vector(Math.cos(angle) * amp, 2.0, Math.sin(angle) * amp));
        Intrinsics.checkNotNullExpressionValue(location, "add(...)");
        return location;
    }

    public static /* synthetic */ Location rotateY$default(Location location, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = 1.0;
        }
        return LocationKt.rotateY(location, d, d2);
    }

    public static final boolean sameDimension(@NotNull Location $this$sameDimension, @NotNull Location other) {
        Intrinsics.checkNotNullParameter($this$sameDimension, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        return Intrinsics.areEqual($this$sameDimension.getWorld(), other.getWorld());
    }

    @NotNull
    public static final TeleportType synchronize(@NotNull Location $this$synchronize, @NotNull Location other) {
        TeleportType teleportType;
        Intrinsics.checkNotNullParameter($this$synchronize, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        if (LocationKt.sameDimension($this$synchronize, other.getWorld())) {
            teleportType = TeleportType.Normal.INSTANCE;
        } else {
            World world = $this$synchronize.getWorld();
            Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
            World world2 = other.getWorld();
            Intrinsics.checkNotNullExpressionValue(world2, "getWorld(...)");
            teleportType = new TeleportType.Interdimensional(world, world2);
        }
        return teleportType;
    }

    public static final boolean sameDimension(@NotNull Location $this$sameDimension, @Nullable World world) {
        Intrinsics.checkNotNullParameter($this$sameDimension, "<this>");
        return Intrinsics.areEqual(world, $this$sameDimension.getWorld());
    }

    /*
     * WARNING - void declaration
     */
    public static final void playSound(@NotNull Location $this$playSound, @NotNull Sound sound, float volume, float pitch) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter($this$playSound, "<this>");
        Intrinsics.checkNotNullParameter(sound, "sound");
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable iterable = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getWorld(), $this$playSound.getWorld())) continue;
            it.playSound($this$playSound, sound, SoundCategory.MASTER, volume, pitch, 0L);
        }
    }

    public static /* synthetic */ void playSound$default(Location location, Sound sound, float f, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        if ((n & 4) != 0) {
            f2 = 1.0f;
        }
        LocationKt.playSound(location, sound, f, f2);
    }
}

