/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.service;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.koin.core.annotation.Single;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.atrius.waystones.dao.WaystoneInfo;
import xyz.atrius.waystones.data.JsonFile;
import xyz.atrius.waystones.internal.KotlinPlugin;
import xyz.atrius.waystones.kotlin.Deprecated;
import xyz.atrius.waystones.kotlin.Metadata;
import xyz.atrius.waystones.kotlin.jvm.internal.DefaultConstructorMarker;
import xyz.atrius.waystones.kotlin.jvm.internal.Intrinsics;
import xyz.atrius.waystones.kotlin.jvm.internal.Reflection;
import xyz.atrius.waystones.kotlin.jvm.internal.SourceDebugExtension;
import xyz.atrius.waystones.kotlin.text.StringsKt;
import xyz.atrius.waystones.repository.WaystoneInfoRepository;
import xyz.atrius.waystones.service.WaystoneService;

@Single
@Deprecated(message="Database support is included now, so this will be phased out in the future")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00132$\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0002j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\u00040\u0001:\u0001\u0013B'\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lxyz/atrius/waystones/service/WarpNameService;", "Lxyz/atrius/waystones/data/JsonFile;", "Ljava/util/HashMap;", "", "Lxyz/atrius/waystones/kotlin/collections/HashMap;", "gson", "Lcom/google/gson/Gson;", "plugin", "Lxyz/atrius/waystones/internal/KotlinPlugin;", "waystoneInfoRepository", "Lxyz/atrius/waystones/repository/WaystoneInfoRepository;", "waystoneService", "Lxyz/atrius/waystones/service/WaystoneService;", "<init>", "(Lcom/google/gson/Gson;Lxyz/atrius/waystones/internal/KotlinPlugin;Lxyz/atrius/waystones/repository/WaystoneInfoRepository;Lxyz/atrius/waystones/service/WaystoneService;)V", "migrate", "", "clearData", "", "Companion", "waystones"})
@SourceDebugExtension(value={"SMAP\nWarpNameService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WarpNameService.kt\nxyz/atrius/waystones/service/WarpNameService\n+ 2 String.kt\nxyz/atrius/waystones/utility/StringKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n88#2,3:91\n88#2,3:107\n1617#3,9:94\n1869#3:103\n1870#3:105\n1626#3:106\n1#4:104\n*S KotlinDebug\n*F\n+ 1 WarpNameService.kt\nxyz/atrius/waystones/service/WarpNameService\n*L\n31#1:91,3\n50#1:107,3\n49#1:94,9\n49#1:103\n49#1:105\n49#1:106\n49#1:104\n*E\n"})
public final class WarpNameService
extends JsonFile<HashMap<String, String>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WaystoneInfoRepository waystoneInfoRepository;
    @NotNull
    private final WaystoneService waystoneService;
    private static final Logger logger = LoggerFactory.getLogger(WarpNameService.class);

    public WarpNameService(@NotNull Gson gson, @NotNull KotlinPlugin plugin, @NotNull WaystoneInfoRepository waystoneInfoRepository, @NotNull WaystoneService waystoneService) {
        Intrinsics.checkNotNullParameter(gson, "gson");
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(waystoneInfoRepository, "waystoneInfoRepository");
        Intrinsics.checkNotNullParameter(waystoneService, "waystoneService");
        super("warpnames", gson, plugin, Reflection.getOrCreateKotlinClass(new HashMap().getClass()));
        this.waystoneInfoRepository = waystoneInfoRepository;
        this.waystoneService = waystoneService;
    }

    /*
     * WARNING - void declaration
     */
    public final int migrate() {
        logger.info("Migrating waystone names to database storage...");
        int failedMigrations = 0;
        for (Map.Entry entry : ((Map)this.getData()).entrySet()) {
            void $this$expectSizeOrDefault$iv;
            void $this$mapNotNullTo$iv$iv;
            List $this$mapNotNull$iv;
            void $this$expectSizeOrDefault$iv2;
            String locationCode = (String)entry.getKey();
            String waystoneName = (String)entry.getValue();
            Object object = new String[]{"@"};
            object = StringsKt.split$default((CharSequence)locationCode, object, false, 0, 6, null);
            int size$iv = 2;
            boolean $i$f$expectSizeOrDefault = false;
            if (!($this$expectSizeOrDefault$iv2.size() == size$iv)) {
                void it = $this$expectSizeOrDefault$iv2;
                boolean bl = false;
                logger.warn("Invalid data in components for waystone '" + waystoneName + "': " + (List)it);
                logger.warn("Please be sure your waystone code is marked in the format 'worldName@x:y:z'!");
                ++failedMigrations;
                continue;
            }
            void components = $this$expectSizeOrDefault$iv2;
            String worldName = (String)components.get(0);
            String location = (String)components.get(1);
            World world = Bukkit.getWorld((String)worldName);
            if (world == null) {
                logger.warn("Invalid world provided for waystone '" + waystoneName + "': " + worldName);
                int it = failedMigrations;
                failedMigrations = it + 1;
                continue;
            }
            Object bl = new String[]{":"};
            bl = StringsKt.split$default((CharSequence)location, bl, false, 0, 6, null);
            boolean $i$f$mapNotNull = false;
            void var13_19 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                if (StringsKt.toIntOrNull(it) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            int size$iv2 = 3;
            boolean $i$f$expectSizeOrDefault2 = false;
            if (!($this$expectSizeOrDefault$iv.size() == size$iv2)) {
                void it = $this$expectSizeOrDefault$iv;
                boolean bl5 = false;
                logger.warn("Unable to determine location for waystone '" + waystoneName + "': " + (List)it);
                logger.warn("Please be sure your x/y/z components are valid numbers!'");
                ++failedMigrations;
                continue;
            }
            void coordinates = $this$expectSizeOrDefault$iv;
            int x = ((Number)coordinates.get(0)).intValue();
            int y = ((Number)coordinates.get(1)).intValue();
            int z = ((Number)coordinates.get(2)).intValue();
            if (!this.waystoneService.isWaystone(world.getBlockAt(x, y, z))) {
                logger.warn("Block in world '" + world.getName() + "' @ (" + x + ", " + y + ", " + z + ") is not a waystone. Skipping...");
                int it = failedMigrations;
                failedMigrations = it + 1;
                continue;
            }
            UUID uUID = world.getUID();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUID(...)");
            WaystoneInfo info = new WaystoneInfo(uUID, x, y, z, waystoneName);
            this.waystoneInfoRepository.save(info);
        }
        logger.info("Waystone info migration complete!");
        return failedMigrations;
    }

    public final void clearData() {
        ((HashMap)this.getData()).clear();
        this.save();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lxyz/atrius/waystones/service/WarpNameService$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "xyz.atrius.waystones.kotlin.jvm.PlatformType", "waystones"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

