/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.data;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.atrius.waystones.internal.KotlinPlugin;
import xyz.atrius.waystones.kotlin.Metadata;
import xyz.atrius.waystones.kotlin.Unit;
import xyz.atrius.waystones.kotlin.jvm.JvmClassMappingKt;
import xyz.atrius.waystones.kotlin.jvm.internal.DefaultConstructorMarker;
import xyz.atrius.waystones.kotlin.jvm.internal.Intrinsics;
import xyz.atrius.waystones.kotlin.reflect.KClass;
import xyz.atrius.waystones.kotlin.text.Charsets;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u0018*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0001\u0018B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u00028\u0000X\u0084.\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lxyz/atrius/waystones/data/JsonFile;", "T", "", "name", "", "gson", "Lcom/google/gson/Gson;", "plugin", "Lxyz/atrius/waystones/internal/KotlinPlugin;", "type", "Lxyz/atrius/waystones/kotlin/reflect/KClass;", "<init>", "(Ljava/lang/String;Lcom/google/gson/Gson;Lxyz/atrius/waystones/internal/KotlinPlugin;Lkotlin/reflect/KClass;)V", "file", "Ljava/io/File;", "data", "getData", "()Ljava/lang/Object;", "setData", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "load", "", "save", "Companion", "waystones"})
public class JsonFile<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Gson gson;
    @NotNull
    private final KotlinPlugin plugin;
    @NotNull
    private final KClass<? extends T> type;
    @NotNull
    private final File file;
    protected T data;
    private static final Logger logger = LoggerFactory.getLogger(JsonFile.class);

    public JsonFile(@NotNull String name, @NotNull Gson gson, @NotNull KotlinPlugin plugin, @NotNull KClass<? extends T> type) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(gson, "gson");
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(type, "type");
        this.gson = gson;
        this.plugin = plugin;
        this.type = type;
        this.file = new File(this.plugin.getDataFolder(), name + ".json");
    }

    @NotNull
    protected final T getData() {
        T t = this.data;
        if (t != null) {
            return t;
        }
        Intrinsics.throwUninitializedPropertyAccessException("data");
        return (T)Unit.INSTANCE;
    }

    protected final void setData(@NotNull T t) {
        Intrinsics.checkNotNullParameter(t, "<set-?>");
        this.data = t;
    }

    public void load() {
        logger.info("Loading " + this.file.getName() + "...");
        try {
            if (!this.file.exists()) {
                this.plugin.saveResource(this.file.getName(), false);
            }
        }
        catch (IllegalArgumentException e) {
            logger.error("Failed to load configuration file: " + e.getMessage());
        }
        Object object = this.gson.fromJson((Reader)new FileReader(this.file), JvmClassMappingKt.getJavaClass(this.type));
        Intrinsics.checkNotNullExpressionValue(object, "fromJson(...)");
        this.setData(object);
        logger.info("Loaded " + this.file.getName() + " successfully!");
    }

    public final void save() {
        String json = this.gson.toJson(this.getData());
        Path path = this.file.toPath();
        Intrinsics.checkNotNull(json);
        String string = json;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        Files.write(path, byArray, new OpenOption[0]);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lxyz/atrius/waystones/data/JsonFile$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "xyz.atrius.waystones.kotlin.jvm.PlatformType", "waystones"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

