/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.command.waystones;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.koin.core.annotation.Single;
import xyz.atrius.waystones.command.resolver.LimitedArgumentType;
import xyz.atrius.waystones.command.waystones.WaystoneSubcommand;
import xyz.atrius.waystones.kotlin.Metadata;
import xyz.atrius.waystones.kotlin.collections.CollectionsKt;
import xyz.atrius.waystones.kotlin.jvm.internal.Intrinsics;
import xyz.atrius.waystones.kotlin.jvm.internal.SourceDebugExtension;
import xyz.atrius.waystones.manager.LocalizationManager;
import xyz.atrius.waystones.manager.LocalizedString;
import xyz.atrius.waystones.service.WorldRatioService;
import xyz.atrius.waystones.utility.PlayerKt;
import xyz.atrius.waystones.utility.StringKt;

@Single
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\u0010\u0012\u0002\b\u00030\u000f2\u0010\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\u0010\u0012\u0002\b\u00030\u000fH\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013H\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013H\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013H\u0002J\u001d\u0010\u0016\u001a\u0012\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\u0018\u00a2\u0006\u0002\b\u00190\u0017H\u0002\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lxyz/atrius/waystones/command/waystones/RatioCommand;", "Lxyz/atrius/waystones/command/waystones/WaystoneSubcommand;", "worldRatioService", "Lxyz/atrius/waystones/service/WorldRatioService;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "<init>", "(Lxyz/atrius/waystones/service/WorldRatioService;Lxyz/atrius/waystones/manager/LocalizationManager;)V", "name", "", "getName", "()Ljava/lang/String;", "basePermission", "getBasePermission", "build", "Lcom/mojang/brigadier/builder/ArgumentBuilder;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "base", "setCommand", "Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "removeCommand", "setDefault", "worlds", "", "Lorg/jetbrains/annotations/NotNull;", "Lxyz/atrius/waystones/kotlin/jvm/internal/EnhancedNullability;", "()[Ljava/lang/String;", "waystones"})
@SourceDebugExtension(value={"SMAP\nRatioCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RatioCommand.kt\nxyz/atrius/waystones/command/waystones/RatioCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 CommandUtils.kt\nxyz/atrius/waystones/utility/CommandUtilsKt\n*L\n1#1,129:1\n1563#2:130\n1634#2,3:131\n37#3:134\n36#3,3:135\n7#4:138\n7#4:139\n*S KotlinDebug\n*F\n+ 1 RatioCommand.kt\nxyz/atrius/waystones/command/waystones/RatioCommand\n*L\n126#1:130\n126#1:131,3\n127#1:134\n127#1:135,3\n92#1:138\n111#1:139\n*E\n"})
public final class RatioCommand
implements WaystoneSubcommand {
    @NotNull
    private final WorldRatioService worldRatioService;
    @NotNull
    private final LocalizationManager localization;
    @NotNull
    private final String name;
    @NotNull
    private final String basePermission;

    public RatioCommand(@NotNull WorldRatioService worldRatioService, @NotNull LocalizationManager localization) {
        Intrinsics.checkNotNullParameter(worldRatioService, "worldRatioService");
        Intrinsics.checkNotNullParameter(localization, "localization");
        this.worldRatioService = worldRatioService;
        this.localization = localization;
        this.name = "ratio";
        this.basePermission = "waystones.config";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getBasePermission() {
        return this.basePermission;
    }

    @Override
    @NotNull
    public ArgumentBuilder<CommandSourceStack, ?> build(@NotNull ArgumentBuilder<CommandSourceStack, ?> base) {
        Intrinsics.checkNotNullParameter(base, "base");
        ArgumentBuilder base2 = base.executes(arg_0 -> RatioCommand.build$lambda$0(this, arg_0));
        ArgumentBuilder argumentBuilder = base2.then((ArgumentBuilder)this.setDefault()).then((ArgumentBuilder)this.setCommand()).then((ArgumentBuilder)this.removeCommand());
        Intrinsics.checkNotNullExpressionValue(argumentBuilder, "then(...)");
        return argumentBuilder;
    }

    private final LiteralArgumentBuilder<CommandSourceStack> setCommand() {
        RequiredArgumentBuilder ratio = (RequiredArgumentBuilder)Commands.argument((String)"ratio", (ArgumentType)((ArgumentType)DoubleArgumentType.doubleArg((double)0.0))).executes(arg_0 -> RatioCommand.setCommand$lambda$1(this, arg_0));
        RequiredArgumentBuilder world = (RequiredArgumentBuilder)Commands.argument((String)"world", (ArgumentType)((ArgumentType)new LimitedArgumentType<String>(this.worlds()))).then((ArgumentBuilder)ratio);
        ArgumentBuilder argumentBuilder = Commands.literal((String)"set").then((ArgumentBuilder)world);
        Intrinsics.checkNotNullExpressionValue(argumentBuilder, "then(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    private final LiteralArgumentBuilder<CommandSourceStack> removeCommand() {
        RequiredArgumentBuilder world = (RequiredArgumentBuilder)Commands.argument((String)"world", (ArgumentType)((ArgumentType)new LimitedArgumentType<String>(this.worlds()))).executes(arg_0 -> RatioCommand.removeCommand$lambda$2(this, arg_0));
        ArgumentBuilder argumentBuilder = Commands.literal((String)"remove").then((ArgumentBuilder)world);
        Intrinsics.checkNotNullExpressionValue(argumentBuilder, "then(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    private final LiteralArgumentBuilder<CommandSourceStack> setDefault() {
        RequiredArgumentBuilder world = (RequiredArgumentBuilder)Commands.argument((String)"world", (ArgumentType)((ArgumentType)new LimitedArgumentType<String>(this.worlds()))).executes(arg_0 -> RatioCommand.setDefault$lambda$3(this, arg_0));
        ArgumentBuilder argumentBuilder = Commands.literal((String)"default").then((ArgumentBuilder)world);
        Intrinsics.checkNotNullExpressionValue(argumentBuilder, "then(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    /*
     * WARNING - void declaration
     */
    private final String[] worlds() {
        void $this$mapTo$iv$iv;
        List list = Bukkit.getWorlds();
        Intrinsics.checkNotNullExpressionValue(list, "getWorlds(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            World world = (World)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    private static final int build$lambda$0(RatioCommand this$0, CommandContext it) {
        CommandSender commandSender = ((CommandSourceStack)it.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        Player player = sender instanceof Player ? (Player)sender : null;
        PlayerKt.message$default(sender, this$0.localization.get("plugin-header", new Object[0]).format(player), '\u0000', 2, null);
        for (Map.Entry<World, Double> entry : this$0.worldRatioService) {
            LocalizedString localizedString;
            int isDisabled;
            World world = entry.getKey();
            double ratio = ((Number)entry.getValue()).doubleValue();
            if (ratio < 0.0) continue;
            String string = world.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            String worldName = StringKt.sanitizedStringFormat(string);
            boolean bl = this$0.worldRatioService.isDefault(world);
            int n = isDisabled = ratio == 0.0 ? 0 : 1;
            if (bl) {
                var13_12 = new Object[]{worldName};
                localizedString = this$0.localization.get("command-ratio-list-default", var13_12);
            } else {
                var13_12 = new Object[]{worldName, isDisabled, ratio};
                localizedString = this$0.localization.get("command-ratio-list-ratio", var13_12);
            }
            LocalizedString message = localizedString;
            PlayerKt.message$default(sender, message, '\u0000', 2, null);
        }
        PlayerKt.message$default(sender, this$0.localization.get("plugin-footer", new Object[0]).format(player), '\u0000', 2, null);
        return 1;
    }

    private static final int setCommand$lambda$1(RatioCommand this$0, CommandContext it) {
        LocalizedString localizedString;
        String world = (String)it.getArgument("world", String.class);
        Double ratio = (Double)it.getArgument("ratio", Double.TYPE);
        boolean added = this$0.worldRatioService.add(Bukkit.getWorld((String)world), ratio);
        if (added) {
            var6_5 = new Object[]{0, world};
            localizedString = this$0.localization.get("command-ratio-added-successfully", var6_5);
        } else {
            var6_5 = new Object[]{world};
            localizedString = this$0.localization.get("command-ratio-addition-failed", var6_5);
        }
        LocalizedString message = localizedString;
        CommandSender commandSender = ((CommandSourceStack)it.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        PlayerKt.message$default(commandSender, message, '\u0000', 2, null);
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private static final int removeCommand$lambda$2(RatioCommand this$0, CommandContext it) {
        LocalizedString localizedString;
        void $this$getArgument$iv;
        Intrinsics.checkNotNull(it);
        CommandContext commandContext = it;
        String name$iv = "world";
        boolean $i$f$getArgument = false;
        String world = (String)$this$getArgument$iv.getArgument(name$iv, String.class);
        boolean removed = this$0.worldRatioService.remove(Bukkit.getWorld((String)world));
        if (removed) {
            var6_7 = new Object[]{0, world};
            localizedString = this$0.localization.get("command-ratio-removed-successfully", var6_7);
        } else {
            var6_7 = new Object[]{world};
            localizedString = this$0.localization.get("command-ratio-removal-failed", var6_7);
        }
        LocalizedString message = localizedString;
        CommandSender commandSender = ((CommandSourceStack)it.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        PlayerKt.message$default(commandSender, message, '\u0000', 2, null);
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private static final int setDefault$lambda$3(RatioCommand this$0, CommandContext it) {
        void $this$getArgument$iv;
        Intrinsics.checkNotNull(it);
        CommandContext commandContext = it;
        String name$iv = "world";
        boolean $i$f$getArgument = false;
        String world = (String)$this$getArgument$iv.getArgument(name$iv, String.class);
        this$0.worldRatioService.default(Bukkit.getWorld((String)world));
        Object[] objectArray = new Object[]{world};
        LocalizedString message = this$0.localization.get("command-ratio-default-set", objectArray);
        CommandSender commandSender = ((CommandSourceStack)it.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        PlayerKt.message$default(commandSender, message, '\u0000', 2, null);
        return 1;
    }
}

