/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.service;

import arrow.core.Either;
import arrow.core.NonFatalOrThrowKt;
import arrow.core.raise.DefaultRaise;
import arrow.core.raise.Raise;
import arrow.core.raise.RaiseCancellationException;
import arrow.core.raise.RaiseKt;
import java.util.concurrent.CancellationException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.koin.core.annotation.Single;
import xyz.atrius.waystones.dao.WaystoneInfo;
import xyz.atrius.waystones.kotlin.KotlinNothingValueException;
import xyz.atrius.waystones.kotlin.Metadata;
import xyz.atrius.waystones.kotlin.jvm.internal.DefaultConstructorMarker;
import xyz.atrius.waystones.kotlin.jvm.internal.Intrinsics;
import xyz.atrius.waystones.kotlin.jvm.internal.SourceDebugExtension;
import xyz.atrius.waystones.repository.WaystoneInfoRepository;

@Single
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lxyz/atrius/waystones/service/NameService;", "", "waystoneInfoRepository", "Lxyz/atrius/waystones/repository/WaystoneInfoRepository;", "<init>", "(Lxyz/atrius/waystones/repository/WaystoneInfoRepository;)V", "process", "Larrow/core/Either;", "Lxyz/atrius/waystones/service/NameService$NameServiceError;", "", "player", "Lorg/bukkit/entity/Player;", "item", "Lorg/bukkit/inventory/ItemStack;", "block", "Lorg/bukkit/block/Block;", "NameServiceError", "waystones"})
@SourceDebugExtension(value={"SMAP\nNameService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NameService.kt\nxyz/atrius/waystones/service/NameService\n+ 2 Builders.kt\narrow/core/raise/RaiseKt__BuildersKt\n+ 3 Fold.kt\narrow/core/raise/RaiseKt__FoldKt\n+ 4 Raise.kt\narrow/core/raise/RaiseKt__RaiseKt\n*L\n1#1,65:1\n53#2:66\n115#3:67\n142#3,3:68\n145#3,8:74\n629#4:71\n584#4:72\n629#4:73\n*S KotlinDebug\n*F\n+ 1 NameService.kt\nxyz/atrius/waystones/service/NameService\n*L\n26#1:66\n26#1:67\n26#1:68,3\n26#1:74,8\n27#1:71\n31#1:72\n41#1:73\n*E\n"})
public final class NameService {
    @NotNull
    private final WaystoneInfoRepository waystoneInfoRepository;

    public NameService(@NotNull WaystoneInfoRepository waystoneInfoRepository) {
        Intrinsics.checkNotNullParameter(waystoneInfoRepository, "waystoneInfoRepository");
        this.waystoneInfoRepository = waystoneInfoRepository;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Either<NameServiceError, String> process(@NotNull Player player, @NotNull ItemStack item, @NotNull Block block) {
        Either either;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$either = false;
        boolean $i$f$_foldOrThrow = false;
        boolean $i$f$_fold = false;
        DefaultRaise raise$iv$iv$iv = new DefaultRaise(false);
        try {
            void condition$iv2;
            Raise $this$ensureNotNull$iv;
            Raise $this$process_u24lambda_u243 = (Raise)raise$iv$iv$iv;
            boolean bl = false;
            Raise raise = $this$process_u24lambda_u243;
            ItemMeta value$iv22 = item.getItemMeta();
            boolean $i$f$ensureNotNull = false;
            ItemMeta itemMeta = value$iv22;
            if (itemMeta == null) {
                void var13_16 = $this$ensureNotNull$iv;
                boolean bl2 = false;
                var13_16.raise((Object)NameServiceError.Ignore.INSTANCE);
                throw new KotlinNothingValueException();
            }
            ItemMeta meta = itemMeta;
            $this$ensureNotNull$iv = $this$process_u24lambda_u243;
            boolean value$iv22 = item.getType() == Material.NAME_TAG && block.getType() == Material.LODESTONE && meta.hasDisplayName();
            boolean $i$f$ensure = false;
            if (condition$iv2 == false) {
                void $this$ensure$iv;
                void var13_17 = $this$ensure$iv;
                boolean bl3 = false;
                var13_17.raise((Object)NameServiceError.Ignore.INSTANCE);
                throw new KotlinNothingValueException();
            }
            Component displayName = meta.displayName();
            Raise condition$iv2 = $this$process_u24lambda_u243;
            Component value$iv = displayName;
            boolean $i$f$ensureNotNull2 = false;
            if (value$iv == null) {
                void $this$ensureNotNull$iv2;
                void var13_18 = $this$ensureNotNull$iv2;
                boolean bl4 = false;
                var13_18.raise((Object)NameServiceError.Ignore.INSTANCE);
                throw new KotlinNothingValueException();
            }
            String string = PlainTextComponentSerializer.plainText().serialize(displayName);
            Intrinsics.checkNotNullExpressionValue(string, "serialize(...)");
            String name = string;
            Location location = block.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            WaystoneInfo info = WaystoneInfo.Companion.fromLocation(location, name);
            this.waystoneInfoRepository.save(info);
            if (player.getGameMode() != GameMode.CREATIVE) {
                int n = item.getAmount();
                item.setAmount(n + -1);
            }
            String res$iv$iv$iv = name;
            raise$iv$iv$iv.complete();
            String it$iv = res$iv$iv$iv;
            boolean bl5 = false;
            either = (Either)new Either.Right((Object)it$iv);
        }
        catch (RaiseCancellationException e$iv$iv$iv) {
            raise$iv$iv$iv.complete();
            Object it$iv = RaiseKt.raisedOrRethrow((CancellationException)((CancellationException)((Object)e$iv$iv$iv)), (DefaultRaise)raise$iv$iv$iv);
            boolean bl = false;
            either = (Either)new Either.Left(it$iv);
        }
        catch (Throwable e$iv$iv$iv) {
            raise$iv$iv$iv.complete();
            Throwable it$iv$iv = NonFatalOrThrowKt.nonFatalOrThrow((Throwable)e$iv$iv$iv);
            boolean bl = false;
            throw it$iv$iv;
        }
        return either;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0001\u0005\u00a8\u0006\u0006"}, d2={"Lxyz/atrius/waystones/service/NameService$NameServiceError;", "", "<init>", "()V", "Ignore", "Lxyz/atrius/waystones/service/NameService$NameServiceError$Ignore;", "waystones"})
    public static abstract sealed class NameServiceError {
        private NameServiceError() {
        }

        public /* synthetic */ NameServiceError(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lxyz/atrius/waystones/service/NameService$NameServiceError$Ignore;", "Lxyz/atrius/waystones/service/NameService$NameServiceError;", "<init>", "()V", "waystones"})
        public static final class Ignore
        extends NameServiceError {
            @NotNull
            public static final Ignore INSTANCE = new Ignore();

            private Ignore() {
                super(null);
            }
        }
    }
}

