/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.config;

import org.bukkit.configuration.ConfigurationSection;
import org.flywaydb.core.Flyway;
import org.jetbrains.annotations.NotNull;
import org.koin.core.annotation.Module;
import org.koin.core.annotation.Single;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.atrius.waystones.config.DatabaseProperties;
import xyz.atrius.waystones.config.SupportedDatabase;
import xyz.atrius.waystones.internal.KotlinPlugin;
import xyz.atrius.waystones.kotlin.Metadata;
import xyz.atrius.waystones.kotlin.collections.CollectionsKt;
import xyz.atrius.waystones.kotlin.enums.EnumEntries;
import xyz.atrius.waystones.kotlin.jvm.internal.Intrinsics;
import xyz.atrius.waystones.kotlin.jvm.internal.Reflection;
import xyz.atrius.waystones.kotlin.jvm.internal.SourceDebugExtension;

@Module
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0005H\u0007R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lxyz/atrius/waystones/config/DatabaseModule;", "", "<init>", "()V", "getDatabaseConfiguration", "Lxyz/atrius/waystones/config/DatabaseProperties;", "plugin", "Lxyz/atrius/waystones/internal/KotlinPlugin;", "defaultDatabaseProperties", "configureFlyway", "Lorg/flywaydb/core/Flyway;", "props", "logger", "Lorg/slf4j/Logger;", "xyz.atrius.waystones.kotlin.jvm.PlatformType", "waystones"})
@SourceDebugExtension(value={"SMAP\nDatabaseModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseModule.kt\nxyz/atrius/waystones/config/DatabaseModule\n+ 2 String.kt\nxyz/atrius/waystones/utility/StringKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n63#2,3:53\n66#2,5:58\n295#3,2:56\n*S KotlinDebug\n*F\n+ 1 DatabaseModule.kt\nxyz/atrius/waystones/config/DatabaseModule\n*L\n26#1:53,3\n26#1:58,5\n26#1:56,2\n*E\n"})
public final class DatabaseModule {
    @NotNull
    public static final DatabaseModule INSTANCE = new DatabaseModule();
    private static final Logger logger = LoggerFactory.getLogger(DatabaseModule.class);

    private DatabaseModule() {
    }

    /*
     * WARNING - void declaration
     */
    @Single
    @NotNull
    public final DatabaseProperties getDatabaseConfiguration(@NotNull KotlinPlugin plugin) {
        Object v1;
        EnumEntries<SupportedDatabase> entries$iv;
        ConfigurationSection config;
        block3: {
            void $this$firstOrNull$iv$iv;
            Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
            logger.info("Attempting to load database configuration...");
            ConfigurationSection configurationSection = plugin.getConfig().getConfigurationSection("database");
            if (configurationSection == null) {
                return this.defaultDatabaseProperties();
            }
            config = configurationSection;
            String $this$bindAsEnum$iv = config.getString("type");
            boolean $i$f$bindAsEnum = false;
            entries$iv = SupportedDatabase.getEntries();
            Iterable iterable = entries$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Enum it$iv = (Enum)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it$iv.toString(), $this$bindAsEnum$iv) || Intrinsics.areEqual(it$iv.name(), $this$bindAsEnum$iv))) continue;
                v1 = element$iv$iv;
                break block3;
            }
            v1 = null;
        }
        Enum enum_ = v1;
        if (enum_ == null) {
            throw new IllegalArgumentException("Unsupported value for " + Reflection.getOrCreateKotlinClass(SupportedDatabase.class).getSimpleName() + "! Must be one of: " + CollectionsKt.joinToString$default(entries$iv, null, null, null, 0, null, null, 63, null) + "}");
        }
        Enum entry$iv = enum_;
        String string = config.getString("database-name");
        String string2 = config.getString("password");
        String string3 = config.getString("username");
        Integer n = config.getInt("port");
        String string4 = config.getString("host");
        SupportedDatabase supportedDatabase = (SupportedDatabase)entry$iv;
        return new DatabaseProperties(supportedDatabase, string4, n, string3, string2, string);
    }

    private final DatabaseProperties defaultDatabaseProperties() {
        return new DatabaseProperties(SupportedDatabase.SQLITE, null, null, null, null, null, 62, null);
    }

    @Single
    @NotNull
    public final Flyway configureFlyway(@NotNull KotlinPlugin plugin, @NotNull DatabaseProperties props) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(props, "props");
        String[] stringArray = new String[]{"classpath:db/migration/" + props.getType(), "classpath:/db/migration/common"};
        Flyway flyway = Flyway.configure((ClassLoader)this.getClass().getClassLoader()).validateOnMigrate(true).locations(stringArray).dataSource(props.getHostUrl(plugin), props.getUsername(), props.getPassword()).load();
        Intrinsics.checkNotNullExpressionValue(flyway, "load(...)");
        return flyway;
    }
}

