/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.command.waystones;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.koin.core.annotation.Single;
import xyz.atrius.waystones.command.waystones.WaystoneSubcommand;
import xyz.atrius.waystones.dao.WaystoneInfo;
import xyz.atrius.waystones.kotlin.Metadata;
import xyz.atrius.waystones.kotlin.Unit;
import xyz.atrius.waystones.kotlin.jvm.functions.Function0;
import xyz.atrius.waystones.kotlin.jvm.functions.Function1;
import xyz.atrius.waystones.kotlin.jvm.internal.DefaultConstructorMarker;
import xyz.atrius.waystones.kotlin.jvm.internal.Intrinsics;
import xyz.atrius.waystones.kotlin.jvm.internal.SourceDebugExtension;
import xyz.atrius.waystones.kotlin.ranges.RangesKt;
import xyz.atrius.waystones.manager.LocalizationManager;
import xyz.atrius.waystones.repository.WaystoneInfoRepository;
import xyz.atrius.waystones.utility.LocationKt;
import xyz.atrius.waystones.utility.PlayerKt;
import xyz.atrius.waystones.utility.StringKt;

@Single
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 (2\u00020\u0001:\u0001(B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\u0013\u0012\u0002\b\u00030\u00122\u0010\u0010\u0014\u001a\f\u0012\u0004\u0012\u00020\u0013\u0012\u0002\b\u00030\u0012H\u0016J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0016H\u0002J\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u0016H\u0002J\u0018\u0010!\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J.\u0010\"\u001a\u00020#2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020#2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0%H\u0002J\u0018\u0010&\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lxyz/atrius/waystones/command/waystones/ListCommand;", "Lxyz/atrius/waystones/command/waystones/WaystoneSubcommand;", "waystoneInfoRepository", "Lxyz/atrius/waystones/repository/WaystoneInfoRepository;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "<init>", "(Lxyz/atrius/waystones/repository/WaystoneInfoRepository;Lxyz/atrius/waystones/manager/LocalizationManager;)V", "name", "", "getName", "()Ljava/lang/String;", "basePermission", "getBasePermission", "teleportSound", "Lnet/kyori/adventure/sound/Sound;", "Lorg/jetbrains/annotations/NotNull;", "build", "Lcom/mojang/brigadier/builder/ArgumentBuilder;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "base", "listEntries", "", "sender", "Lorg/bukkit/command/CommandSender;", "page", "click", "", "world", "Lorg/bukkit/World;", "info", "Lxyz/atrius/waystones/dao/WaystoneInfo;", "pageCount", "emptyWaystoneList", "getTeleportComponent", "Lnet/kyori/adventure/text/Component;", "hover", "Lxyz/atrius/waystones/kotlin/Function0;", "getNameComponent", "default", "Companion", "waystones"})
@SourceDebugExtension(value={"SMAP\nListCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListCommand.kt\nxyz/atrius/waystones/command/waystones/ListCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1#2:134\n*E\n"})
public final class ListCommand
implements WaystoneSubcommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WaystoneInfoRepository waystoneInfoRepository;
    @NotNull
    private final LocalizationManager localization;
    @NotNull
    private final String name;
    @NotNull
    private final String basePermission;
    @NotNull
    private final Sound teleportSound;
    private static final int PAGE_SIZE = 10;

    public ListCommand(@NotNull WaystoneInfoRepository waystoneInfoRepository, @NotNull LocalizationManager localization) {
        Intrinsics.checkNotNullParameter(waystoneInfoRepository, "waystoneInfoRepository");
        Intrinsics.checkNotNullParameter(localization, "localization");
        this.waystoneInfoRepository = waystoneInfoRepository;
        this.localization = localization;
        this.name = "list";
        this.basePermission = "waystones.admin.list";
        Sound sound = Sound.sound((Key)Key.key((String)"entity.experience_orb.pickup"), (Sound.Source)Sound.Source.UI, (float)1.0f, (float)1.0f);
        Intrinsics.checkNotNullExpressionValue(sound, "sound(...)");
        this.teleportSound = sound;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getBasePermission() {
        return this.basePermission;
    }

    @Override
    @NotNull
    public ArgumentBuilder<CommandSourceStack, ?> build(@NotNull ArgumentBuilder<CommandSourceStack, ?> base) {
        Intrinsics.checkNotNullParameter(base, "base");
        ArgumentBuilder argumentBuilder = base.then(Commands.argument((String)"page", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1, (int)this.pageCount()))).executes(arg_0 -> ListCommand.build$lambda$0(this, arg_0))).executes(arg_0 -> ListCommand.build$lambda$1(this, arg_0));
        Intrinsics.checkNotNullExpressionValue(argumentBuilder, "executes(...)");
        return argumentBuilder;
    }

    private final int listEntries(CommandSender sender, int page) {
        int offset = (page - 1) * 10;
        List<WaystoneInfo> waystones = this.waystoneInfoRepository.getAll(10, offset).get();
        String unnamedWaystone = this.localization.get("unnamed-waystone", new Object[0]).format(sender instanceof Player ? (Player)sender : null);
        if (waystones.isEmpty()) {
            this.emptyWaystoneList(sender, page);
            return 1;
        }
        PlayerKt.message$default(sender, this.localization.get("plugin-header", new Object[0]), '\u0000', 2, null);
        Map worlds = new LinkedHashMap();
        String p0 = this.localization.get("waystone-list-hover", new Object[0]).format(sender instanceof Player ? (Player)sender : null);
        boolean bl = false;
        TextComponent textComponent = Component.text((String)p0);
        Intrinsics.checkNotNullExpressionValue(textComponent, "let(...)");
        TextComponent hover = textComponent;
        for (WaystoneInfo info : waystones) {
            World world;
            if (worlds.computeIfAbsent(info.getWorldUid(), arg_0 -> ListCommand.listEntries$lambda$3(arg_0 -> ListCommand.listEntries$lambda$2(info, arg_0), arg_0)) == null) continue;
            String string = world.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            Component component = this.getTeleportComponent(string, info, (Component)hover, () -> ListCommand.listEntries$lambda$4(this, sender, world, info)).appendSpace().append(this.getNameComponent(info, unnamedWaystone));
            Intrinsics.checkNotNullExpressionValue(component, "append(...)");
            Component entry = component;
            sender.sendMessage(entry);
        }
        PlayerKt.message$default(sender, this.localization.get("plugin-footer", new Object[0]), '\u0000', 2, null);
        return 1;
    }

    static /* synthetic */ int listEntries$default(ListCommand listCommand, CommandSender commandSender, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return listCommand.listEntries(commandSender, n);
    }

    public final void click(@NotNull CommandSender sender, @NotNull World world, @NotNull WaystoneInfo info) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(info, "info");
        if (!(sender instanceof Player)) {
            return;
        }
        Location location = world.getBlockAt(info.getX(), info.getY() + 1, info.getZ()).getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location location2 = location;
        ((Player)sender).teleport(LocationKt.getCenter(location2));
        sender.playSound(this.teleportSound);
    }

    private final int pageCount() {
        Object t = ((CompletableFuture)this.waystoneInfoRepository.entries().thenApplyAsync(arg_0 -> ListCommand.pageCount$lambda$6(ListCommand::pageCount$lambda$5, arg_0))).get();
        Intrinsics.checkNotNullExpressionValue(t, "get(...)");
        return RangesKt.coerceAtLeast(((Number)t).intValue(), 1);
    }

    private final void emptyWaystoneList(CommandSender sender, int page) {
        if (page == 1) {
            PlayerKt.message$default(sender, this.localization.get("waystone-list-empty", new Object[0]), '\u0000', 2, null);
        } else {
            Object[] objectArray = new Object[]{page};
            PlayerKt.message$default(sender, this.localization.get("waystone-list-no-entries", objectArray), '\u0000', 2, null);
        }
    }

    private final Component getTeleportComponent(String name, WaystoneInfo info, Component hover, Function0<Unit> click) {
        Component component = ((TextComponent)Component.text((String)StringKt.translateColors$default("&d&l[&7" + name + "@" + info.getX() + ":" + info.getY() + ":" + info.getZ() + "&d&l]", '\u0000', 1, null)).clickEvent(ClickEvent.callback(arg_0 -> ListCommand.getTeleportComponent$lambda$7(click, arg_0)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)hover));
        Intrinsics.checkNotNullExpressionValue(component, "hoverEvent(...)");
        return component;
    }

    private final Component getNameComponent(WaystoneInfo info, String string) {
        String string2 = info.getName();
        if (string2 == null) {
            string2 = string;
        }
        TextComponent textComponent = Component.text((String)StringKt.translateColors$default("&r&b&o" + string2, '\u0000', 1, null));
        Intrinsics.checkNotNullExpressionValue(textComponent, "text(...)");
        return (Component)textComponent;
    }

    private static final int build$lambda$0(ListCommand this$0, CommandContext it) {
        Integer page = (Integer)it.getArgument("page", Integer.TYPE);
        CommandSender commandSender = ((CommandSourceStack)it.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        Intrinsics.checkNotNull(page);
        return this$0.listEntries(commandSender, page);
    }

    private static final int build$lambda$1(ListCommand this$0, CommandContext it) {
        CommandSender commandSender = ((CommandSourceStack)it.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        return ListCommand.listEntries$default(this$0, commandSender, 0, 2, null);
    }

    private static final World listEntries$lambda$2(WaystoneInfo $info, UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Bukkit.getWorld((UUID)$info.getWorldUid());
    }

    private static final World listEntries$lambda$3(Function1 $tmp0, Object p0) {
        return (World)$tmp0.invoke(p0);
    }

    private static final Unit listEntries$lambda$4(ListCommand this$0, CommandSender $sender, World $world, WaystoneInfo $info) {
        this$0.click($sender, $world, $info);
        return Unit.INSTANCE;
    }

    private static final Integer pageCount$lambda$5(Integer it) {
        return (int)Math.ceil((double)it.intValue() / (double)10);
    }

    private static final Integer pageCount$lambda$6(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    private static final void getTeleportComponent$lambda$7(Function0 $click, Audience it) {
        Intrinsics.checkNotNullParameter(it, "it");
        $click.invoke();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lxyz/atrius/waystones/command/waystones/ListCommand$Companion;", "", "<init>", "()V", "PAGE_SIZE", "", "waystones"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

