/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.animation.effect;

import java.util.List;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.atrius.waystones.animation.effect.TeleportEffect;
import xyz.atrius.waystones.data.config.property.WaitTimeProperty;
import xyz.atrius.waystones.data.config.property.WarpAnimationsProperty;
import xyz.atrius.waystones.kotlin.Metadata;
import xyz.atrius.waystones.kotlin.collections.CollectionsKt;
import xyz.atrius.waystones.kotlin.jvm.internal.Intrinsics;
import xyz.atrius.waystones.kotlin.jvm.internal.SourceDebugExtension;
import xyz.atrius.waystones.kotlin.ranges.RangesKt;
import xyz.atrius.waystones.manager.LocalizationManager;
import xyz.atrius.waystones.service.WaystoneService;
import xyz.atrius.waystones.utility.LocationKt;
import xyz.atrius.waystones.utility.WorldKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lxyz/atrius/waystones/animation/effect/SimpleTeleportEffect;", "Lxyz/atrius/waystones/animation/effect/TeleportEffect;", "warp", "Lxyz/atrius/waystones/service/WaystoneService$Warp;", "warpAnimations", "Lxyz/atrius/waystones/data/config/property/WarpAnimationsProperty;", "waitTime", "Lxyz/atrius/waystones/data/config/property/WaitTimeProperty;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "<init>", "(Lxyz/atrius/waystones/service/WaystoneService$Warp;Lxyz/atrius/waystones/data/config/property/WarpAnimationsProperty;Lxyz/atrius/waystones/data/config/property/WaitTimeProperty;Lxyz/atrius/waystones/manager/LocalizationManager;)V", "bar", "Lnet/kyori/adventure/bossbar/BossBar;", "Lorg/jetbrains/annotations/NotNull;", "bossBarColors", "", "Lnet/kyori/adventure/bossbar/BossBar$Color;", "textColors", "Lnet/kyori/adventure/text/format/NamedTextColor;", "xyz.atrius.waystones.kotlin.jvm.PlatformType", "start", "", "animation", "timer", "", "max", "end", "endAtLocation", "location", "Lorg/bukkit/Location;", "cancel", "waystones"})
@SourceDebugExtension(value={"SMAP\nSimpleTeleportEffect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleTeleportEffect.kt\nxyz/atrius/waystones/animation/effect/SimpleTeleportEffect\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
public final class SimpleTeleportEffect
implements TeleportEffect {
    @NotNull
    private final WaystoneService.Warp warp;
    @NotNull
    private final WarpAnimationsProperty warpAnimations;
    @NotNull
    private final WaitTimeProperty waitTime;
    @NotNull
    private final LocalizationManager localization;
    @NotNull
    private final BossBar bar;
    @NotNull
    private final List<BossBar.Color> bossBarColors;
    @NotNull
    private final List<NamedTextColor> textColors;

    public SimpleTeleportEffect(@NotNull WaystoneService.Warp warp, @NotNull WarpAnimationsProperty warpAnimations, @NotNull WaitTimeProperty waitTime, @NotNull LocalizationManager localization) {
        Intrinsics.checkNotNullParameter(warp, "warp");
        Intrinsics.checkNotNullParameter(warpAnimations, "warpAnimations");
        Intrinsics.checkNotNullParameter(waitTime, "waitTime");
        Intrinsics.checkNotNullParameter(localization, "localization");
        this.warp = warp;
        this.warpAnimations = warpAnimations;
        this.waitTime = waitTime;
        this.localization = localization;
        BossBar bossBar = BossBar.bossBar((Component)((Component)Component.text((String)"Wait Time")), (float)1.0f, (BossBar.Color)BossBar.Color.RED, (BossBar.Overlay)BossBar.Overlay.PROGRESS);
        Intrinsics.checkNotNullExpressionValue(bossBar, "bossBar(...)");
        this.bar = bossBar;
        BossBar.Color[] colorArray = new BossBar.Color[]{BossBar.Color.GREEN, BossBar.Color.RED, BossBar.Color.RED};
        this.bossBarColors = CollectionsKt.listOf(colorArray);
        colorArray = new NamedTextColor[]{NamedTextColor.GREEN, NamedTextColor.RED, NamedTextColor.DARK_RED};
        this.textColors = CollectionsKt.listOf(colorArray);
    }

    @Override
    public void start() {
        Location location = this.warp.getPlayer().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Sound sound = Sound.BLOCK_PORTAL_AMBIENT;
        Intrinsics.checkNotNullExpressionValue(sound, "BLOCK_PORTAL_AMBIENT");
        LocationKt.playSound$default(location, sound, 0.0f, 0.0f, 2, null);
        this.warp.getPlayer().showBossBar(this.bar);
    }

    @Override
    public void animation(long timer, long max) {
        Player player = this.warp.getPlayer();
        int seconds = (int)Math.ceil((double)timer / 20.0);
        float progress = (float)timer / (float)((Number)this.waitTime.value()).doubleValue();
        int color = RangesKt.coerceIn((int)(progress * (float)this.bossBarColors.size()), 0, this.bossBarColors.size() - 1);
        Object[] objectArray = new Object[]{this.warp.getName(), seconds};
        String p0 = this.localization.get("warp-wait", objectArray).format(player);
        boolean bl = false;
        Component component = Component.text((String)p0).color((TextColor)this.textColors.get(color));
        Intrinsics.checkNotNullExpressionValue(component, "color(...)");
        TextComponent waitMessage = (TextComponent)component;
        this.bar.name((Component)waitMessage).progress(progress).color(this.bossBarColors.get(color));
        if (!((Boolean)this.warpAnimations.value()).booleanValue()) {
            return;
        }
        double amp = ((Number)this.waitTime.value()).doubleValue() - (double)timer + 0.1;
        long ratio = timer * (long)2 + 1L;
        double period = System.currentTimeMillis() / (long)3;
        World world = player.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        World world2 = world;
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        WorldKt.forceParticle$default(world2, Particle.ASH, LocationKt.rotateY(location, period, (double)timer / amp), 200, 0.0, 0.0, 0.0, 0.0, 120, null);
        Location location2 = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
        WorldKt.forceParticle(world2, Particle.LARGE_SMOKE, location2, 250 / (int)ratio, 0.2, 0.5, 0.2, 0.0);
    }

    @Override
    public void end() {
        this.warp.getPlayer().stopSound(Sound.BLOCK_PORTAL_AMBIENT);
        this.warp.getPlayer().hideBossBar(this.bar);
    }

    @Override
    public void endAtLocation(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        World world = this.warp.getPlayer().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        WorldKt.forceParticle(world, Particle.LARGE_SMOKE, LocationKt.getCenter(LocationKt.getUP(location)), 400, 0.2, 0.5, 0.2, 0.1);
        Sound sound = Sound.ENTITY_STRAY_DEATH;
        Intrinsics.checkNotNullExpressionValue(sound, "ENTITY_STRAY_DEATH");
        LocationKt.playSound(location, sound, 0.5f, 0.0f);
        Sound sound2 = Sound.BLOCK_BELL_RESONATE;
        Intrinsics.checkNotNullExpressionValue(sound2, "BLOCK_BELL_RESONATE");
        LocationKt.playSound(location, sound2, 20.0f, 0.0f);
        Sound sound3 = Sound.BLOCK_RESPAWN_ANCHOR_DEPLETE;
        Intrinsics.checkNotNullExpressionValue(sound3, "BLOCK_RESPAWN_ANCHOR_DEPLETE");
        LocationKt.playSound$default(location, sound3, 0.0f, 0.0f, 6, null);
    }

    @Override
    public void cancel() {
        Player player = this.warp.getPlayer();
        player.hideBossBar(this.bar);
        player.stopSound(Sound.BLOCK_PORTAL_AMBIENT);
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Sound sound = Sound.BLOCK_BEACON_DEACTIVATE;
        Intrinsics.checkNotNullExpressionValue(sound, "BLOCK_BEACON_DEACTIVATE");
        LocationKt.playSound(location, sound, 20.0f, 0.0f);
    }
}

