/*
 * Decompiled with CFR 0.152.
 */
package me.Athar42.audioplayer2customdiscs.commandapi.wrappers;

import java.util.Objects;

public class Rotation {
    private final float yaw;
    private final float pitch;

    public Rotation(float yaw, float pitch) {
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getNormalizedYaw() {
        float normalizedYaw = this.yaw % 360.0f;
        if (normalizedYaw >= 180.0f) {
            normalizedYaw -= 360.0f;
        } else if (normalizedYaw < -180.0f) {
            normalizedYaw += 360.0f;
        }
        return normalizedYaw;
    }

    public float getNormalizedPitch() {
        return this.pitch > 90.0f ? 90.0f : Math.max(this.pitch, -90.0f);
    }

    public String toString() {
        return this.yaw + " " + this.pitch;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.pitch), Float.valueOf(this.yaw));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Rotation)) {
            return false;
        }
        Rotation other = (Rotation)obj;
        return Float.floatToIntBits(this.pitch) == Float.floatToIntBits(other.pitch) && Float.floatToIntBits(this.yaw) == Float.floatToIntBits(other.yaw);
    }
}

