/*
 * Decompiled with CFR 0.152.
 */
package me.Athar42.audioplayer2customdiscs.commandapi;

import io.papermc.paper.event.server.ServerResourcesReloadedEvent;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner;
import me.Athar42.audioplayer2customdiscs.commandapi.BukkitTooltip;
import me.Athar42.audioplayer2customdiscs.commandapi.CommandAPI;
import me.Athar42.audioplayer2customdiscs.commandapi.CommandAPIBukkit;
import me.Athar42.audioplayer2customdiscs.commandapi.CommandAPILogger;
import me.Athar42.audioplayer2customdiscs.commandapi.CommandRegistrationStrategy;
import me.Athar42.audioplayer2customdiscs.commandapi.InternalPaperConfig;
import me.Athar42.audioplayer2customdiscs.commandapi.PaperCommandRegistration;
import me.Athar42.audioplayer2customdiscs.commandapi.Platform;
import me.Athar42.audioplayer2customdiscs.commandapi.Schedulers;
import me.Athar42.audioplayer2customdiscs.commandapi.commandsenders.BukkitBlockCommandSender;
import me.Athar42.audioplayer2customdiscs.commandapi.commandsenders.BukkitCommandSender;
import me.Athar42.audioplayer2customdiscs.commandapi.commandsenders.BukkitConsoleCommandSender;
import me.Athar42.audioplayer2customdiscs.commandapi.commandsenders.BukkitEntity;
import me.Athar42.audioplayer2customdiscs.commandapi.commandsenders.BukkitFeedbackForwardingCommandSender;
import me.Athar42.audioplayer2customdiscs.commandapi.commandsenders.BukkitNativeProxyCommandSender;
import me.Athar42.audioplayer2customdiscs.commandapi.commandsenders.BukkitPlayer;
import me.Athar42.audioplayer2customdiscs.commandapi.commandsenders.BukkitProxiedCommandSender;
import me.Athar42.audioplayer2customdiscs.commandapi.commandsenders.BukkitRemoteConsoleCommandSender;
import me.Athar42.audioplayer2customdiscs.commandapi.exceptions.WrapperCommandSyntaxException;
import me.Athar42.audioplayer2customdiscs.commandapi.nms.BundledNMS;
import me.Athar42.audioplayer2customdiscs.commandapi.wrappers.NativeProxyCommandSender;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Bukkit;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.ProxiedCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.slf4j.Logger;

public class CommandAPIPaper<Source>
extends CommandAPIBukkit<Source> {
    private static CommandAPIPaper<?> paper;
    private boolean isPaperPresent = true;
    private boolean isFoliaPresent = false;
    private final Class<? extends CommandSender> feedbackForwardingCommandSender;
    private final Class<? extends CommandSender> nullCommandSender;
    private CommandAPILogger bootstrapLogger;
    private LifecycleEventOwner lifecycleEventOwner;

    protected CommandAPIPaper(InternalPaperConfig config, BundledNMS<Source> nms) {
        paper = this;
        CommandAPIBukkit.config = config;
        this.lifecycleEventOwner = config.getLifecycleEventOwner();
        this.nms = nms;
        Class<?> tempFeedbackForwardingCommandSender = null;
        Class<?> tempNullCommandSender = null;
        try {
            tempFeedbackForwardingCommandSender = Class.forName("io.papermc.paper.commands.FeedbackForwardingSender");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            tempNullCommandSender = Class.forName("io.papermc.paper.brigadier.NullCommandSender");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.feedbackForwardingCommandSender = tempFeedbackForwardingCommandSender;
        this.nullCommandSender = tempNullCommandSender;
    }

    public static <Source> CommandAPIPaper<Source> getPaper() {
        if (paper != null) {
            return paper;
        }
        throw new IllegalStateException("Tried to access CommandAPIPaper instance, but it was null! Are you using CommandAPI features before calling CommandAPI#onLoad?");
    }

    public static InternalPaperConfig getConfiguration() {
        return (InternalPaperConfig)CommandAPIBukkit.getConfiguration();
    }

    public LifecycleEventOwner getLifecycleEventOwner() {
        return this.lifecycleEventOwner;
    }

    @Override
    public BundledNMS<Source> getNMS() {
        if (this.nms != null) {
            return (BundledNMS)this.nms;
        }
        throw new IllegalStateException("Tried to access NMS instance, but it was null! Are you using CommandAPI features before calling CommandAPI#onLoad?");
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.checkPaperDependencies();
        PaperCommandRegistration registration = (PaperCommandRegistration)this.getCommandRegistrationStrategy();
        registration.registerLifecycleEvent();
    }

    @Override
    public void onEnable() {
        this.plugin = (JavaPlugin)Bukkit.getPluginManager().getPlugin(CommandAPIPaper.getConfiguration().getPluginName());
        this.lifecycleEventOwner = this.plugin;
        new Schedulers(CommandAPIPaper.paper.isFoliaPresent).scheduleSyncDelayed((Plugin)this.plugin, () -> {
            CommandAPIBukkit.get().getCommandRegistrationStrategy().runTasksAfterServerStart();
            if (CommandAPIPaper.paper.isFoliaPresent) {
                CommandAPI.logNormal("Skipping initial datapack reloading because Folia was detected");
            } else if (!CommandAPIPaper.getConfiguration().skipReloadDatapacks()) {
                CommandAPIBukkit.get().reloadDataPacks();
            }
            CommandAPIBukkit.get().updateHelpForCommands(CommandAPI.getRegisteredCommands());
        }, 0L);
        super.stopCommandRegistrations();
        if (CommandAPIPaper.paper.isPaperPresent) {
            Bukkit.getServer().getPluginManager().registerEvents(new Listener(){

                @EventHandler
                public void onServerReloadResources(ServerResourcesReloadedEvent event) {
                    CommandAPIBukkit.get().getCommandRegistrationStrategy().preReloadDataPacks();
                    if (CommandAPIPaper.getConfiguration().hookPaperReload()) {
                        CommandAPI.logNormal("/minecraft:reload detected. Reloading CommandAPI commands!");
                        CommandAPIBukkit.get().reloadDataPacks();
                    }
                }
            }, (Plugin)this.plugin);
            CommandAPI.logNormal("Hooked into Paper ServerResourcesReloadedEvent");
        } else {
            CommandAPI.logNormal("Did not hook into Paper ServerResourcesReloadedEvent while using commandapi-paper. Are you actually using Paper?");
        }
        PaperCommandRegistration registration = (PaperCommandRegistration)this.getCommandRegistrationStrategy();
        registration.registerLifecycleEvent();
    }

    private void checkPaperDependencies() {
        block7: {
            block6: {
                try {
                    Class.forName("net.kyori.adventure.text.Component");
                    CommandAPI.logNormal("Hooked into Adventure for AdventureChat/AdventureChatComponents");
                }
                catch (ClassNotFoundException e) {
                    if (!CommandAPI.getConfiguration().hasVerboseOutput()) break block6;
                    CommandAPI.logWarning("Could not hook into Adventure for AdventureChat/AdventureChatComponents");
                }
            }
            this.isPaperPresent = false;
            try {
                Class.forName("io.papermc.paper.event.server.ServerResourcesReloadedEvent");
                this.isPaperPresent = true;
                CommandAPI.logNormal("Hooked into Paper for paper-specific API implementations");
            }
            catch (ClassNotFoundException e) {
                this.isPaperPresent = false;
                if (!CommandAPI.getConfiguration().hasVerboseOutput()) break block7;
                CommandAPI.logWarning("Could not hook into Paper for /minecraft:reload. Consider upgrading to Paper: https://papermc.io/");
            }
        }
        this.isFoliaPresent = false;
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            this.isFoliaPresent = true;
            CommandAPI.logNormal("Hooked into Folia for folia-specific API implementations");
            CommandAPI.logNormal("Folia support is still in development. Please report any issues to the CommandAPI developers!");
        }
        catch (ClassNotFoundException e) {
            this.isFoliaPresent = false;
        }
    }

    @Override
    public CommandMap getCommandMap() {
        return Bukkit.getCommandMap();
    }

    @Override
    public Platform activePlatform() {
        return Platform.PAPER;
    }

    @Override
    public CommandRegistrationStrategy<Source> createCommandRegistrationStrategy() {
        return this.getNMS().createCommandRegistrationStrategy();
    }

    @Override
    public BukkitCommandSender<? extends CommandSender> wrapCommandSender(CommandSender sender) {
        if (sender instanceof BlockCommandSender) {
            BlockCommandSender block = (BlockCommandSender)sender;
            return new BukkitBlockCommandSender(block);
        }
        if (sender instanceof ConsoleCommandSender) {
            ConsoleCommandSender console = (ConsoleCommandSender)sender;
            return new BukkitConsoleCommandSender(console);
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return new BukkitPlayer(player);
        }
        if (sender instanceof Entity) {
            Entity entity = (Entity)sender;
            return new BukkitEntity(entity);
        }
        if (sender instanceof NativeProxyCommandSender) {
            NativeProxyCommandSender nativeProxy = (NativeProxyCommandSender)sender;
            return new BukkitNativeProxyCommandSender(nativeProxy);
        }
        if (sender instanceof ProxiedCommandSender) {
            ProxiedCommandSender proxy = (ProxiedCommandSender)sender;
            return new BukkitProxiedCommandSender(proxy);
        }
        if (sender instanceof RemoteConsoleCommandSender) {
            RemoteConsoleCommandSender remote = (RemoteConsoleCommandSender)sender;
            return new BukkitRemoteConsoleCommandSender(remote);
        }
        if (this.feedbackForwardingCommandSender.isInstance(sender)) {
            return new BukkitFeedbackForwardingCommandSender<CommandSender>(this.feedbackForwardingCommandSender.cast(sender));
        }
        if (this.nullCommandSender != null && this.nullCommandSender.isInstance(sender)) {
            return null;
        }
        throw new RuntimeException("Failed to wrap CommandSender " + String.valueOf(sender) + " to a CommandAPI-compatible BukkitCommandSender");
    }

    public static WrapperCommandSyntaxException failWithAdventureComponent(ComponentLike message) {
        return CommandAPI.failWithMessage(BukkitTooltip.messageFromAdventureComponent(message));
    }

    @Override
    public CommandAPILogger getLogger() {
        if (Bukkit.getServer() != null) {
            return super.getLogger();
        }
        if (this.bootstrapLogger == null) {
            this.bootstrapLogger = CommandAPILogger.fromSlf4jLogger((Logger)ComponentLogger.logger((String)"CommandAPI"));
        }
        return this.bootstrapLogger;
    }
}

