/*
 * Decompiled with CFR 0.152.
 */
package me.Athar42.ap2cd.listener;

import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import java.io.File;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Logger;
import me.Athar42.ap2cd.AudioPlayer2CustomDiscs;
import me.Athar42.ap2cd.command.SubCommands.Convert;
import me.Athar42.ap2cd.utils.AP2CDUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.component.CustomData;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Jukebox;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class AutoConvertJukeBox
implements Listener {
    AudioPlayer2CustomDiscs plugin = AudioPlayer2CustomDiscs.getInstance();
    private final Logger pluginLogger = this.plugin.getLogger();
    private final NamespacedKey convertedKeyRetrieval = new NamespacedKey((Plugin)this.plugin, "converted");

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerInsert(PlayerInteractEvent event) {
        if (AudioPlayer2CustomDiscs.getReverseAutomaticConvertMode()) {
            return;
        }
        if (event.getClickedBlock() == null || event.getClickedBlock().getType() != Material.JUKEBOX) {
            return;
        }
        ItemStack discItemStack = event.getItem();
        if (discItemStack == null || !this.isVanillaMusicDisc(discItemStack)) {
            return;
        }
        this.convertIfNeeded(discItemStack);
        if (!event.getItem().hasData((DataComponentType)DataComponentTypes.TOOLTIP_DISPLAY) || !((TooltipDisplay)event.getItem().getData(DataComponentTypes.TOOLTIP_DISPLAY)).hiddenComponents().contains(DataComponentTypes.JUKEBOX_PLAYABLE)) {
            event.getItem().setData(DataComponentTypes.TOOLTIP_DISPLAY, (Object)((TooltipDisplay)TooltipDisplay.tooltipDisplay().addHiddenComponents(new DataComponentType[]{DataComponentTypes.JUKEBOX_PLAYABLE}).build()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onHopperMove(InventoryMoveItemEvent event) {
        if (AudioPlayer2CustomDiscs.getReverseAutomaticConvertMode()) {
            return;
        }
        if (!(event.getDestination().getHolder() instanceof Jukebox)) {
            return;
        }
        ItemStack discItemStack = event.getItem();
        if (!this.isVanillaMusicDisc(discItemStack)) {
            return;
        }
        this.convertIfNeeded(discItemStack);
        if (!event.getItem().hasData((DataComponentType)DataComponentTypes.TOOLTIP_DISPLAY) || !((TooltipDisplay)event.getItem().getData(DataComponentTypes.TOOLTIP_DISPLAY)).hiddenComponents().contains(DataComponentTypes.JUKEBOX_PLAYABLE)) {
            event.getItem().setData(DataComponentTypes.TOOLTIP_DISPLAY, (Object)((TooltipDisplay)TooltipDisplay.tooltipDisplay().addHiddenComponents(new DataComponentType[]{DataComponentTypes.JUKEBOX_PLAYABLE}).build()));
        }
        event.setItem(discItemStack);
    }

    private void convertIfNeeded(ItemStack disc) {
        ItemMeta discMeta = disc.getItemMeta();
        if (((Boolean)discMeta.getPersistentDataContainer().getOrDefault(this.convertedKeyRetrieval, PersistentDataType.BOOLEAN, (Object)false)).booleanValue()) {
            if (this.isDebugEnabled()) {
                this.pluginLogger.info("AP2CD-DEBUG-031 - Disc has already been converted.");
            }
            return;
        }
        net.minecraft.world.item.ItemStack itemCopyAsNMS = CraftItemStack.asNMSCopy((ItemStack)disc);
        if (!itemCopyAsNMS.has(DataComponents.CUSTOM_DATA)) {
            if (this.isDebugEnabled()) {
                this.pluginLogger.info("AP2CD-DEBUG-032 - Disc has no 'minecraft:custom_data' - Not converting.");
            }
            return;
        }
        CustomData customDataRetrieval = (CustomData)itemCopyAsNMS.get(DataComponents.CUSTOM_DATA);
        CompoundTag tagCompoundRetrieval = customDataRetrieval.copyTag();
        UUID uuid = this.extractUUIDFromTag(tagCompoundRetrieval);
        if (uuid == null) {
            if (this.isDebugEnabled()) {
                this.pluginLogger.info("AP2CD-DEBUG-033 - No usable 'CustomSound' or 'audioplayer' found.");
            }
            return;
        }
        Optional rangeRetrievalOptional = tagCompoundRetrieval.getFloat("CustomSoundRange");
        Float rangeRetrieved = rangeRetrievalOptional.orElse(null);
        File audioFolder = new File(Bukkit.getWorldContainer(), "plugins/CustomDiscs/musicdata");
        String filename = AP2CDUtils.findSoundFile(audioFolder, uuid);
        if (filename == null) {
            if (this.isDebugEnabled()) {
                this.pluginLogger.warning("AP2CD-DEBUG-034 - No file found for UUID " + String.valueOf(uuid));
            }
            return;
        }
        this.applyDiscMeta(disc, filename, rangeRetrieved);
        if (this.isDebugEnabled()) {
            this.pluginLogger.info("AP2CD-DEBUG-035 - Music disc converted!");
        }
    }

    private UUID extractUUIDFromTag(CompoundTag tag) {
        if (this.isDebugEnabled()) {
            this.pluginLogger.info("AP2CD-DEBUG-036A - UUID extraction process start.");
        }
        if (tag.contains("CustomSound")) {
            Optional customSoundRetrievedOptional;
            int[] ints;
            if (this.isDebugEnabled()) {
                this.pluginLogger.info("AP2CD-DEBUG-036B - UUID extraction from 'CustomSound'.");
            }
            if ((ints = (int[])(customSoundRetrievedOptional = tag.getIntArray("CustomSound")).orElse(null)) == null || ints.length != 4) {
                return null;
            }
            long msb = (long)ints[0] << 32 | (long)ints[1] & 0xFFFFFFFFL;
            long lsb = (long)ints[2] << 32 | (long)ints[3] & 0xFFFFFFFFL;
            UUID customsoundUUID = new UUID(msb, lsb);
            if (this.isDebugEnabled()) {
                this.pluginLogger.info("AP2CD-DEBUG-036C - CustomSound UUID extracted: " + String.valueOf(customsoundUUID) + ".");
            }
            return customsoundUUID;
        }
        if (tag.contains("audioplayer")) {
            Optional audioplayerRetrievedJsonOptional;
            String json;
            if (this.isDebugEnabled()) {
                this.pluginLogger.info("AP2CD-DEBUG-036D - UUID extraction from 'audioplayer'.");
            }
            if ((json = (String)(audioplayerRetrievedJsonOptional = tag.getString("audioplayer")).orElse(null)) == null) {
                return null;
            }
            String found = Convert.extractUUIDFromAudioPlayer(json);
            if (found == null) {
                return null;
            }
            try {
                UUID audioplayerUUID = UUID.fromString(found);
                if (this.isDebugEnabled()) {
                    this.pluginLogger.info("AP2CD-DEBUG-036E - audioplayer UUID extracted: " + String.valueOf(audioplayerUUID) + ".");
                }
                return audioplayerUUID;
            }
            catch (IllegalArgumentException ignored) {
                if (this.isDebugEnabled()) {
                    this.pluginLogger.info("AP2CD-DEBUG-036F - audioplayer UUID failed JSON to String retrieval.");
                }
                return null;
            }
        }
        if (this.isDebugEnabled()) {
            this.pluginLogger.info("AP2CD-DEBUG-036G - UUID extraction process end.");
        }
        return null;
    }

    private void applyDiscMeta(ItemStack disc, String filename, Float range) {
        if (this.isDebugEnabled()) {
            this.pluginLogger.info("AP2CD-DEBUG-037 - Disc meta being applied.");
        }
        ItemMeta discMeta = disc.getItemMeta();
        ArrayList<TextComponent> itemLore = new ArrayList<TextComponent>();
        TextComponent customLoreSong = (TextComponent)((TextComponent.Builder)((TextComponent.Builder)Component.text().decoration(TextDecoration.ITALIC, false)).content("AudioPlayer converted disc").color((TextColor)NamedTextColor.GRAY)).build();
        itemLore.add(customLoreSong);
        discMeta.lore(itemLore);
        PersistentDataContainer discPDCdata = discMeta.getPersistentDataContainer();
        discPDCdata.set(new NamespacedKey("customdiscs", "customdisc"), PersistentDataType.STRING, (Object)filename);
        if (range != null) {
            discPDCdata.set(new NamespacedKey("customdiscs", "range"), PersistentDataType.FLOAT, (Object)range);
        }
        discPDCdata.set(this.convertedKeyRetrieval, PersistentDataType.BOOLEAN, (Object)true);
        disc.setItemMeta(discMeta);
    }

    private boolean isVanillaMusicDisc(ItemStack item) {
        return item.getType().toString().startsWith("MUSIC_DISC");
    }

    private boolean isDebugEnabled() {
        return AudioPlayer2CustomDiscs.getDebugMode();
    }
}

