/*
 * Decompiled with CFR 0.152.
 */
package me.Athar42.ap2cd.listener;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Logger;
import me.Athar42.ap2cd.AudioPlayer2CustomDiscs;
import me.Athar42.ap2cd.command.SubCommands.Convert;
import me.Athar42.ap2cd.utils.AP2CDUtils;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.NotePlayEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class AutoConvertHeadPlay
implements Listener {
    AudioPlayer2CustomDiscs plugin = AudioPlayer2CustomDiscs.getInstance();
    private final Logger pluginLogger = this.plugin.getLogger();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onNotePlay(NotePlayEvent event) throws IOException {
        File audioPlayerFolder;
        String convertedFilename;
        CompoundTag headTagCompound;
        NamespacedKey convertedPDCKey;
        if (AudioPlayer2CustomDiscs.getReverseAutomaticConvertMode()) {
            return;
        }
        Block noteBlock = event.getBlock();
        if (noteBlock.getType() != Material.NOTE_BLOCK) {
            return;
        }
        Block headBlock = noteBlock.getRelative(BlockFace.UP);
        if (headBlock.getType() != Material.PLAYER_HEAD) {
            return;
        }
        Skull headSkull = (Skull)headBlock.getState();
        PersistentDataContainer headPDCdata = headSkull.getPersistentDataContainer();
        Boolean isPDCConverted = (Boolean)headPDCdata.get(convertedPDCKey = new NamespacedKey((Plugin)this.plugin, "converted"), PersistentDataType.BOOLEAN);
        if (isPDCConverted != null && isPDCConverted.booleanValue()) {
            if (this.isDebugEnabled()) {
                this.pluginLogger.info("AP2CD-DEBUG-008 - Head Block PDC already converted.");
            }
            return;
        }
        ItemStack skullItemStack = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)skullItemStack.getItemMeta();
        if (headSkull.getProfile() != null && headSkull.getProfile().name() != null && !headSkull.getProfile().name().isEmpty()) {
            String playerName = headSkull.getProfile().name();
            skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)playerName));
        } else if (headSkull.getProfile() != null && headSkull.getProfile().uuid() != null) {
            UUID playerUUID = headSkull.getProfile().uuid();
            skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)playerUUID));
        } else if (this.isDebugEnabled()) {
            this.pluginLogger.info("AP2CD-DEBUG-009 - Skull profile is invalid or missing a name/UUID.");
        }
        skullItemStack.setItemMeta((ItemMeta)skullMeta);
        if (this.isDebugEnabled()) {
            AutoConvertHeadPlay.debugPrintBlockEntityNBT(headBlock, this.pluginLogger);
        }
        if ((headTagCompound = AutoConvertHeadPlay.getBlockEntityNBT(headBlock)) == null || !headTagCompound.contains("components")) {
            if (this.isDebugEnabled()) {
                this.pluginLogger.info("AP2CD-DEBUG-010 - No components found in block entity.");
            }
            return;
        }
        Optional headComponentsOptional = headTagCompound.getCompound("components");
        if (headComponentsOptional.isEmpty()) {
            if (this.isDebugEnabled()) {
                this.pluginLogger.info("AP2CD-DEBUG-011 - No components found in block entity.");
            }
            return;
        }
        CompoundTag headComponents = (CompoundTag)headComponentsOptional.get();
        Optional headCustomDataOptional = headComponents.getCompound("minecraft:custom_data");
        if (headCustomDataOptional.isEmpty()) {
            if (this.isDebugEnabled()) {
                this.pluginLogger.info("AP2CD-DEBUG-012 - No 'minecraft:custom_data' component found.");
            }
            return;
        }
        CompoundTag headCustomData = (CompoundTag)headCustomDataOptional.get();
        boolean headHasCustomSound = headCustomData.contains("CustomSound");
        boolean headHasAudioPlayer = headCustomData.contains("audioplayer");
        if (!headHasCustomSound && !headHasAudioPlayer) {
            if (this.isDebugEnabled()) {
                this.pluginLogger.info("AP2CD-DEBUG-013 - Skull block has no CustomSound nor audioplayer.");
            }
            return;
        }
        UUID uuid = null;
        if (headHasCustomSound) {
            Optional customSoundIntOptional = headCustomData.getIntArray("CustomSound");
            int[] customSoundInts = customSoundIntOptional.orElse(null);
            if (customSoundInts == null || customSoundInts.length != 4) {
                if (this.isDebugEnabled()) {
                    this.pluginLogger.warning("AP2CD-DEBUG-014 - Invalid CustomSound format.");
                }
                return;
            }
            long msb = (long)customSoundInts[0] << 32 | (long)customSoundInts[1] & 0xFFFFFFFFL;
            long lsb = (long)customSoundInts[2] << 32 | (long)customSoundInts[3] & 0xFFFFFFFFL;
            uuid = new UUID(msb, lsb);
            if (this.isDebugEnabled()) {
                this.pluginLogger.info("AP2CD-DEBUG-015 - CustomSound UUID: " + String.valueOf(uuid) + ".");
            }
        } else {
            Optional audioplayerJsonOptional = headCustomData.getString("audioplayer");
            String audioplayerJson = audioplayerJsonOptional.orElse(null);
            if (audioplayerJson != null) {
                String extractedUUIDString;
                if (this.isDebugEnabled()) {
                    this.pluginLogger.info("AP2CD-DEBUG-016A - Found audioplayer JSON: " + audioplayerJson + ".");
                }
                if ((extractedUUIDString = Convert.extractUUIDFromAudioPlayer(audioplayerJson)) != null) {
                    try {
                        uuid = UUID.fromString(extractedUUIDString);
                    }
                    catch (IllegalArgumentException ex) {
                        if (this.isDebugEnabled()) {
                            this.pluginLogger.info("AP2CD-DEBUG-017A - Invalid UUID format from audioplayer JSON.");
                        }
                        return;
                    }
                } else {
                    if (this.isDebugEnabled()) {
                        this.pluginLogger.info("AP2CD-DEBUG-017B - Could not extract UUID from audioplayer JSON.");
                    }
                    return;
                }
            }
            if (this.isDebugEnabled()) {
                this.pluginLogger.info("AP2CD-DEBUG-016B - 'audioplayer' tag exists but is not a StringTag.");
            }
            return;
        }
        Optional customSoundRangeTagOptional = headCustomData.getFloat("CustomSoundRange");
        Float retrievedRangeValue = null;
        if (customSoundRangeTagOptional.isPresent()) {
            retrievedRangeValue = (Float)customSoundRangeTagOptional.get();
            if (this.isDebugEnabled()) {
                this.pluginLogger.info("AP2CD-DEBUG-018A - Found CustomSoundRange: " + retrievedRangeValue + ".");
            }
        } else if (this.isDebugEnabled()) {
            this.pluginLogger.info("AP2CD-DEBUG-018B - This item has no 'CustomSoundRange' value.");
        }
        if ((convertedFilename = AP2CDUtils.findSoundFile(audioPlayerFolder = new File(Bukkit.getWorldContainer(), "plugins/CustomDiscs/musicdata"), uuid)) == null) {
            if (this.isDebugEnabled()) {
                this.pluginLogger.info("AP2CD-DEBUG-019 - Error: No matching sound file found for UUID " + String.valueOf(uuid) + ".");
            }
            return;
        }
        this.setHeadMeta(headBlock, convertedFilename, retrievedRangeValue);
        if (this.isDebugEnabled()) {
            this.pluginLogger.info("AP2CD-DEBUG-020 - Item has been converted!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onHeadPlace(BlockPlaceEvent event) {
        Float retrievedRangeValue;
        UUID uuid;
        CustomData customDataRetrieval;
        block34: {
            if (AudioPlayer2CustomDiscs.getReverseAutomaticConvertMode()) {
                return;
            }
            ItemStack item = event.getItemInHand();
            if (item.getType() != Material.PLAYER_HEAD) {
                return;
            }
            ItemMeta itemMeta = item.getItemMeta();
            if (!(itemMeta instanceof SkullMeta)) {
                return;
            }
            SkullMeta meta = (SkullMeta)itemMeta;
            net.minecraft.world.item.ItemStack itemCopyAsNMS = CraftItemStack.asNMSCopy((ItemStack)item);
            if (!itemCopyAsNMS.has(DataComponents.CUSTOM_DATA)) {
                if (this.isDebugEnabled()) {
                    this.pluginLogger.info("AP2CD-DEBUG-021 - This item has no 'minecraft:custom_data' - Not converting.");
                }
                return;
            }
            if (!itemCopyAsNMS.has(DataComponents.BLOCK_ENTITY_DATA)) {
                if (this.isDebugEnabled()) {
                    this.pluginLogger.info("AP2CD-DEBUG-057 - No BLOCK_ENTITY_DATA");
                }
            } else {
                TypedEntityData dataIsConverted = (TypedEntityData)itemCopyAsNMS.get(DataComponents.BLOCK_ENTITY_DATA);
                CompoundTag tagCompoundIsConverted = dataIsConverted.copyTagWithBlockEntityId();
                Optional pdcRetrievalOptional = tagCompoundIsConverted.getCompound("PublicBukkitValues");
                if (pdcRetrievalOptional.isEmpty()) {
                    if (this.isDebugEnabled()) {
                        this.pluginLogger.info("AP2CD-DEBUG-058 - No PublicBukkitValues inside this BLOCK_ENTITY_DATA.");
                    }
                } else {
                    Optional convertedRetrievalOptional;
                    boolean converted;
                    String pdcConvertedKey;
                    CompoundTag publicBukkitValues = (CompoundTag)pdcRetrievalOptional.get();
                    if (publicBukkitValues.contains(pdcConvertedKey = new NamespacedKey((Plugin)this.plugin, "converted").toString()) && (converted = (convertedRetrievalOptional = publicBukkitValues.getBoolean(pdcConvertedKey)).orElse(false).booleanValue())) {
                        if (this.isDebugEnabled()) {
                            this.pluginLogger.info("AP2CD-DEBUG-056 - Head Block PDC already converted.");
                        }
                        return;
                    }
                }
            }
            customDataRetrieval = (CustomData)itemCopyAsNMS.get(DataComponents.CUSTOM_DATA);
            CompoundTag tagCompoundRetrieval = customDataRetrieval.copyTag();
            uuid = null;
            if (tagCompoundRetrieval.contains("CustomSound")) {
                Tag tagSoundRetrieval = tagCompoundRetrieval.get("CustomSound");
                if (tagSoundRetrieval instanceof IntArrayTag) {
                    IntArrayTag intArrayTag = (IntArrayTag)tagSoundRetrieval;
                    int[] ints = intArrayTag.getAsIntArray();
                    if (ints.length == 4) {
                        long msb = (long)ints[0] << 32 | (long)ints[1] & 0xFFFFFFFFL;
                        long lsb = (long)ints[2] << 32 | (long)ints[3] & 0xFFFFFFFFL;
                        uuid = new UUID(msb, lsb);
                        break block34;
                    } else {
                        if (this.isDebugEnabled()) {
                            this.pluginLogger.info("AP2CD-DEBUG-022 - The 'CustomSound' format is invalid - Not converting.");
                        }
                        return;
                    }
                }
                if (this.isDebugEnabled()) {
                    this.pluginLogger.info("AP2CD-DEBUG-023 - The 'CustomSound' tag exists but is not an IntArrayTag - Not converting.");
                }
                return;
            }
            if (tagCompoundRetrieval.contains("audioplayer")) {
                Tag audioplayerTagRetrieval = tagCompoundRetrieval.get("audioplayer");
                if (audioplayerTagRetrieval instanceof StringTag) {
                    StringTag stringTag = (StringTag)audioplayerTagRetrieval;
                    String json = stringTag.toString();
                    String extractedUUIDString = Convert.extractUUIDFromAudioPlayer(json);
                    if (extractedUUIDString != null) {
                        try {
                            uuid = UUID.fromString(extractedUUIDString);
                        }
                        catch (IllegalArgumentException ex) {
                            if (this.isDebugEnabled()) {
                                this.pluginLogger.info("AP2CD-DEBUG-024A - Invalid UUID format from audioplayer JSON.");
                            }
                            return;
                        }
                    } else {
                        if (this.isDebugEnabled()) {
                            this.pluginLogger.info("AP2CD-DEBUG-024B - Could not extract UUID from audioplayer JSON.");
                        }
                        return;
                    }
                }
                if (this.isDebugEnabled()) {
                    this.pluginLogger.info("AP2CD-DEBUG-025 - 'audioplayer' tag exists but is not a StringTag.");
                }
                return;
            }
            if (this.isDebugEnabled()) {
                this.pluginLogger.info("AP2CD-DEBUG-026 - Item has no 'CustomSound' or 'audioplayer' value - Not converting.");
            }
            return;
        }
        Tag tagSoundRangeRetrieval = customDataRetrieval.copyTag().get("CustomSoundRange");
        if (tagSoundRangeRetrieval instanceof FloatTag) {
            FloatTag floatTag = (FloatTag)tagSoundRangeRetrieval;
            retrievedRangeValue = Float.valueOf(floatTag.floatValue());
        } else {
            retrievedRangeValue = null;
            if (this.isDebugEnabled()) {
                this.pluginLogger.info("AP2CD-DEBUG-027 - This item has no 'CustomSoundRange' value.");
            }
        }
        File audioPlayerFolder = new File(Bukkit.getWorldContainer(), "plugins/CustomDiscs/musicdata");
        String convertedFilename = AP2CDUtils.findSoundFile(audioPlayerFolder, uuid);
        if (convertedFilename != null) {
            Block block = event.getBlockPlaced();
            Bukkit.getRegionScheduler().runDelayed((Plugin)this.plugin, block.getLocation(), task -> {
                if (block.getType() != Material.PLAYER_HEAD && block.getType() != Material.PLAYER_WALL_HEAD) {
                    return;
                }
                this.setHeadMeta(block, convertedFilename, retrievedRangeValue);
                if (this.isDebugEnabled()) {
                    this.pluginLogger.info("AP2CD-DEBUG-029 - Item has been converted!");
                }
            }, 1L);
            return;
        }
        if (this.isDebugEnabled()) {
            this.pluginLogger.info("AP2CD-DEBUG-028 - Error: No matching sound file found for UUID " + String.valueOf(uuid) + ".");
        }
    }

    public static CompoundTag getBlockEntityNBT(Block block) {
        BlockPos position;
        ServerLevel level = ((CraftWorld)block.getWorld()).getHandle();
        BlockEntity blockEntityData = level.getBlockEntity(position = new BlockPos(block.getX(), block.getY(), block.getZ()));
        if (blockEntityData == null) {
            return null;
        }
        RegistryAccess registries = level.registryAccess();
        return blockEntityData.saveWithFullMetadata((HolderLookup.Provider)registries);
    }

    public void setHeadMeta(Block skullBlock, String convertedFilename, Float retrievedRangeValue) {
        BlockState blockState = skullBlock.getState();
        if (!(blockState instanceof Skull)) {
            if (this.isDebugEnabled()) {
                this.pluginLogger.info("AP2CD-DEBUG-030 - The block is not a skull, cannot set metadata.");
            }
            return;
        }
        Skull skull = (Skull)blockState;
        PersistentDataContainer dataHead = skull.getPersistentDataContainer();
        dataHead.set(new NamespacedKey("customdiscs", "customhead"), PersistentDataType.STRING, (Object)convertedFilename);
        BuildableComponent customLoreHead = ((TextComponent.Builder)((TextComponent.Builder)Component.text().decoration(TextDecoration.ITALIC, false)).content("AudioPlayer converted head").color((TextColor)NamedTextColor.GRAY)).build();
        String serialized = (String)GsonComponentSerializer.gson().serialize((Component)customLoreHead);
        dataHead.set(new NamespacedKey("customdiscs", "headlore"), PersistentDataType.STRING, (Object)serialized);
        if (retrievedRangeValue != null) {
            dataHead.set(new NamespacedKey("customdiscs", "range"), PersistentDataType.FLOAT, (Object)retrievedRangeValue);
        }
        dataHead.set(new NamespacedKey((Plugin)this.plugin, "converted"), PersistentDataType.BOOLEAN, (Object)true);
        skull.update(true, true);
    }

    public static void debugPrintBlockEntityNBT(Block block, Logger logger) {
        logger.info("=== DEBUG BlockEntity NBT START ===");
        logger.info("Block at " + block.getX() + " " + block.getY() + " " + block.getZ());
        logger.info("Type: " + String.valueOf(block.getType()));
        ServerLevel level = ((CraftWorld)block.getWorld()).getHandle();
        BlockPos position = new BlockPos(block.getX(), block.getY(), block.getZ());
        BlockEntity blockEntityData = level.getBlockEntity(position);
        if (blockEntityData == null) {
            logger.info("BlockEntity = null");
            logger.info("=== DEBUG BE NBT END ===");
            return;
        }
        RegistryAccess registries = level.registryAccess();
        CompoundTag fullTag = blockEntityData.saveWithFullMetadata((HolderLookup.Provider)registries);
        logger.info("saveWithFullMetadata: " + String.valueOf(fullTag));
        CompoundTag updateTag = blockEntityData.getUpdateTag((HolderLookup.Provider)registries);
        logger.info("getUpdateTag: " + String.valueOf(updateTag));
        logger.info("=== DEBUG BE NBT END ===");
    }

    private boolean isDebugEnabled() {
        return AudioPlayer2CustomDiscs.getDebugMode();
    }
}

