/*
 * Decompiled with CFR 0.152.
 */
package me.Athar42.audioplayer2customdiscs.commandapi;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.Athar42.audioplayer2customdiscs.commandapi.CommandAPI;
import me.Athar42.audioplayer2customdiscs.commandapi.CommandAPIHandler;
import me.Athar42.audioplayer2customdiscs.commandapi.CommandPermission;
import me.Athar42.audioplayer2customdiscs.commandapi.CommandRegistrationStrategy;
import me.Athar42.audioplayer2customdiscs.commandapi.RegisteredCommand;
import me.Athar42.audioplayer2customdiscs.commandapi.SafeVarHandle;
import org.bukkit.command.Command;
import org.bukkit.command.SimpleCommandMap;

public class SpigotCommandRegistration<Source>
extends CommandRegistrationStrategy<Source> {
    private final CommandDispatcher<Source> brigadierDispatcher;
    private final SimpleCommandMap commandMap;
    private final Supplier<CommandDispatcher<Source>> getResourcesDispatcher;
    private final Predicate<Command> isVanillaCommandWrapper;
    private final Function<CommandNode<Source>, Command> wrapToVanillaCommandWrapper;
    private final Predicate<CommandNode<Source>> isBukkitCommandWrapper;
    private final Set<String> namespacesToFix = new HashSet<String>();
    private RootCommandNode<Source> minecraftCommandNamespaces = new RootCommandNode();
    private final SafeVarHandle<SimpleCommandMap, Map<String, Command>> commandMapKnownCommands;

    public SpigotCommandRegistration(CommandDispatcher<Source> brigadierDispatcher, SimpleCommandMap commandMap, Supplier<CommandDispatcher<Source>> getResourcesDispatcher, Predicate<Command> isVanillaCommandWrapper, Function<CommandNode<Source>, Command> wrapToVanillaCommandWrapper, Predicate<CommandNode<Source>> isBukkitCommandWrapper) {
        this.brigadierDispatcher = brigadierDispatcher;
        this.commandMap = commandMap;
        this.getResourcesDispatcher = getResourcesDispatcher;
        this.isVanillaCommandWrapper = isVanillaCommandWrapper;
        this.wrapToVanillaCommandWrapper = wrapToVanillaCommandWrapper;
        this.isBukkitCommandWrapper = isBukkitCommandWrapper;
        this.commandMapKnownCommands = SafeVarHandle.ofOrNull(SimpleCommandMap.class, "knownCommands", "knownCommands", Map.class);
    }

    public CommandDispatcher<Source> getResourcesDispatcher() {
        return this.getResourcesDispatcher.get();
    }

    public boolean isVanillaCommandWrapper(Command command) {
        return this.isVanillaCommandWrapper.test(command);
    }

    public Command wrapToVanillaCommandWrapper(CommandNode<Source> node) {
        return this.wrapToVanillaCommandWrapper.apply(node);
    }

    public boolean isBukkitCommandWrapper(CommandNode<Source> node) {
        return this.isBukkitCommandWrapper.test(node);
    }

    private String unpackInternalPermissionNodeString(CommandPermission perm) {
        Optional<String> optionalPerm = perm.getPermission();
        if (perm.isNegated() || perm.equals(CommandPermission.NONE) || perm.equals(CommandPermission.OP)) {
            return "";
        }
        if (optionalPerm.isPresent()) {
            return optionalPerm.get();
        }
        throw new IllegalStateException("Invalid permission detected: " + String.valueOf(perm) + "! This should never happen - if you're seeing this message, pleasecontact the developers of the CommandAPI, we'd love to know how you managed to get this error!");
    }

    @Override
    public CommandDispatcher<Source> getBrigadierDispatcher() {
        return this.brigadierDispatcher;
    }

    @Override
    public void runTasksAfterServerStart() {
        this.fixNamespaces();
        this.fixPermissions();
    }

    private void fixNamespaces() {
        Map<String, Command> knownCommands = this.commandMapKnownCommands.get(this.commandMap);
        RootCommandNode resourcesRootNode = this.getResourcesDispatcher.get().getRoot();
        for (String command : this.namespacesToFix) {
            knownCommands.remove(command);
            this.removeBrigadierCommands(resourcesRootNode, command, false, c -> true);
        }
        RootCommandNode brigadierRootNode = this.brigadierDispatcher.getRoot();
        for (CommandNode node : this.minecraftCommandNamespaces.getChildren()) {
            knownCommands.put(node.getName(), this.wrapToVanillaCommandWrapper.apply(node));
            resourcesRootNode.addChild(node);
            brigadierRootNode.addChild(node);
        }
        this.minecraftCommandNamespaces = new RootCommandNode();
    }

    private void fixPermissions() {
        TreeMap<String, CommandPermission> permissionsToFix = CommandAPIHandler.getInstance().registeredPermissions;
        if (!permissionsToFix.isEmpty()) {
            CommandAPI.logInfo("Linking permissions to commands:");
            for (Map.Entry entry : permissionsToFix.entrySet()) {
                String cmdName = (String)entry.getKey();
                CommandPermission perm = (CommandPermission)entry.getValue();
                CommandAPI.logInfo("  " + perm.toString() + " -> /" + cmdName);
                String permNode = this.unpackInternalPermissionNodeString(perm);
                Command command = this.commandMap.getCommand(cmdName);
                if (command == null || !this.isVanillaCommandWrapper.test(command)) continue;
                command.setPermission(permNode);
            }
        }
        CommandAPI.logNormal("Linked " + permissionsToFix.size() + " Bukkit permissions to commands");
    }

    @Override
    public void postCommandRegistration(RegisteredCommand registeredCommand, LiteralCommandNode<Source> resultantNode, List<LiteralCommandNode<Source>> aliasNodes) {
        if (!CommandAPI.canRegister()) {
            Map<String, Command> knownCommands = this.commandMapKnownCommands.get(this.commandMap);
            RootCommandNode root = this.getResourcesDispatcher.get().getRoot();
            String name = resultantNode.getLiteral();
            String namespace = registeredCommand.namespace();
            String permNode = this.unpackInternalPermissionNodeString(registeredCommand.permission());
            this.registerCommand(knownCommands, root, name, permNode, namespace, resultantNode);
            for (LiteralCommandNode<Source> node : aliasNodes) {
                this.registerCommand(knownCommands, root, node.getLiteral(), permNode, namespace, node);
            }
            Collection minecraftNamespacesToFix = this.minecraftCommandNamespaces.getChildren();
            if (!minecraftNamespacesToFix.isEmpty()) {
                RootCommandNode brigadierRootNode = this.brigadierDispatcher.getRoot();
                for (CommandNode node : minecraftNamespacesToFix) {
                    Command minecraftNamespaceCommand = this.wrapToVanillaCommandWrapper.apply(node);
                    knownCommands.put(node.getName(), minecraftNamespaceCommand);
                    minecraftNamespaceCommand.setPermission(permNode);
                    brigadierRootNode.addChild(node);
                }
                this.minecraftCommandNamespaces = new RootCommandNode();
            }
        }
    }

    private void registerCommand(Map<String, Command> knownCommands, RootCommandNode<Source> root, String name, String permNode, String namespace, LiteralCommandNode<Source> resultantNode) {
        Command command = this.wrapToVanillaCommandWrapper.apply((CommandNode<Source>)resultantNode);
        knownCommands.putIfAbsent(name, command);
        command.setPermission(permNode);
        root.addChild(resultantNode);
        LiteralCommandNode<Source> namespacedNode = CommandAPIHandler.getInstance().namespaceNode(resultantNode, namespace);
        if (namespace.equals("minecraft")) {
            knownCommands.putIfAbsent("minecraft:" + name, command);
        } else {
            Command namespacedCommand = this.wrapToVanillaCommandWrapper.apply((CommandNode<Source>)namespacedNode);
            knownCommands.putIfAbsent(namespacedCommand.getName(), namespacedCommand);
            namespacedCommand.setPermission(permNode);
        }
        root.addChild(namespacedNode);
    }

    @Override
    public LiteralCommandNode<Source> registerCommandNode(LiteralArgumentBuilder<Source> node, String namespace) {
        RootCommandNode rootNode = this.brigadierDispatcher.getRoot();
        LiteralCommandNode builtNode = node.build();
        String name = node.getLiteral();
        if (namespace.equals("minecraft")) {
            if (this.namespacesToFix.contains("minecraft:" + name)) {
                this.minecraftCommandNamespaces.addChild(CommandAPIHandler.getInstance().namespaceNode(builtNode, "minecraft"));
            }
        } else {
            this.fillNamespacesToFix(name, namespace + ":" + name);
            rootNode.addChild(CommandAPIHandler.getInstance().namespaceNode(builtNode, namespace));
        }
        rootNode.addChild((CommandNode)builtNode);
        return builtNode;
    }

    private void fillNamespacesToFix(String ... namespacedCommands) {
        for (String namespacedCommand : namespacedCommands) {
            CommandNode currentNode;
            if (!this.namespacesToFix.add("minecraft:" + namespacedCommand) || (currentNode = this.brigadierDispatcher.getRoot().getChild(namespacedCommand)) == null) continue;
            this.minecraftCommandNamespaces.addChild(CommandAPIHandler.getInstance().namespaceNode((LiteralCommandNode)currentNode, "minecraft"));
        }
    }

    @Override
    public void unregister(String commandName, boolean unregisterNamespaces, boolean unregisterBukkit) {
        if (!unregisterBukkit) {
            this.removeBrigadierCommands(this.brigadierDispatcher.getRoot(), commandName, unregisterNamespaces, c -> true);
            CommandAPIHandler.getInstance().writeDispatcherToFile();
        }
        if (unregisterBukkit || !CommandAPI.canRegister()) {
            Map<String, Command> knownCommands = this.commandMapKnownCommands.get(this.commandMap);
            boolean isMainVanilla = this.isVanillaCommandWrapper.test(knownCommands.get(commandName));
            if (unregisterBukkit ^ isMainVanilla) {
                knownCommands.remove(commandName);
            }
            if (unregisterNamespaces) {
                SpigotCommandRegistration.removeCommandNamespace(knownCommands, commandName, c -> unregisterBukkit ^ this.isVanillaCommandWrapper.test((Command)c));
            }
        }
        if (!CommandAPI.canRegister()) {
            this.removeBrigadierCommands(this.getResourcesDispatcher.get().getRoot(), commandName, unregisterNamespaces, c -> !unregisterBukkit ^ this.isBukkitCommandWrapper.test((CommandNode<Source>)c));
        }
    }

    @Override
    public void preReloadDataPacks() {
    }
}

