/*
 * Decompiled with CFR 0.152.
 */
package me.Athar42.audioplayer2customdiscs.commandapi;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.handler.configuration.LifecycleEventHandlerConfiguration;
import io.papermc.paper.plugin.lifecycle.event.handler.configuration.PrioritizedLifecycleEventHandlerConfiguration;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.Athar42.audioplayer2customdiscs.commandapi.CommandAPI;
import me.Athar42.audioplayer2customdiscs.commandapi.CommandAPIBukkit;
import me.Athar42.audioplayer2customdiscs.commandapi.CommandAPIHandler;
import me.Athar42.audioplayer2customdiscs.commandapi.CommandAPIPaper;
import me.Athar42.audioplayer2customdiscs.commandapi.CommandRegistrationStrategy;
import me.Athar42.audioplayer2customdiscs.commandapi.RegisteredCommand;
import org.bukkit.Bukkit;
import org.bukkit.help.HelpTopic;
import org.bukkit.plugin.java.JavaPlugin;

public class PaperCommandRegistration<Source>
extends CommandRegistrationStrategy<Source> {
    private final Supplier<CommandDispatcher<Source>> getBrigadierDispatcher;
    private final Runnable reloadHelpTopics;
    private final Predicate<CommandNode<Source>> isBukkitCommand;
    private final boolean[] lifecycleEventRegistered = new boolean[2];
    private final CommandDispatcher<CommandSourceStack> bootstrapDispatcher = new CommandDispatcher();
    private final CommandDispatcher<CommandSourceStack> pluginDispatcher = new CommandDispatcher();
    private final List<UnregisterInformation> unregisterInformationList = new ArrayList<UnregisterInformation>();

    public PaperCommandRegistration(Supplier<CommandDispatcher<Source>> getBrigadierDispatcher, Runnable reloadHelpTopics, Predicate<CommandNode<Source>> isBukkitCommand) {
        this.getBrigadierDispatcher = getBrigadierDispatcher;
        this.reloadHelpTopics = reloadHelpTopics;
        this.isBukkitCommand = isBukkitCommand;
    }

    public boolean isBukkitCommand(CommandNode<Source> node) {
        return this.isBukkitCommand.test(node);
    }

    @Override
    public CommandDispatcher<Source> getBrigadierDispatcher() {
        return this.getBrigadierDispatcher.get();
    }

    @Override
    public void runTasksAfterServerStart() {
    }

    @Override
    public void postCommandRegistration(RegisteredCommand registeredCommand, LiteralCommandNode<Source> resultantNode, List<LiteralCommandNode<Source>> aliasNodes) {
    }

    @Override
    public LiteralCommandNode<Source> registerCommandNode(LiteralArgumentBuilder<Source> node, String namespace) {
        LiteralCommandNode built = node.build();
        if (Bukkit.getServer() == null) {
            this.bootstrapDispatcher.getRoot().addChild((CommandNode)built);
        } else {
            this.pluginDispatcher.getRoot().addChild((CommandNode)built);
        }
        if (!CommandAPI.canRegister()) {
            Bukkit.reloadData();
        }
        return built;
    }

    @Override
    public void unregister(String commandName, boolean unregisterNamespaces, boolean unregisterBukkit) {
        this.unregisterInformationList.add(new UnregisterInformation(commandName, unregisterNamespaces, unregisterBukkit));
        if (!CommandAPI.canRegister()) {
            Bukkit.reloadData();
        }
    }

    @Override
    public void preReloadDataPacks() {
        this.reloadHelpTopics.run();
        CommandAPIBukkit.get().updateHelpForCommands(CommandAPI.getRegisteredCommands());
    }

    void registerLifecycleEvent() {
        boolean bootstrap;
        boolean bl = bootstrap = Bukkit.getServer() == null;
        if (bootstrap && !this.lifecycleEventRegistered[0]) {
            BootstrapContext context = (BootstrapContext)CommandAPIPaper.getPaper().getLifecycleEventOwner();
            this.lifecycleEventRegistered[0] = true;
            this.registerLifecycleEvent(context.getLifecycleManager(), this.bootstrapDispatcher);
            return;
        }
        if (!bootstrap && !this.lifecycleEventRegistered[1]) {
            JavaPlugin plugin = (JavaPlugin)CommandAPIPaper.getPaper().getLifecycleEventOwner();
            this.lifecycleEventRegistered[1] = true;
            this.registerLifecycleEvent(plugin.getLifecycleManager(), this.pluginDispatcher);
            plugin.getLifecycleManager().registerEventHandler((LifecycleEventHandlerConfiguration)((PrioritizedLifecycleEventHandlerConfiguration)LifecycleEvents.COMMANDS.newHandler(event -> {
                if (!this.unregisterInformationList.isEmpty()) {
                    for (UnregisterInformation unregisterInformation : this.unregisterInformationList) {
                        this.removeBrigadierCommands(this.getBrigadierDispatcher().getRoot(), unregisterInformation.commandName(), unregisterInformation.unregisterNamespaces(), c -> !unregisterInformation.unregisterBukkit() ^ this.isBukkitCommand.test((CommandNode<Source>)c));
                        this.removeBrigadierCommands(this.bootstrapDispatcher.getRoot(), unregisterInformation.commandName(), unregisterInformation.unregisterNamespaces(), c -> !unregisterInformation.unregisterBukkit() ^ this.isBukkitCommand.test((CommandNode<Source>)c));
                        this.removeBrigadierCommands(this.pluginDispatcher.getRoot(), unregisterInformation.commandName(), unregisterInformation.unregisterNamespaces(), c -> !unregisterInformation.unregisterBukkit() ^ this.isBukkitCommand.test((CommandNode<Source>)c));
                    }
                    CommandAPIHandler.getInstance().writeDispatcherToFile();
                }
            })).priority(1));
        }
    }

    private void registerLifecycleEvent(LifecycleEventManager<?> lifecycleEventManager, CommandDispatcher<CommandSourceStack> dispatcher) {
        lifecycleEventManager.registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            for (CommandNode commandNode : dispatcher.getRoot().getChildren()) {
                LiteralCommandNode node = (LiteralCommandNode)commandNode;
                ((Commands)event.registrar()).register(node, this.getDescription(node.getLiteral()));
            }
        });
    }

    private String getDescription(String commandName) {
        String namespaceStripped = commandName.contains(":") ? commandName.split(":")[1] : commandName;
        for (RegisteredCommand command : CommandAPI.getRegisteredCommands()) {
            if (!command.commandName().equals(namespaceStripped) && !Arrays.asList(command.aliases()).contains(namespaceStripped)) continue;
            Object helpTopic = command.helpTopic().orElse(null);
            if (helpTopic != null) {
                return ((HelpTopic)helpTopic).getShortText();
            }
            return command.shortDescription().orElse("A command by the " + CommandAPIBukkit.getConfiguration().getPluginName() + " plugin.");
        }
        return "";
    }

    private record UnregisterInformation(String commandName, boolean unregisterNamespaces, boolean unregisterBukkit) {
    }
}

