/*
 * Decompiled with CFR 0.152.
 */
package me.Athar42.audioplayer2customdiscs.commandapi;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.Athar42.audioplayer2customdiscs.commandapi.BukkitPlatform;
import me.Athar42.audioplayer2customdiscs.commandapi.CommandAPI;
import me.Athar42.audioplayer2customdiscs.commandapi.CommandAPICommand;
import me.Athar42.audioplayer2customdiscs.commandapi.CommandAPIHandler;
import me.Athar42.audioplayer2customdiscs.commandapi.CommandAPILogger;
import me.Athar42.audioplayer2customdiscs.commandapi.CommandMetaData;
import me.Athar42.audioplayer2customdiscs.commandapi.CommandRegistrationStrategy;
import me.Athar42.audioplayer2customdiscs.commandapi.InternalBukkitConfig;
import me.Athar42.audioplayer2customdiscs.commandapi.RegisteredCommand;
import me.Athar42.audioplayer2customdiscs.commandapi.arguments.AbstractArgument;
import me.Athar42.audioplayer2customdiscs.commandapi.arguments.Argument;
import me.Athar42.audioplayer2customdiscs.commandapi.arguments.LiteralArgument;
import me.Athar42.audioplayer2customdiscs.commandapi.arguments.MultiLiteralArgument;
import me.Athar42.audioplayer2customdiscs.commandapi.arguments.SuggestionProviders;
import me.Athar42.audioplayer2customdiscs.commandapi.commandsenders.AbstractCommandSender;
import me.Athar42.audioplayer2customdiscs.commandapi.commandsenders.AbstractPlayer;
import me.Athar42.audioplayer2customdiscs.commandapi.commandsenders.BukkitCommandSender;
import me.Athar42.audioplayer2customdiscs.commandapi.network.BukkitCommandAPIMessenger;
import me.Athar42.audioplayer2customdiscs.commandapi.nms.NMS;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.Recipe;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class CommandAPIBukkit<Source>
implements BukkitPlatform<Source> {
    private static CommandAPIBukkit<?> bukkit;
    protected static InternalBukkitConfig config;
    private BukkitCommandAPIMessenger messenger;
    protected JavaPlugin plugin;
    protected NMS<Source> nms;
    private CommandRegistrationStrategy<Source> commandRegistrationStrategy;
    private CommandAPILogger logger;
    private final boolean isPaperBrigAPI;

    protected CommandAPIBukkit() {
        boolean paperCommandSourceStackPresent;
        bukkit = this;
        try {
            Class.forName("io.papermc.paper.command.brigadier.CommandSourceStack");
            paperCommandSourceStackPresent = true;
        }
        catch (ClassNotFoundException e) {
            paperCommandSourceStackPresent = false;
        }
        this.isPaperBrigAPI = paperCommandSourceStackPresent;
    }

    public static <Source> CommandAPIBukkit<Source> get() {
        if (bukkit != null) {
            return bukkit;
        }
        throw new IllegalStateException("Tried to access CommandAPIBukkit instance, but it was null! Are you using CommandAPI features before calling CommandAPI#onLoad?");
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public NMS<Source> getNMS() {
        if (this.nms != null) {
            return this.nms;
        }
        throw new IllegalStateException("Tried to access NMS instance, but it was null! Are you using CommandAPI features before calling CommandAPI#onLoad?");
    }

    public static InternalBukkitConfig getConfiguration() {
        if (config != null) {
            return config;
        }
        throw new IllegalStateException("Tried to access InternalBukkitConfig, but it was null! Did you load the CommandAPI properly with CommandAPI#onLoad?");
    }

    public CommandRegistrationStrategy<Source> getCommandRegistrationStrategy() {
        return this.commandRegistrationStrategy;
    }

    @Override
    public void onLoad() {
        this.checkDependencies();
    }

    protected void stopCommandRegistrations() {
        Bukkit.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler(priority=EventPriority.LOWEST)
            public void onServerLoad(ServerLoadEvent event) {
                CommandAPI.stopCommandRegistration();
            }
        }, (Plugin)this.plugin);
    }

    protected void checkDependencies() {
        block3: {
            Class<?> nbtContainerClass = CommandAPIBukkit.getConfiguration().getNBTContainerClass();
            if (nbtContainerClass != null && CommandAPIBukkit.getConfiguration().getNBTContainerConstructor() != null) {
                CommandAPI.logNormal("Hooked into an NBT API with class " + nbtContainerClass.getName());
            }
            try {
                Class.forName("org.spigotmc.SpigotConfig");
                CommandAPI.logNormal("Hooked into Spigot successfully for Chat/ChatComponents");
            }
            catch (ClassNotFoundException e) {
                if (!CommandAPI.getConfiguration().hasVerboseOutput()) break block3;
                CommandAPI.logWarning("Could not hook into Spigot for Chat/ChatComponents");
            }
        }
        this.commandRegistrationStrategy = this.createCommandRegistrationStrategy();
    }

    private String generateCommandHelpPrefix(String command) {
        return (Bukkit.getPluginCommand((String)command) == null ? "/" : "/minecraft:") + command;
    }

    private String generateCommandHelpPrefix(String command, String namespace) {
        return (String)(Bukkit.getPluginCommand((String)command) == null ? "/" + namespace + ":" : "/minecraft:") + command;
    }

    private void generateHelpUsage(StringBuilder sb, RegisteredCommand command) {
        String[] usages = this.getUsageList(command);
        if (usages.length == 0) {
            return;
        }
        sb.append(ChatColor.GOLD).append("Usage: ").append(ChatColor.WHITE);
        if (usages.length == 1) {
            sb.append(usages[0]);
        } else {
            for (String usage : usages) {
                sb.append("\n- ").append(usage);
            }
        }
    }

    private String[] getUsageList(RegisteredCommand currentCommand) {
        String[] usages;
        ArrayList<RegisteredCommand> commandsWithIdenticalNames = new ArrayList<RegisteredCommand>();
        for (RegisteredCommand registeredCommand : CommandAPIHandler.getInstance().registeredCommands) {
            if (!registeredCommand.commandName().equals(currentCommand.commandName())) continue;
            commandsWithIdenticalNames.add(registeredCommand);
        }
        Optional<String[]> usageDescription = currentCommand.usageDescription();
        if (usageDescription.isPresent()) {
            usages = usageDescription.get();
        } else {
            int numCommandsWithIdenticalNames = commandsWithIdenticalNames.size();
            usages = new String[numCommandsWithIdenticalNames];
            for (int i = 0; i < numCommandsWithIdenticalNames; ++i) {
                RegisteredCommand command = (RegisteredCommand)commandsWithIdenticalNames.get(i);
                StringBuilder usageString = new StringBuilder();
                usageString.append("/").append(command.commandName()).append(" ");
                for (AbstractArgument<?, ?, ?, ?> arg : command.arguments()) {
                    usageString.append(arg.getHelpString()).append(" ");
                }
                usages[i] = usageString.toString().trim();
            }
        }
        return usages;
    }

    void updateHelpForCommands(List<RegisteredCommand> commands) {
        HashMap<String, HelpTopic> helpTopicsToAdd = new HashMap<String, HelpTopic>();
        for (RegisteredCommand command : commands) {
            Object shortDescription;
            HelpTopic helpTopic;
            if (this.isPaperBrigAPI && !command.shouldGenerateHelpTopic()) continue;
            String commandPrefix = this.generateCommandHelpPrefix(command.commandName());
            StringBuilder aliasSb = new StringBuilder();
            String permission = command.permission().getPermission().orElse("");
            Optional<Object> commandHelpTopic = command.helpTopic();
            if (commandHelpTopic.isPresent()) {
                helpTopic = (HelpTopic)commandHelpTopic.get();
                shortDescription = "";
            } else {
                Optional<String> shortDescriptionOptional = command.shortDescription();
                Optional<String> fullDescriptionOptional = command.fullDescription();
                shortDescription = shortDescriptionOptional.isPresent() ? shortDescriptionOptional.get() : (fullDescriptionOptional.isPresent() ? fullDescriptionOptional.get() : "A command by the " + this.plugin.getName() + " plugin.");
                StringBuilder sb = new StringBuilder();
                if (fullDescriptionOptional.isPresent()) {
                    sb.append(ChatColor.GOLD).append("Description: ").append(ChatColor.WHITE).append(fullDescriptionOptional.get()).append("\n");
                }
                this.generateHelpUsage(sb, command);
                sb.append("\n");
                aliasSb = new StringBuilder(sb.toString());
                if (command.aliases().length > 0) {
                    sb.append(ChatColor.GOLD).append("Aliases: ").append(ChatColor.WHITE).append(String.join((CharSequence)", ", command.aliases()));
                }
                helpTopic = this.nms.generateHelpTopic(commandPrefix, (String)shortDescription, sb.toString().trim(), permission);
            }
            helpTopicsToAdd.put(commandPrefix, helpTopic);
            for (String alias : command.aliases()) {
                if (commandHelpTopic.isPresent()) {
                    helpTopic = (HelpTopic)commandHelpTopic.get();
                } else {
                    StringBuilder currentAliasSb = new StringBuilder(aliasSb.toString());
                    currentAliasSb.append(ChatColor.GOLD).append("Aliases: ").append(ChatColor.WHITE);
                    ArrayList<String> aliases = new ArrayList<String>(Arrays.asList(command.aliases()));
                    aliases.add(command.commandName());
                    aliases.remove(alias);
                    currentAliasSb.append(String.join((CharSequence)", ", aliases));
                    commandPrefix = this.generateCommandHelpPrefix(alias);
                    helpTopic = this.nms.generateHelpTopic(commandPrefix, (String)shortDescription, currentAliasSb.toString().trim(), permission);
                }
                helpTopicsToAdd.put(commandPrefix, helpTopic);
            }
        }
        this.nms.getHelpMap().putAll(helpTopicsToAdd);
    }

    @Override
    public void onDisable() {
    }

    @Override
    public abstract BukkitCommandSender<? extends CommandSender> wrapCommandSender(CommandSender var1);

    @Override
    public void registerPermission(String string) {
        try {
            Bukkit.getPluginManager().addPermission(new Permission(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void preCommandRegistration(String commandName) {
        if (Bukkit.getServer() == null) {
            return;
        }
        PluginCommand pluginCommand = Bukkit.getPluginCommand((String)commandName);
        if (pluginCommand == null) {
            return;
        }
        String pluginName = pluginCommand.getPlugin().getName();
        if (this.plugin.getName().equals(pluginName)) {
            CommandAPI.logWarning("Plugin command /%s is registered by Bukkit (%s). Did you forget to remove this from your plugin.yml file?".formatted(commandName, pluginName));
        } else {
            CommandAPI.logNormal("Plugin command /%s is registered by Bukkit (%s). You may have to use /minecraft:%s to execute your command.".formatted(commandName, pluginName, commandName));
        }
    }

    @Override
    public void postCommandRegistration(RegisteredCommand registeredCommand, LiteralCommandNode<Source> resultantNode, List<LiteralCommandNode<Source>> aliasNodes) {
        this.commandRegistrationStrategy.postCommandRegistration(registeredCommand, resultantNode, aliasNodes);
        if (!CommandAPI.canRegister()) {
            this.updateHelpForCommands(List.of(registeredCommand));
            for (Player p : Bukkit.getOnlinePlayers()) {
                p.updateCommands();
            }
        }
    }

    @Override
    public LiteralCommandNode<Source> registerCommandNode(LiteralArgumentBuilder<Source> node, String namespace) {
        return this.commandRegistrationStrategy.registerCommandNode(node, namespace);
    }

    @Override
    public void unregister(String commandName, boolean unregisterNamespaces) {
        this.unregisterInternal(commandName, unregisterNamespaces, false);
    }

    public static void unregister(String commandName, boolean unregisterNamespaces, boolean unregisterBukkit) {
        CommandAPIBukkit.get().unregisterInternal(commandName, unregisterNamespaces, unregisterBukkit);
    }

    private void unregisterInternal(String commandName, boolean unregisterNamespaces, boolean unregisterBukkit) {
        CommandAPI.logInfo("Unregistering command /" + commandName);
        this.commandRegistrationStrategy.unregister(commandName, unregisterNamespaces, unregisterBukkit);
        if (!CommandAPI.canRegister()) {
            this.nms.getHelpMap().remove("/" + commandName);
            for (Player p : Bukkit.getOnlinePlayers()) {
                p.updateCommands();
            }
        }
    }

    public BukkitCommandAPIMessenger setupMessenger() {
        this.messenger = new BukkitCommandAPIMessenger(this.plugin);
        return this.messenger;
    }

    @Override
    public BukkitCommandAPIMessenger getMessenger() {
        return this.messenger;
    }

    @Override
    public final CommandDispatcher<Source> getBrigadierDispatcher() {
        return this.commandRegistrationStrategy.getBrigadierDispatcher();
    }

    @Override
    public CommandAPILogger getLogger() {
        if (this.logger == null) {
            this.logger = new DefaultLogger();
        }
        return this.logger;
    }

    @Override
    public void updateRequirements(AbstractPlayer<?> player) {
        ((Player)player.getSource()).updateCommands();
    }

    @Override
    public Argument<String> newConcreteMultiLiteralArgument(String nodeName, String[] literals) {
        return new MultiLiteralArgument(nodeName, literals);
    }

    @Override
    public Argument<String> newConcreteLiteralArgument(String nodeName, String literal) {
        return new LiteralArgument(nodeName, literal);
    }

    public CommandAPICommand newConcreteCommandAPICommand(CommandMetaData<CommandSender> meta) {
        return new CommandAPICommand(meta);
    }

    public static <T> void initializeNBTAPI(Class<T> nbtContainerClass, Function<Object, T> nbtContainerConstructor) {
        CommandAPIBukkit.getConfiguration().lateInitializeNBT(nbtContainerClass, nbtContainerConstructor);
    }

    public void registerBukkitRecipesSafely(Iterator<Recipe> recipes) {
        while (recipes.hasNext()) {
            Recipe recipe = recipes.next();
            try {
                Bukkit.addRecipe((Recipe)recipe);
                if (!(recipe instanceof Keyed)) continue;
                Keyed keyedRecipe = (Keyed)recipe;
                CommandAPI.logInfo("Re-registering recipe: " + String.valueOf(keyedRecipe.getKey()));
            }
            catch (IllegalStateException keyedRecipe) {
            }
            catch (Exception e) {
                if (recipe instanceof Keyed) {
                    Keyed keyedRecipe = (Keyed)recipe;
                    CommandAPI.logError("Failed to register recipe " + String.valueOf(keyedRecipe.getKey()) + ": " + e.getMessage());
                    continue;
                }
                CommandAPI.logError("Failed to register recipe: " + e.getMessage());
            }
        }
    }

    boolean isInvalidNamespace(String commandName, String namespace) {
        if (namespace == null) {
            throw new NullPointerException("Parameter 'namespace' was null when registering command /" + commandName + "!");
        }
        if (namespace.isEmpty()) {
            CommandAPI.logNormal("Registering command '" + commandName + "' using the default namespace because an empty namespace was given!");
            return true;
        }
        if (!CommandAPIHandler.NAMESPACE_PATTERN.matcher(namespace).matches()) {
            CommandAPI.logNormal("Registering comand '" + commandName + "' using the default namespace because an invalid namespace (" + namespace + ") was given. Only 0-9, a-z, underscores, periods and hyphens are allowed!");
            return true;
        }
        return false;
    }

    @Override
    public BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<Source> cmdCtx, boolean forceNative) {
        return this.nms.getSenderForCommand(cmdCtx, forceNative);
    }

    @Override
    public Source getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> sender) {
        return this.nms.getBrigadierSourceFromCommandSender(sender);
    }

    @Override
    public SuggestionProvider<Source> getSuggestionProvider(SuggestionProviders suggestionProvider) {
        return this.nms.getSuggestionProvider(suggestionProvider);
    }

    @Override
    public BukkitCommandSender<? extends CommandSender> getCommandSenderFromCommandSource(Source css) {
        return this.nms.getCommandSenderFromCommandSource(css);
    }

    @Override
    public void createDispatcherFile(File file, CommandDispatcher<Source> dispatcher) throws IOException {
        this.nms.createDispatcherFile(file, dispatcher);
    }

    @Override
    public void reloadDataPacks() {
        this.nms.reloadDataPacks();
    }

    private static class DefaultLogger
    extends Logger
    implements CommandAPILogger {
        protected DefaultLogger() {
            super("CommandAPI", null);
            this.setParent(Bukkit.getServer().getLogger());
            this.setLevel(Level.ALL);
        }

        @Override
        public void severe(String message, Throwable exception) {
            super.log(Level.SEVERE, message, exception);
        }
    }
}

