/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.zapper.relocation;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import revxrsal.zapper.Dependency;
import revxrsal.zapper.classloader.IsolatedClassLoader;
import revxrsal.zapper.relocation.Relocation;
import revxrsal.zapper.repository.Repository;

public final class Relocator {
    private static boolean initialized = false;
    private static final List<Dependency> dependencies = Arrays.asList(new Dependency("org.ow2.asm", "asm", "9.7.1"), new Dependency("org.ow2.asm", "asm-commons", "9.7.1"), new Dependency("me.lucko", "jar-relocator", "1.7"));
    private static Constructor<?> relocatorConstructor;
    private static Method relocateMethod;

    private Relocator() {
    }

    public static void relocate(@NotNull File input, @NotNull File output, @NotNull List<Relocation> relocations) {
        if (!initialized) {
            Relocator.downloadJarRelocator(input.getParentFile());
            initialized = true;
        }
        try {
            LinkedHashMap<String, String> rules = new LinkedHashMap<String, String>();
            for (Relocation relocation : relocations) {
                rules.put(relocation.getPattern(), relocation.getNewPattern());
            }
            Object relocator = relocatorConstructor.newInstance(input, output, rules);
            relocateMethod.invoke(relocator, new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static void downloadJarRelocator(File dir) {
        try {
            URL[] urls = new URL[3];
            dir.mkdirs();
            for (int i = 0; i < dependencies.size(); ++i) {
                Dependency d = dependencies.get(i);
                File file = new File(dir, String.format("%s.%s-%s.jar", d.getGroupId(), d.getArtifactId(), d.getVersion()));
                if (!file.exists()) {
                    d.download(file, Repository.mavenCentral());
                }
                urls[i] = file.toURI().toURL();
            }
            IsolatedClassLoader classLoader = new IsolatedClassLoader(urls);
            Class<?> jarRelocator = classLoader.loadClass("me.lucko.jarrelocator.JarRelocator");
            relocatorConstructor = jarRelocator.getDeclaredConstructor(File.class, File.class, Map.class);
            relocatorConstructor.setAccessible(true);
            relocateMethod = jarRelocator.getDeclaredMethod("run", new Class[0]);
            relocateMethod.setAccessible(true);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

