/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.zapper;

import java.io.File;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import revxrsal.zapper.Dependency;
import revxrsal.zapper.DependencyDownloadException;
import revxrsal.zapper.DependencyDownloadResult;
import revxrsal.zapper.DependencyScope;
import revxrsal.zapper.TransitiveDependencyHelper;
import revxrsal.zapper.classloader.URLClassLoaderWrapper;
import revxrsal.zapper.relocation.Relocation;
import revxrsal.zapper.relocation.Relocator;
import revxrsal.zapper.remapper.PaperLibraryRemapper;
import revxrsal.zapper.repository.Repository;

public final class DependencyManager
implements DependencyScope {
    public static boolean FAILED_TO_DOWNLOAD = false;
    private static final Pattern COLON = Pattern.compile(":");
    private final File directory;
    private final URLClassLoaderWrapper loaderWrapper;
    private final List<Dependency> dependencies = new ArrayList<Dependency>();
    private final Set<Repository> repositories = new LinkedHashSet<Repository>();
    private final List<Relocation> relocations = new ArrayList<Relocation>();
    private final TransitiveDependencyHelper helper;
    private final PluginDescriptionFile pdf;

    public DependencyManager(PluginDescriptionFile pdf, @NotNull File directory, @NotNull URLClassLoaderWrapper loaderWrapper) {
        this.pdf = pdf;
        this.directory = directory;
        this.loaderWrapper = loaderWrapper;
        this.repositories.add(Repository.mavenCentral());
        this.helper = new TransitiveDependencyHelper(this, this.directory.toPath());
    }

    public void load() {
        try {
            ArrayList<Dependency> copy = new ArrayList<Dependency>(this.dependencies);
            for (Dependency dependency2 : copy) {
                this.dependencies.addAll(this.helper.findTransitiveLibraries(dependency2));
            }
            for (Dependency dep : this.dependencies) {
                File file = new File(this.directory, String.format("%s.%s-%s.jar", dep.getGroupId(), dep.getArtifactId(), dep.getVersion()));
                File relocated = new File(this.directory, String.format("%s.%s-%s-relocated.jar", dep.getGroupId(), dep.getArtifactId(), dep.getVersion()));
                if (this.hasRelocations() && relocated.exists()) {
                    this.loaderWrapper.addURL(PaperLibraryRemapper.tryRemap(this.pdf, relocated, dep.isRemap()).toURI().toURL(), dep.isRemap());
                    continue;
                }
                if (!file.exists()) {
                    boolean succeeded = false;
                    ArrayList<String> failedRepos = null;
                    for (Repository repository : this.repositories) {
                        DependencyDownloadResult result = dep.download(file, repository);
                        if (result.wasSuccessful()) {
                            succeeded = true;
                            break;
                        }
                        (failedRepos == null ? new ArrayList<String>() : failedRepos).add(repository.toString());
                    }
                    if (failedRepos != null && !succeeded) {
                        throw new DependencyDownloadException(dep, "Could not find dependency in any of the following repositories: " + String.join((CharSequence)"\n", failedRepos));
                    }
                }
                if (this.hasRelocations() && !relocated.exists()) {
                    Relocator.relocate(file, relocated, this.relocations);
                    file.delete();
                }
                if (this.hasRelocations()) {
                    this.loaderWrapper.addURL(PaperLibraryRemapper.tryRemap(this.pdf, relocated, dep.isRemap()).toURI().toURL(), dep.isRemap());
                    continue;
                }
                this.loaderWrapper.addURL(PaperLibraryRemapper.tryRemap(this.pdf, file, dep.isRemap()).toURI().toURL(), dep.isRemap());
            }
            this.loaderWrapper.flush();
        }
        catch (DependencyDownloadException e) {
            if (e.getCause() instanceof UnknownHostException) {
                Bukkit.getLogger().info("[Zapper] It appears you do not have an internet connection. Extract the zip in https://bit.ly/3cd3wGe at /Zapper/libraries.");
                FAILED_TO_DOWNLOAD = true;
            }
            throw e;
        }
        catch (RuntimeException d) {
            throw d;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public void dependency(@NotNull Dependency dependency2) {
        this.dependencies.add(dependency2);
    }

    public void dependency(@NotNull String dependency2) {
        String[] parts = COLON.split(dependency2);
        this.dependencies.add(new Dependency(parts[0], parts[1], parts[2], parts.length == 4 ? parts[3] : null));
    }

    public void dependency(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        this.dependencies.add(new Dependency(groupId, artifactId, version));
    }

    public void dependency(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @Nullable String classifier) {
        this.dependencies.add(new Dependency(groupId, artifactId, version, classifier));
    }

    public void relocate(@NotNull Relocation relocation) {
        this.relocations.add(relocation);
    }

    public void repository(@NotNull Repository repository) {
        this.repositories.add(repository);
    }

    public Set<Repository> repositories() {
        return this.repositories;
    }

    public boolean hasRelocations() {
        return !this.relocations.isEmpty();
    }
}

