/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.utils;

import com.artillexstudios.axvaults.AxVaults;
import com.artillexstudios.axvaults.libs.axapi.utils.StringUtils;
import com.artillexstudios.axvaults.libs.kyori.adventure.key.InvalidKeyException;
import com.artillexstudios.axvaults.libs.kyori.adventure.key.Key;
import com.artillexstudios.axvaults.libs.kyori.adventure.sound.Sound;
import com.artillexstudios.axvaults.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoundUtils {
    public static void playSound(@NotNull Player player, @Nullable String sound) {
        if (sound == null) {
            return;
        }
        if (sound.isBlank()) {
            return;
        }
        try {
            float volume = 1.0f;
            float pitch = 1.0f;
            String[] split = sound.split("\\|");
            if (split.length == 3) {
                volume = Float.parseFloat(split[1]);
                pitch = Float.parseFloat(split[2]);
            }
            Key key = Key.key(split[0]);
            Sound s = (Sound)Sound.sound().pitch(pitch).volume(volume).type(key).build();
            AxVaults.BUKKITAUDIENCES.player(player).playSound(s);
        }
        catch (InvalidKeyException ex) {
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF0000[AxVaults] The sound %sound% does not exist, this is a configuration issue!".replace("%sound%", sound), new TagResolver[0]));
        }
    }
}

