/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.schedulers;

import com.artillexstudios.axvaults.AxVaults;
import com.artillexstudios.axvaults.libs.axapi.utils.mutable.MutableInteger;
import com.artillexstudios.axvaults.vaults.Vault;
import com.artillexstudios.axvaults.vaults.VaultManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;

public class AutoSaveScheduler {
    private static ScheduledExecutorService service = null;
    private static long lastSave = -1L;
    private static long savedVaults = -1L;

    public static void start() {
        int time = AxVaults.CONFIG.getInt("auto-save-minutes");
        if (service != null) {
            service.shutdown();
        }
        service = Executors.newSingleThreadScheduledExecutor();
        service.scheduleAtFixedRate(() -> {
            try {
                long saveStart = System.currentTimeMillis();
                MutableInteger saved = new MutableInteger();
                ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
                ConcurrentLinkedQueue<Vault> concurrentLinkedQueue = VaultManager.getVaults();
                synchronized (concurrentLinkedQueue) {
                    Iterator<Vault> iterator = VaultManager.getVaults().iterator();
                    while (iterator.hasNext()) {
                        Vault vault = iterator.next();
                        if (vault.hasChanged().get()) {
                            futures.add(AxVaults.getDatabase().saveVault(vault));
                            saved.set(saved.get() + 1);
                        }
                        if (vault.isOpened()) continue;
                        vault.hasChanged().set(false);
                        if (Bukkit.getPlayer((UUID)vault.getUUID()) != null || System.currentTimeMillis() - vault.getLastOpen() <= (long)(time - 1) * 1000L) continue;
                        VaultManager.removeVault(vault);
                        iterator.remove();
                    }
                }
                CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).thenRun(() -> {
                    lastSave = System.currentTimeMillis() - saveStart;
                    savedVaults = saved.get().intValue();
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }, time, time, TimeUnit.MINUTES);
    }

    public static void stop() {
        if (service == null) {
            return;
        }
        service.shutdown();
    }

    public static long getLastSaveLength() {
        return lastSave;
    }

    public static long getSavedVaults() {
        return savedVaults;
    }
}

