/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.listeners;

import com.artillexstudios.axvaults.AxVaults;
import com.artillexstudios.axvaults.database.Database;
import com.artillexstudios.axvaults.database.impl.MySQL;
import com.artillexstudios.axvaults.vaults.VaultManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;

public class PlayerListeners
implements Listener {
    public PlayerListeners() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            VaultManager.loadPlayer(player.getUniqueId());
        }
    }

    @EventHandler
    public void onJoin(@NotNull PlayerJoinEvent event) {
        VaultManager.loadPlayer(event.getPlayer().getUniqueId());
        Database database = AxVaults.getDatabase();
        if (database instanceof MySQL) {
            MySQL db = (MySQL)database;
            db.checkForChanges();
        }
    }

    @EventHandler
    public void onQuit(@NotNull PlayerQuitEvent event) {
        VaultManager.getPlayer(event.getPlayer().getUniqueId(), vaultPlayer -> {
            vaultPlayer.save();
            Database patt0$temp = AxVaults.getDatabase();
            if (patt0$temp instanceof MySQL) {
                MySQL db = (MySQL)patt0$temp;
                db.checkForChanges();
            }
        });
    }
}

