/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.utils;

import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public final class Cooldown<T> {
    private final Object2LongMap<T> cooldowns;
    private final boolean synchronize;
    private final AtomicLong closestTime = new AtomicLong(Long.MAX_VALUE);

    public Cooldown() {
        this(false);
    }

    public Cooldown(boolean synchronize) {
        this.synchronize = synchronize;
        this.cooldowns = synchronize ? Object2LongMaps.synchronize((Object2LongMap)new Object2LongArrayMap()) : new Object2LongArrayMap();
    }

    public void addCooldown(T key, long time) {
        this.doHouseKeeping();
        long newTime = System.currentTimeMillis() + time;
        this.closestTime.getAndUpdate(a -> Math.min(a, newTime));
        this.cooldowns.put(key, newTime);
    }

    public long getRemaining(T key) {
        this.doHouseKeeping();
        return this.cooldowns.getOrDefault(key, System.currentTimeMillis()) - System.currentTimeMillis();
    }

    public long getRemainingAsSeconds(T key) {
        this.doHouseKeeping();
        return (this.cooldowns.getOrDefault(key, System.currentTimeMillis()) - System.currentTimeMillis()) / 1000L;
    }

    public boolean hasCooldown(T key) {
        this.doHouseKeeping();
        return this.cooldowns.containsKey(key);
    }

    public void clear() {
        this.cooldowns.clear();
    }

    public void remove(T key) {
        this.doHouseKeeping();
        this.cooldowns.removeLong(key);
    }

    public int size() {
        this.doHouseKeeping();
        return this.cooldowns.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(Consumer<ObjectIterator<Object2LongMap.Entry<T>>> iteratorConsumer) {
        this.doHouseKeeping();
        if (this.synchronize) {
            Object2LongMap<T> object2LongMap = this.cooldowns;
            synchronized (object2LongMap) {
                iteratorConsumer.accept(this.cooldowns.object2LongEntrySet().iterator());
            }
        } else {
            iteratorConsumer.accept(this.cooldowns.object2LongEntrySet().iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHouseKeeping() {
        if (System.currentTimeMillis() < this.closestTime.get()) {
            return;
        }
        if (this.synchronize) {
            Object2LongMap<T> object2LongMap = this.cooldowns;
            synchronized (object2LongMap) {
                ObjectIterator iterator = this.cooldowns.object2LongEntrySet().iterator();
                long time = System.currentTimeMillis();
                while (iterator.hasNext()) {
                    Object2LongMap.Entry entry = (Object2LongMap.Entry)iterator.next();
                    if (time < entry.getLongValue()) continue;
                    iterator.remove();
                }
            }
        } else {
            ObjectIterator iterator = this.cooldowns.object2LongEntrySet().iterator();
            long time = System.currentTimeMillis();
            while (iterator.hasNext()) {
                Object2LongMap.Entry entry = (Object2LongMap.Entry)iterator.next();
                if (time < entry.getLongValue()) continue;
                iterator.remove();
            }
        }
    }
}

