/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.utils;

import com.artillexstudios.axvaults.libs.axapi.AxPlugin;
import com.artillexstudios.axvaults.libs.axapi.libs.caffeine.caffeine.cache.Cache;
import com.artillexstudios.axvaults.libs.axapi.libs.caffeine.caffeine.cache.Caffeine;
import com.artillexstudios.axvaults.libs.axapi.nms.NMSHandlers;
import com.artillexstudios.axvaults.libs.axapi.serializers.Serializer;
import com.artillexstudios.axvaults.libs.kyori.adventure.text.Component;
import com.artillexstudios.axvaults.libs.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public final class ComponentSerializer {
    private static AxPlugin plugin;
    private final Serializer<Object, Component> serializer = NMSHandlers.getNmsHandler().componentSerializer();
    private final Cache<Component, Object> componentCache;
    private final Cache<Object, Component> vanillaCache;
    private final Cache<String, Component> gsonCache;

    public ComponentSerializer(AxPlugin instance) {
        plugin = instance;
        this.componentCache = Caffeine.newBuilder().maximumSize((long)((Integer)instance.flags().COMPONENT_CACHE_SIZE.get()).intValue()).expireAfterAccess(Duration.ofMinutes(5L)).build();
        this.vanillaCache = Caffeine.newBuilder().maximumSize((long)((Integer)instance.flags().COMPONENT_CACHE_SIZE.get()).intValue()).expireAfterAccess(Duration.ofMinutes(5L)).build();
        this.gsonCache = Caffeine.newBuilder().maximumSize((long)((Integer)instance.flags().COMPONENT_CACHE_SIZE.get()).intValue()).expireAfterAccess(Duration.ofMinutes(5L)).build();
    }

    public <T> T toVanilla(Component component) {
        return (T)this.componentCache.get((Object)component, this.serializer::deserialize);
    }

    public Component fromVanilla(Object object) {
        return (Component)this.vanillaCache.get(object, this.serializer::serialize);
    }

    public <T> List<T> toVanillaList(List<Component> components) {
        ArrayList<T> converted = new ArrayList<T>(components.size());
        for (int i = 0; i < components.size(); ++i) {
            Component component = components.get(i);
            converted.add(this.toVanilla(component));
        }
        return converted;
    }

    public List<Component> fromVanillaList(List<Object> objects) {
        ArrayList<Component> converted = new ArrayList<Component>(objects.size());
        for (int i = 0; i < objects.size(); ++i) {
            Object component = objects.get(i);
            converted.add(this.fromVanilla(component));
        }
        return converted;
    }

    public List<String> toGsonList(List<Component> list) {
        ArrayList<String> newList = new ArrayList<String>(list.size());
        for (Component component : list) {
            newList.add(this.toGson(component));
        }
        return newList;
    }

    public String toGson(Component component) {
        return (String)GsonComponentSerializer.gson().serialize(component);
    }

    public Component fromGson(String string) {
        return (Component)this.gsonCache.get((Object)string, s -> {
            try {
                return GsonComponentSerializer.gson().deserialize(s);
            }
            catch (Exception exception) {
                return Component.empty();
            }
        });
    }

    public List<Component> fromGsonList(List<String> list) {
        ArrayList<Component> newList = new ArrayList<Component>(list.size());
        for (String line : list) {
            newList.add(this.fromGson(line));
        }
        return newList;
    }

    public static ComponentSerializer instance() {
        return plugin.serializer();
    }
}

