/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.reflection;

import com.artillexstudios.axvaults.libs.axapi.libs.caffeine.caffeine.cache.Cache;
import com.artillexstudios.axvaults.libs.axapi.libs.caffeine.caffeine.cache.Caffeine;
import com.artillexstudios.axvaults.libs.axapi.utils.logging.LogUtils;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;

public enum ClassUtils {
    INSTANCE;

    private final Cache<String, Boolean> CLASS_CACHE = Caffeine.newBuilder().maximumSize(50L).build();

    public boolean classExists(@NotNull String className) {
        return Boolean.TRUE.equals(this.CLASS_CACHE.get((Object)className, name -> {
            try {
                Class.forName(name, false, ((Object)((Object)this)).getClass().getClassLoader());
                return true;
            }
            catch (ClassNotFoundException exception) {
                return false;
            }
        }));
    }

    public <T> T newInstance(String clazz) {
        try {
            return this.newInstance(Class.forName(clazz));
        }
        catch (ClassNotFoundException exception) {
            LogUtils.error("Could not find class {}!", clazz, exception);
            throw new RuntimeException(exception);
        }
    }

    public Class<?> getClass(String clazz) {
        try {
            return Class.forName(clazz);
        }
        catch (ClassNotFoundException exception) {
            LogUtils.error("An unexpected error occurred while finding class {}!", clazz, exception);
            throw new RuntimeException(exception);
        }
    }

    public Field getDeclaredField(String clazz, String field) {
        Class<?> cl = this.getClass(clazz);
        try {
            return cl.getDeclaredField(field);
        }
        catch (NoSuchFieldException exception) {
            LogUtils.error("An unexpected error occurred while getting field {} of class {}!", field, clazz, exception);
            throw new RuntimeException(exception);
        }
    }

    public <T> T newInstance(Class<?> clazz) {
        return null;
    }
}

