/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.placeholders;

import com.artillexstudios.axvaults.libs.axapi.AxPlugin;
import com.artillexstudios.axvaults.libs.axapi.placeholders.Context;
import com.artillexstudios.axvaults.libs.axapi.placeholders.ParseContext;
import com.artillexstudios.axvaults.libs.axapi.placeholders.Placeholders;
import com.artillexstudios.axvaults.libs.axapi.placeholders.ResolutionType;
import com.artillexstudios.axvaults.libs.axapi.utils.logging.LogUtils;
import java.util.List;
import java.util.Locale;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlaceholderAPIHook
extends PlaceholderExpansion {
    private static final AxPlugin plugin = (AxPlugin)AxPlugin.getPlugin(AxPlugin.class);

    public boolean persist() {
        return true;
    }

    @NotNull
    public String getIdentifier() {
        String identifier = (String)PlaceholderAPIHook.plugin.flags().PLACEHOLDER_API_IDENTIFIER.get();
        if (identifier.isBlank()) {
            String pluginName = plugin.getName().toLowerCase(Locale.ENGLISH);
            LogUtils.error("PlaceholderAPI identifier is not set up! Please set it! Defaulting to {}", pluginName);
            return pluginName;
        }
        return identifier;
    }

    @NotNull
    public String getAuthor() {
        return "Artillex-Studios";
    }

    @NotNull
    public String getVersion() {
        return plugin.getDescription().getVersion();
    }

    @Nullable
    public String onPlaceholderRequest(Player player, @NotNull String params) {
        return Placeholders.parse(params, Context.builder(ParseContext.PLACEHOLDER_API, ResolutionType.ONLINE).add(Player.class, player));
    }

    @Nullable
    public String onRequest(OfflinePlayer player, @NotNull String params) {
        return Placeholders.parse(params, Context.builder(ParseContext.PLACEHOLDER_API, ResolutionType.OFFLINE).add(OfflinePlayer.class, player));
    }

    @NotNull
    public List<String> getPlaceholders() {
        return Placeholders.placeholders(ParseContext.PLACEHOLDER_API);
    }
}

