/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.particle;

import com.artillexstudios.axvaults.libs.axapi.AxPlugin;
import com.artillexstudios.axvaults.libs.axapi.packet.FriendlyByteBuf;
import com.artillexstudios.axvaults.libs.axapi.particle.ParticleData;
import com.artillexstudios.axvaults.libs.axapi.particle.ParticleOption;
import com.artillexstudios.axvaults.libs.axapi.particle.ParticleType;
import com.artillexstudios.axvaults.libs.axapi.particle.option.ColorParticleOption;
import com.artillexstudios.axvaults.libs.axapi.particle.option.DustColorTransitionParticleOption;
import com.artillexstudios.axvaults.libs.axapi.particle.option.DustParticleOption;
import com.artillexstudios.axvaults.libs.axapi.particle.option.FloatParticleOption;
import com.artillexstudios.axvaults.libs.axapi.particle.option.IntegerParticleOption;
import com.artillexstudios.axvaults.libs.axapi.particle.option.ItemStackParticleOption;
import com.artillexstudios.axvaults.libs.axapi.particle.option.TrailParticleOption;
import com.artillexstudios.axvaults.libs.axapi.particle.option.VibrationParticleOption;
import com.artillexstudios.axvaults.libs.axapi.particle.type.ColorParticleType;
import com.artillexstudios.axvaults.libs.axapi.particle.type.DustColorTransitionParticleType;
import com.artillexstudios.axvaults.libs.axapi.particle.type.DustParticleType;
import com.artillexstudios.axvaults.libs.axapi.particle.type.FloatParticleType;
import com.artillexstudios.axvaults.libs.axapi.particle.type.IntegerParticleType;
import com.artillexstudios.axvaults.libs.axapi.particle.type.ItemStackParticleType;
import com.artillexstudios.axvaults.libs.axapi.particle.type.SimpleParticleType;
import com.artillexstudios.axvaults.libs.axapi.particle.type.TrailParticleType;
import com.artillexstudios.axvaults.libs.axapi.particle.type.VarIntParticleType;
import com.artillexstudios.axvaults.libs.axapi.particle.type.VibrationParticleType;
import com.artillexstudios.axvaults.libs.axapi.utils.Version;
import com.artillexstudios.axvaults.libs.axapi.utils.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;

public final class ParticleTypes {
    private static final Int2ObjectArrayMap<ParticleType<?>> registry = new Int2ObjectArrayMap();
    private static final Object2IntArrayMap<ParticleType<?>> reverseRegistry = new Object2IntArrayMap();
    private static final ParticleType<?> AMBIENT_ENTITY_EFFECT = new SimpleParticleType();
    private static final ParticleType<?> DRIPPING_CHERRY_LEAVES = new SimpleParticleType();
    private static final ParticleType<?> FALLING_CHERRY_LEAVES = new SimpleParticleType();
    private static final ParticleType<?> LANDING_CHERRY_LEAVES = new SimpleParticleType();
    private static final ParticleType<?> GUST_DUST = new SimpleParticleType();
    private static final ParticleType<?> GUST_EMITTER = new SimpleParticleType();
    private static final ParticleType<?> GUST_EMITTER_SMALL = new SimpleParticleType();
    private static final ParticleType<ColorParticleOption> TINTED_LEAVES = new ColorParticleType();
    public static ParticleType<?> ANGRY_VILLAGER = new SimpleParticleType();
    public static ParticleType<IntegerParticleOption> BLOCK = new VarIntParticleType();
    public static ParticleType<IntegerParticleOption> BLOCK_MARKER = new VarIntParticleType();
    public static ParticleType<?> BUBBLE = new SimpleParticleType();
    public static ParticleType<?> CLOUD = new SimpleParticleType();
    public static ParticleType<?> CRIT = new SimpleParticleType();
    public static ParticleType<?> DAMAGE_INDICATOR = new SimpleParticleType();
    public static ParticleType<?> DRAGON_BREATH = new SimpleParticleType();
    public static ParticleType<?> DRIPPING_LAVA = new SimpleParticleType();
    public static ParticleType<?> FALLING_LAVA = new SimpleParticleType();
    public static ParticleType<?> LANDING_LAVA = new SimpleParticleType();
    public static ParticleType<?> DRIPPING_WATER = new SimpleParticleType();
    public static ParticleType<?> FALLING_WATER = new SimpleParticleType();
    public static ParticleType<DustParticleOption> DUST = new DustParticleType();
    public static ParticleType<DustColorTransitionParticleOption> DUST_COLOR_TRANSITION = new DustColorTransitionParticleType();
    public static ParticleType<?> EFFECT = new SimpleParticleType();
    public static ParticleType<?> ELDER_GUARDIAN = new SimpleParticleType();
    public static ParticleType<?> ENCHANTED_HIT = new SimpleParticleType();
    public static ParticleType<?> ENCHANT = new SimpleParticleType();
    public static ParticleType<?> END_ROD = new SimpleParticleType();
    public static ParticleType<IntegerParticleOption> ENTITY_EFFECT = new IntegerParticleType();
    public static ParticleType<?> EXPLOSION_EMITTER = new SimpleParticleType();
    public static ParticleType<?> EXPLOSION = new SimpleParticleType();
    public static ParticleType<?> GUST = new SimpleParticleType();
    public static ParticleType<?> SMALL_GUST = new SimpleParticleType();
    public static ParticleType<?> GUST_EMITTER_LARGE = new SimpleParticleType();
    public static ParticleType<?> SONIC_BOOM = new SimpleParticleType();
    public static ParticleType<IntegerParticleOption> FALLING_DUST = new VarIntParticleType();
    public static ParticleType<?> FIREWORK = new SimpleParticleType();
    public static ParticleType<?> FISHING = new SimpleParticleType();
    public static ParticleType<?> FLAME = new SimpleParticleType();
    public static ParticleType<?> INFESTED = new SimpleParticleType();
    public static ParticleType<?> CHERRY_LEAVES = new SimpleParticleType();
    public static ParticleType<?> PALE_OAK_LEAVES = new SimpleParticleType();
    public static ParticleType<?> SCULK_SOUL = new SimpleParticleType();
    public static ParticleType<FloatParticleOption> SCULK_CHARGE = new FloatParticleType();
    public static ParticleType<?> SCULK_CHARGE_POP = new SimpleParticleType();
    public static ParticleType<?> SOUL_FIRE_FLAME = new SimpleParticleType();
    public static ParticleType<?> SOUL = new SimpleParticleType();
    public static ParticleType<?> FLASH = new SimpleParticleType();
    public static ParticleType<?> HAPPY_VILLAGER = new SimpleParticleType();
    public static ParticleType<?> COMPOSTER = new SimpleParticleType();
    public static ParticleType<?> HEART = new SimpleParticleType();
    public static ParticleType<?> INSTANT_EFFECT = new SimpleParticleType();
    public static ParticleType<ItemStackParticleOption> ITEM = new ItemStackParticleType();
    public static ParticleType<VibrationParticleOption> VIBRATION = new VibrationParticleType();
    public static ParticleType<TrailParticleOption> TRAIL = new TrailParticleType();
    public static ParticleType<?> ITEM_SLIME = new SimpleParticleType();
    public static ParticleType<?> ITEM_COBWEB = new SimpleParticleType();
    public static ParticleType<?> ITEM_SNOWBALL = new SimpleParticleType();
    public static ParticleType<?> LARGE_SMOKE = new SimpleParticleType();
    public static ParticleType<?> LAVA = new SimpleParticleType();
    public static ParticleType<?> MYCELIUM = new SimpleParticleType();
    public static ParticleType<?> NOTE = new SimpleParticleType();
    public static ParticleType<?> POOF = new SimpleParticleType();
    public static ParticleType<?> PORTAL = new SimpleParticleType();
    public static ParticleType<?> RAIN = new SimpleParticleType();
    public static ParticleType<?> SMOKE = new SimpleParticleType();
    public static ParticleType<?> WHITE_SMOKE = new SimpleParticleType();
    public static ParticleType<?> SNEEZE = new SimpleParticleType();
    public static ParticleType<?> SPIT = new SimpleParticleType();
    public static ParticleType<?> SQUID_INK = new SimpleParticleType();
    public static ParticleType<?> SWEEP_ATTACK = new SimpleParticleType();
    public static ParticleType<?> TOTEM_OF_UNDYING = new SimpleParticleType();
    public static ParticleType<?> UNDERWATER = new SimpleParticleType();
    public static ParticleType<?> SPLASH = new SimpleParticleType();
    public static ParticleType<?> WITCH = new SimpleParticleType();
    public static ParticleType<?> BUBBLE_POP = new SimpleParticleType();
    public static ParticleType<?> CURRENT_DOWN = new SimpleParticleType();
    public static ParticleType<?> BUBBLE_COLUMN_UP = new SimpleParticleType();
    public static ParticleType<?> NAUTILUS = new SimpleParticleType();
    public static ParticleType<?> DOLPHIN = new SimpleParticleType();
    public static ParticleType<?> CAMPFIRE_COSY_SMOKE = new SimpleParticleType();
    public static ParticleType<?> CAMPFIRE_SIGNAL_SMOKE = new SimpleParticleType();
    public static ParticleType<?> DRIPPING_HONEY = new SimpleParticleType();
    public static ParticleType<?> FALLING_HONEY = new SimpleParticleType();
    public static ParticleType<?> LANDING_HONEY = new SimpleParticleType();
    public static ParticleType<?> FALLING_NECTAR = new SimpleParticleType();
    public static ParticleType<?> FALLING_SPORE_BLOSSOM = new SimpleParticleType();
    public static ParticleType<?> ASH = new SimpleParticleType();
    public static ParticleType<?> CRIMSON_SPORE = new SimpleParticleType();
    public static ParticleType<?> WARPED_SPORE = new SimpleParticleType();
    public static ParticleType<?> SPORE_BLOSSOM_AIR = new SimpleParticleType();
    public static ParticleType<?> DRIPPING_OBSIDIAN_TEAR = new SimpleParticleType();
    public static ParticleType<?> FALLING_OBSIDIAN_TEAR = new SimpleParticleType();
    public static ParticleType<?> LANDING_OBSIDIAN_TEAR = new SimpleParticleType();
    public static ParticleType<?> REVERSE_PORTAL = new SimpleParticleType();
    public static ParticleType<?> WHITE_ASH = new SimpleParticleType();
    public static ParticleType<?> SMALL_FLAME = new SimpleParticleType();
    public static ParticleType<?> SNOWFLAKE = new SimpleParticleType();
    public static ParticleType<?> DRIPPING_DRIPSTONE_LAVA = new SimpleParticleType();
    public static ParticleType<?> FALLING_DRIPSTONE_LAVA = new SimpleParticleType();
    public static ParticleType<?> DRIPPING_DRIPSTONE_WATER = new SimpleParticleType();
    public static ParticleType<?> FALLING_DRIPSTONE_WATER = new SimpleParticleType();
    public static ParticleType<?> GLOW_SQUID_INK = new SimpleParticleType();
    public static ParticleType<?> GLOW = new SimpleParticleType();
    public static ParticleType<?> WAX_ON = new SimpleParticleType();
    public static ParticleType<?> WAX_OFF = new SimpleParticleType();
    public static ParticleType<?> ELECTRIC_SPARK = new SimpleParticleType();
    public static ParticleType<?> SCRAPE = new SimpleParticleType();
    public static ParticleType<IntegerParticleOption> SHRIEK = new VarIntParticleType();
    public static ParticleType<?> EGG_CRACK = new SimpleParticleType();
    public static ParticleType<?> DUST_PLUME = new SimpleParticleType();
    public static ParticleType<?> TRIAL_SPAWNER_DETECTION = new SimpleParticleType();
    public static ParticleType<?> TRIAL_SPAWNER_DETECTION_OMINOUS = new SimpleParticleType();
    public static ParticleType<?> VAULT_CONNECTION = new SimpleParticleType();
    public static ParticleType<IntegerParticleOption> DUST_PILLAR = new VarIntParticleType();
    public static ParticleType<?> OMINOUS_SPAWNING = new SimpleParticleType();
    public static ParticleType<?> RAID_OMEN = new SimpleParticleType();
    public static ParticleType<?> TRIAL_OMEN = new SimpleParticleType();
    public static ParticleType<IntegerParticleOption> BLOCK_CRUMBLE = new VarIntParticleType();
    public static ParticleType<IntegerParticleOption> FIREFLY = new VarIntParticleType();

    public static void init() {
        if (Version.getServerVersion().isOlderThan(Version.v1_20_4)) {
            ParticleTypes.register(AMBIENT_ENTITY_EFFECT);
        }
        ParticleTypes.register(ANGRY_VILLAGER);
        ParticleTypes.register(BLOCK);
        ParticleTypes.register(BLOCK_MARKER);
        ParticleTypes.register(BUBBLE);
        ParticleTypes.register(CLOUD);
        ParticleTypes.register(CRIT);
        ParticleTypes.register(DAMAGE_INDICATOR);
        ParticleTypes.register(DRAGON_BREATH);
        ParticleTypes.register(DRIPPING_LAVA);
        ParticleTypes.register(FALLING_LAVA);
        ParticleTypes.register(LANDING_LAVA);
        ParticleTypes.register(DRIPPING_WATER);
        ParticleTypes.register(FALLING_WATER);
        ParticleTypes.register(DUST);
        ParticleTypes.register(DUST_COLOR_TRANSITION);
        ParticleTypes.register(EFFECT);
        ParticleTypes.register(ELDER_GUARDIAN);
        ParticleTypes.register(ENCHANTED_HIT);
        ParticleTypes.register(ENCHANT);
        ParticleTypes.register(END_ROD);
        ParticleTypes.register(ENTITY_EFFECT);
        ParticleTypes.register(EXPLOSION_EMITTER);
        ParticleTypes.register(EXPLOSION);
        if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_20_3)) {
            ParticleTypes.register(GUST);
            if (Version.getServerVersion().isOlderThan(Version.v1_20_4)) {
                ParticleTypes.register(GUST_EMITTER);
            } else {
                ParticleTypes.register(SMALL_GUST);
                ParticleTypes.register(GUST_EMITTER_LARGE);
                ParticleTypes.register(GUST_EMITTER_SMALL);
            }
        }
        if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_19)) {
            ParticleTypes.register(SONIC_BOOM);
        }
        ParticleTypes.register(FALLING_DUST);
        ParticleTypes.register(FIREWORK);
        ParticleTypes.register(FISHING);
        ParticleTypes.register(FLAME);
        if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_20_4)) {
            ParticleTypes.register(INFESTED);
        }
        if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_19_3) && Version.getServerVersion().isOlderThan(Version.v1_20_1)) {
            ParticleTypes.register(DRIPPING_CHERRY_LEAVES);
            ParticleTypes.register(FALLING_CHERRY_LEAVES);
            ParticleTypes.register(LANDING_CHERRY_LEAVES);
        } else if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_20_1)) {
            ParticleTypes.register(CHERRY_LEAVES);
            if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_21_3)) {
                ParticleTypes.register(PALE_OAK_LEAVES);
                if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_21_4)) {
                    ParticleTypes.register(TINTED_LEAVES);
                }
            }
        }
        if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_19)) {
            ParticleTypes.register(SCULK_SOUL);
            ParticleTypes.register(SCULK_CHARGE);
            ParticleTypes.register(SCULK_CHARGE_POP);
        }
        ParticleTypes.register(SOUL_FIRE_FLAME);
        ParticleTypes.register(SOUL);
        ParticleTypes.register(FLASH);
        ParticleTypes.register(HAPPY_VILLAGER);
        ParticleTypes.register(COMPOSTER);
        ParticleTypes.register(HEART);
        ParticleTypes.register(INSTANT_EFFECT);
        ParticleTypes.register(ITEM);
        ParticleTypes.register(VIBRATION);
        if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_21_2)) {
            ParticleTypes.register(TRAIL);
        }
        ParticleTypes.register(ITEM_SLIME);
        if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_20_4)) {
            ParticleTypes.register(ITEM_COBWEB);
        }
        ParticleTypes.register(ITEM_SNOWBALL);
        ParticleTypes.register(LARGE_SMOKE);
        ParticleTypes.register(LAVA);
        ParticleTypes.register(MYCELIUM);
        ParticleTypes.register(NOTE);
        ParticleTypes.register(POOF);
        ParticleTypes.register(PORTAL);
        ParticleTypes.register(RAIN);
        ParticleTypes.register(SMOKE);
        if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_20_3)) {
            ParticleTypes.register(WHITE_SMOKE);
        }
        ParticleTypes.register(SNEEZE);
        ParticleTypes.register(SPIT);
        ParticleTypes.register(SQUID_INK);
        ParticleTypes.register(SWEEP_ATTACK);
        ParticleTypes.register(TOTEM_OF_UNDYING);
        ParticleTypes.register(UNDERWATER);
        ParticleTypes.register(SPLASH);
        ParticleTypes.register(WITCH);
        ParticleTypes.register(BUBBLE_POP);
        ParticleTypes.register(CURRENT_DOWN);
        ParticleTypes.register(BUBBLE_COLUMN_UP);
        ParticleTypes.register(NAUTILUS);
        ParticleTypes.register(DOLPHIN);
        ParticleTypes.register(CAMPFIRE_COSY_SMOKE);
        ParticleTypes.register(CAMPFIRE_SIGNAL_SMOKE);
        ParticleTypes.register(DRIPPING_HONEY);
        ParticleTypes.register(FALLING_HONEY);
        ParticleTypes.register(LANDING_HONEY);
        ParticleTypes.register(FALLING_NECTAR);
        ParticleTypes.register(FALLING_SPORE_BLOSSOM);
        ParticleTypes.register(ASH);
        ParticleTypes.register(CRIMSON_SPORE);
        ParticleTypes.register(WARPED_SPORE);
        ParticleTypes.register(SPORE_BLOSSOM_AIR);
        ParticleTypes.register(DRIPPING_OBSIDIAN_TEAR);
        ParticleTypes.register(FALLING_OBSIDIAN_TEAR);
        ParticleTypes.register(LANDING_OBSIDIAN_TEAR);
        ParticleTypes.register(REVERSE_PORTAL);
        ParticleTypes.register(WHITE_ASH);
        ParticleTypes.register(SMALL_FLAME);
        ParticleTypes.register(SNOWFLAKE);
        ParticleTypes.register(DRIPPING_DRIPSTONE_LAVA);
        ParticleTypes.register(FALLING_DRIPSTONE_LAVA);
        ParticleTypes.register(DRIPPING_DRIPSTONE_WATER);
        ParticleTypes.register(FALLING_DRIPSTONE_WATER);
        ParticleTypes.register(GLOW_SQUID_INK);
        ParticleTypes.register(GLOW);
        ParticleTypes.register(WAX_ON);
        ParticleTypes.register(WAX_OFF);
        ParticleTypes.register(ELECTRIC_SPARK);
        ParticleTypes.register(SCRAPE);
        if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_19)) {
            ParticleTypes.register(SHRIEK);
        }
        if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_20_1)) {
            ParticleTypes.register(EGG_CRACK);
        }
        if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_20_3)) {
            ParticleTypes.register(DUST_PLUME);
            if (Version.getServerVersion().isOlderThan(Version.v1_20_4)) {
                ParticleTypes.register(GUST_DUST);
            }
            ParticleTypes.register(TRIAL_SPAWNER_DETECTION);
            if (Version.getServerVersion().isOlderThan(Version.v1_20_4)) {
                ParticleTypes.register(TRIAL_SPAWNER_DETECTION_OMINOUS);
                ParticleTypes.register(VAULT_CONNECTION);
                ParticleTypes.register(DUST_PILLAR);
                ParticleTypes.register(OMINOUS_SPAWNING);
                ParticleTypes.register(RAID_OMEN);
                ParticleTypes.register(TRIAL_OMEN);
                if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_21_2)) {
                    ParticleTypes.register(BLOCK_CRUMBLE);
                    if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_21_4)) {
                        ParticleTypes.register(FIREFLY);
                    }
                }
            }
        }
    }

    public static <T extends ParticleOption> ParticleData<T> read(FriendlyByteBuf buf) {
        int id = buf.readVarInt();
        ParticleType type = (ParticleType)registry.get(id);
        return new ParticleData(type, (ParticleOption)type.read(buf));
    }

    public static void write(ParticleData<ParticleOption> data, FriendlyByteBuf buf) {
        buf.writeVarInt(reverseRegistry.getInt(data.type()));
        data.type().write(data.option(), buf);
    }

    public static int getId(ParticleType<?> type) {
        return reverseRegistry.getInt(type);
    }

    public static <T extends ParticleOption> ParticleType<T> register(ParticleType<T> type) {
        registry.put(registry.size(), type);
        reverseRegistry.put(type, reverseRegistry.size());
        if (((Boolean)((AxPlugin)AxPlugin.getPlugin(AxPlugin.class)).flags().DEBUG.get()).booleanValue()) {
            LogUtils.debug("Registering particle: {}", type);
        }
        return type;
    }
}

