/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.packet.wrapper.serverbound;

import com.artillexstudios.axvaults.libs.axapi.packet.FriendlyByteBuf;
import com.artillexstudios.axvaults.libs.axapi.packet.PacketEvent;
import com.artillexstudios.axvaults.libs.axapi.packet.PacketType;
import com.artillexstudios.axvaults.libs.axapi.packet.ServerboundPacketTypes;
import com.artillexstudios.axvaults.libs.axapi.packet.wrapper.PacketWrapper;
import com.artillexstudios.axvaults.libs.axapi.utils.BlockPosition;
import com.artillexstudios.axvaults.libs.axapi.utils.ComponentSerializer;
import com.artillexstudios.axvaults.libs.axapi.utils.Version;
import com.artillexstudios.axvaults.libs.kyori.adventure.text.Component;
import java.util.ArrayList;

public final class ServerboundSignUpdateWrapper
extends PacketWrapper {
    private BlockPosition position;
    private boolean frontText;
    private Component[] lines;

    public ServerboundSignUpdateWrapper(PacketEvent event) {
        super(event);
    }

    public BlockPosition position() {
        return this.position;
    }

    public void position(BlockPosition position) {
        this.position = position;
    }

    public boolean frontText() {
        return this.frontText;
    }

    public void frontText(boolean frontText) {
        this.frontText = frontText;
    }

    public Component[] lines() {
        return this.lines;
    }

    public void lines(Component[] lines) {
        this.lines = lines;
    }

    @Override
    public void write(FriendlyByteBuf out) {
        out.writeBlockPos(this.position);
        if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_20_1)) {
            out.writeBoolean(this.frontText);
        }
        for (int i = 0; i < 4; ++i) {
            out.writeUTF(ComponentSerializer.instance().toGson(this.lines[i]));
        }
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.position = buf.readBlockPosition();
        this.frontText = Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_20_1) ? buf.readBoolean() : true;
        ArrayList<String> lines = new ArrayList<String>(4);
        for (int i = 0; i < 4; ++i) {
            lines.add(buf.readUTF(384));
        }
        this.lines = ComponentSerializer.instance().fromGsonList(lines).toArray(new Component[0]);
    }

    @Override
    public PacketType packetType() {
        return ServerboundPacketTypes.SIGN_UPDATE;
    }
}

