/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.packet;

import com.artillexstudios.axvaults.libs.axapi.packet.FriendlyByteBuf;
import com.artillexstudios.axvaults.libs.axapi.packet.PacketEvent;
import com.artillexstudios.axvaults.libs.axapi.packet.PacketListener;
import com.artillexstudios.axvaults.libs.axapi.packet.PacketSide;
import com.artillexstudios.axvaults.libs.axapi.packet.wrapper.PacketWrapper;
import com.artillexstudios.axvaults.libs.axapi.utils.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;

public enum PacketEvents {
    INSTANCE;

    private final ObjectArrayList<PacketListener> listeners = new ObjectArrayList();
    private PacketListener[] baked = new PacketListener[0];
    private boolean listening = false;

    public void addListener(PacketListener listener) {
        this.listeners.add((Object)listener);
        this.listening = true;
        this.baked = (PacketListener[])this.listeners.toArray((Object[])new PacketListener[0]);
    }

    public void callEvent(PacketEvent event) {
        if (!this.listening) {
            return;
        }
        PacketListener[] baked = this.baked;
        PacketWrapper lastWrapper = null;
        int bakedLength = baked.length;
        if (event.side() == PacketSide.SERVER_BOUND) {
            for (int i = 0; i < bakedLength; ++i) {
                PacketWrapper wrapper;
                try {
                    baked[i].onPacketReceive(event);
                }
                catch (Throwable throwable) {
                    LogUtils.error("Exception while running packet event! Buffer: {}", event.in(), throwable);
                    throw new RuntimeException(throwable);
                }
                FriendlyByteBuf directIn = event.directIn();
                if (directIn != null) {
                    directIn.readerIndex(1);
                }
                if ((wrapper = event.wrapper()) == null || lastWrapper == wrapper) continue;
                FriendlyByteBuf out = event.out();
                out.writerIndex(1);
                wrapper.write(out);
                lastWrapper = wrapper;
            }
        } else {
            for (int i = 0; i < bakedLength; ++i) {
                PacketWrapper wrapper;
                try {
                    baked[i].onPacketSending(event);
                }
                catch (Throwable throwable) {
                    LogUtils.error("Exception while running packet event! Buffer: {}", event.in(), throwable);
                    throw new RuntimeException(throwable);
                }
                FriendlyByteBuf directIn = event.directIn();
                if (directIn != null) {
                    directIn.readerIndex(1);
                }
                if ((wrapper = event.wrapper()) == null || lastWrapper == wrapper) continue;
                FriendlyByteBuf out = event.out();
                out.writerIndex(1);
                wrapper.write(out);
                lastWrapper = wrapper;
            }
        }
    }

    public boolean listening() {
        return this.listening;
    }
}

