/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.nms.v1_21_R1.packet;

import com.artillexstudios.axvaults.libs.axapi.nms.v1_21_R1.packet.FriendlyByteBufWrapper;
import com.artillexstudios.axvaults.libs.axapi.nms.v1_21_R1.packet.PacketTransformer;
import com.artillexstudios.axvaults.libs.axapi.packet.ClientboundPacketTypes;
import com.artillexstudios.axvaults.libs.axapi.packet.FriendlyByteBuf;
import com.artillexstudios.axvaults.libs.axapi.packet.PacketEvent;
import com.artillexstudios.axvaults.libs.axapi.packet.PacketEvents;
import com.artillexstudios.axvaults.libs.axapi.packet.PacketSide;
import com.artillexstudios.axvaults.libs.axapi.packet.PacketType;
import com.artillexstudios.axvaults.libs.axapi.packet.ServerboundPacketTypes;
import com.artillexstudios.axvaults.libs.axapi.utils.featureflags.FeatureFlags;
import com.artillexstudios.axvaults.libs.axapi.utils.logging.LogUtils;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.ArrayList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import org.bukkit.entity.Player;

public final class ChannelDuplexHandlerPacketListener
extends ChannelDuplexHandler {
    private final FeatureFlags flags;
    private final Player player;

    public ChannelDuplexHandlerPacketListener(FeatureFlags flags, Player player) {
        this.flags = flags;
        this.player = player;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        FriendlyByteBufWrapper out;
        if (!PacketEvents.INSTANCE.listening()) {
            super.write(ctx, msg, promise);
            return;
        }
        if (msg instanceof ClientboundBundlePacket) {
            ClientboundBundlePacket bundlePacket = (ClientboundBundlePacket)msg;
            if (((Boolean)this.flags.DEBUG_OUTGOING_PACKETS.get()).booleanValue()) {
                LogUtils.info("Bundle packet", new Object[0]);
            }
            ArrayList<Object> packets = new ArrayList<Object>();
            for (Packet subPacket : bundlePacket.b()) {
                FriendlyByteBufWrapper in;
                FriendlyByteBufWrapper out2;
                int packetId = PacketTransformer.packetId(subPacket);
                PacketType type = ClientboundPacketTypes.forPacketId(packetId);
                if (((Boolean)this.flags.DEBUG_OUTGOING_PACKETS.get()).booleanValue()) {
                    LogUtils.info("(bundle) Packet id: {}, class: {}, type: {}", packetId, subPacket.getClass(), type);
                }
                PacketEvent event = new PacketEvent(this.player, PacketSide.CLIENT_BOUND, type, () -> PacketTransformer.transformClientbound(ctx, subPacket, FriendlyByteBuf::readVarInt), () -> PacketTransformer.newByteBuf(ctx, buf -> buf.writeVarInt(packetId)));
                PacketEvents.INSTANCE.callEvent(event);
                if (event.cancelled()) {
                    out2 = (FriendlyByteBufWrapper)event.directOut();
                    if (out2 != null) {
                        out2.buf().release();
                    }
                    if ((in = (FriendlyByteBufWrapper)event.directIn()) == null) continue;
                    in.buf().release();
                    continue;
                }
                out2 = (FriendlyByteBufWrapper)event.directOut();
                in = (FriendlyByteBufWrapper)event.directIn();
                if (in != null) {
                    in.buf().release();
                }
                if (out2 == null) {
                    packets.add(subPacket);
                    continue;
                }
                packets.add(PacketTransformer.transformClientbound((PacketDataSerializer)out2.buf()));
            }
            super.write(ctx, (Object)new ClientboundBundlePacket(packets), promise);
            return;
        }
        int packetId = PacketTransformer.packetId(msg);
        PacketType type = ClientboundPacketTypes.forPacketId(packetId);
        if (((Boolean)this.flags.DEBUG_OUTGOING_PACKETS.get()).booleanValue()) {
            LogUtils.info("Packet id: {}, class: {}, type: {}", packetId, msg.getClass(), type);
        }
        PacketEvent event = new PacketEvent(this.player, PacketSide.CLIENT_BOUND, type, () -> PacketTransformer.transformClientbound(ctx, msg, FriendlyByteBuf::readVarInt), () -> PacketTransformer.newByteBuf(ctx, buf -> buf.writeVarInt(packetId)));
        PacketEvents.INSTANCE.callEvent(event);
        if (event.cancelled()) {
            FriendlyByteBufWrapper in;
            FriendlyByteBufWrapper out3;
            if (((Boolean)this.flags.DEBUG_OUTGOING_PACKETS.get()).booleanValue()) {
                LogUtils.info("Cancelled event!", new Object[0]);
            }
            if ((out3 = (FriendlyByteBufWrapper)event.directOut()) != null) {
                out3.buf().release();
            }
            if ((in = (FriendlyByteBufWrapper)event.directIn()) != null) {
                in.buf().release();
            }
            return;
        }
        FriendlyByteBufWrapper in = (FriendlyByteBufWrapper)event.directIn();
        if (in != null) {
            in.buf().release();
        }
        if ((out = (FriendlyByteBufWrapper)event.directOut()) == null) {
            if (((Boolean)this.flags.DEBUG_OUTGOING_PACKETS.get()).booleanValue()) {
                LogUtils.info("Unchanged!", new Object[0]);
            }
            super.write(ctx, msg, promise);
            return;
        }
        if (((Boolean)this.flags.DEBUG_OUTGOING_PACKETS.get()).booleanValue()) {
            LogUtils.info("Changed!", new Object[0]);
        }
        super.write(ctx, PacketTransformer.transformClientbound((PacketDataSerializer)out.buf()), promise);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        FriendlyByteBufWrapper out;
        if (!PacketEvents.INSTANCE.listening()) {
            super.channelRead(ctx, msg);
            return;
        }
        if (msg instanceof ServerboundCustomPayloadPacket) {
            ServerboundCustomPayloadPacket serverboundCustomPayloadPacket = (ServerboundCustomPayloadPacket)msg;
            try {
                CustomPacketPayload customPacketPayload;
                CustomPacketPayload payload = customPacketPayload = serverboundCustomPayloadPacket.b();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            super.channelRead(ctx, msg);
            return;
        }
        int packetId = PacketTransformer.packetId(msg);
        PacketType type = ServerboundPacketTypes.forPacketId(packetId);
        if (((Boolean)this.flags.DEBUG_INCOMING_PACKETS.get()).booleanValue()) {
            LogUtils.info("Incoming packet id: {}, class: {}, type: {}", packetId, msg.getClass(), type);
        }
        PacketEvent event = new PacketEvent(this.player, PacketSide.SERVER_BOUND, type, () -> PacketTransformer.transformServerbound(ctx, msg, FriendlyByteBuf::readVarInt), () -> PacketTransformer.newByteBuf(ctx, buf -> buf.writeVarInt(packetId)));
        PacketEvents.INSTANCE.callEvent(event);
        if (event.cancelled()) {
            FriendlyByteBufWrapper out2;
            FriendlyByteBufWrapper in;
            if (((Boolean)this.flags.DEBUG_INCOMING_PACKETS.get()).booleanValue()) {
                LogUtils.info("Incoming cancelled event!", new Object[0]);
            }
            if ((in = (FriendlyByteBufWrapper)event.directIn()) != null) {
                in.buf().release();
            }
            if ((out2 = (FriendlyByteBufWrapper)event.directOut()) == null) return;
            out2.buf().release();
            return;
        }
        FriendlyByteBufWrapper in = (FriendlyByteBufWrapper)event.directIn();
        if (in != null) {
            in.buf().release();
        }
        if ((out = (FriendlyByteBufWrapper)event.directOut()) == null) {
            if (((Boolean)this.flags.DEBUG_INCOMING_PACKETS.get()).booleanValue()) {
                LogUtils.info("Incoming unchanged!", new Object[0]);
            }
            super.channelRead(ctx, msg);
            return;
        }
        if (((Boolean)this.flags.DEBUG_INCOMING_PACKETS.get()).booleanValue()) {
            LogUtils.info("Incoming changed!", new Object[0]);
        }
        super.channelRead(ctx, PacketTransformer.transformServerbound((PacketDataSerializer)out.buf()));
    }
}

