/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.nms.v1_20_R3.wrapper;

import com.artillexstudios.axvaults.libs.axapi.AxPlugin;
import com.artillexstudios.axvaults.libs.axapi.nms.v1_20_R3.packet.ChannelDuplexHandlerPacketListener;
import com.artillexstudios.axvaults.libs.axapi.nms.v1_20_R3.packet.PacketTransformer;
import com.artillexstudios.axvaults.libs.axapi.packet.wrapper.PacketWrapper;
import com.artillexstudios.axvaults.libs.axapi.reflection.FieldAccessor;
import com.artillexstudios.axvaults.libs.axapi.utils.ComponentSerializer;
import com.artillexstudios.axvaults.libs.axapi.utils.PlayerTextures;
import com.artillexstudios.axvaults.libs.axapi.utils.logging.LogUtils;
import com.artillexstudios.axvaults.libs.kyori.adventure.text.Component;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import org.bukkit.attribute.Attribute;
import org.bukkit.craftbukkit.v1_20_R3.attribute.CraftAttribute;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;

public final class ServerPlayerWrapper
implements com.artillexstudios.axvaults.libs.axapi.nms.wrapper.ServerPlayerWrapper {
    private static final FieldAccessor connectionAccessor = FieldAccessor.builder().withClass("net.minecraft.server.network.ServerCommonPacketListenerImpl").withField("c").build();
    private static final FieldAccessor channelAccessor = FieldAccessor.builder().withClass("net.minecraft.network.NetworkManager").withField("n").build();
    private static final FieldAccessor attributeAccessor = FieldAccessor.builder().withClass(AttributeMapBase.class).withField("d").build();
    private Player wrapped;
    private EntityPlayer serverPlayer;

    public ServerPlayerWrapper(Player player) {
        this.wrapped = player;
    }

    public ServerPlayerWrapper(EntityPlayer player) {
        this.serverPlayer = player;
    }

    @Override
    public void inject() {
        this.update();
        NetworkManager connection = connectionAccessor.get(this.serverPlayer.c, NetworkManager.class);
        Channel channel = channelAccessor.get(connection, Channel.class);
        if (!channel.pipeline().names().contains("packet_handler")) {
            return;
        }
        if (channel.pipeline().names().contains(AXAPI_HANDLER)) {
            return;
        }
        channel.eventLoop().submit(() -> channel.pipeline().addBefore("packet_handler", AXAPI_HANDLER, (ChannelHandler)new ChannelDuplexHandlerPacketListener(((AxPlugin)AxPlugin.getPlugin(AxPlugin.class)).flags(), this.wrapped())));
    }

    @Override
    public void uninject() {
        this.update();
        NetworkManager connection = connectionAccessor.get(this.serverPlayer.c, NetworkManager.class);
        Channel channel = channelAccessor.get(connection, Channel.class);
        channel.eventLoop().submit(() -> {
            if (channel.pipeline().get(AXAPI_HANDLER) != null) {
                channel.pipeline().remove(AXAPI_HANDLER);
            }
        });
    }

    @Override
    public void sendPacket(Object packet) {
        this.update();
        if (packet instanceof PacketWrapper) {
            PacketWrapper wrapper = (PacketWrapper)packet;
            this.serverPlayer.c.b(PacketTransformer.transformClientbound(wrapper));
            return;
        }
        if (!(packet instanceof Packet)) {
            LogUtils.warn("Failed to send unknown packet to player {}! Packet: {}", this.wrapped().getName(), packet);
            return;
        }
        Packet p = (Packet)packet;
        this.serverPlayer.c.b(p);
    }

    @Override
    public void message(Component message) {
        this.update();
        this.serverPlayer.c.b((Packet)new ClientboundSystemChatPacket((IChatBaseComponent)ComponentSerializer.instance().toVanilla(message), false));
    }

    @Override
    public double getBase(Attribute attribute) {
        this.update();
        AttributeMapBase map = this.serverPlayer.eR();
        AttributeProvider supplier = attributeAccessor.get(map, AttributeProvider.class);
        return supplier.b(CraftAttribute.bukkitToMinecraft((Attribute)attribute));
    }

    @Override
    public PlayerTextures textures() {
        this.update();
        GameProfile profile = this.serverPlayer.fR();
        Optional property = profile.getProperties().get((Object)"textures").stream().findFirst();
        if (property.isEmpty()) {
            return new PlayerTextures(null, null);
        }
        Property value = (Property)property.get();
        return new PlayerTextures(value.value(), value.signature());
    }

    @Override
    public double getX() {
        this.update();
        return this.serverPlayer.dr();
    }

    @Override
    public double getZ() {
        this.update();
        return this.serverPlayer.dx();
    }

    @Override
    public Player wrapped() {
        Player wrapped = this.wrapped;
        if (wrapped == null) {
            this.wrapped = wrapped = this.serverPlayer.getBukkitEntity();
        }
        return wrapped;
    }

    @Override
    public void update(boolean force) {
        if (this.serverPlayer == null || force) {
            this.serverPlayer = ((CraftPlayer)this.wrapped).getHandle();
        }
    }

    public EntityPlayer asMinecraft() {
        this.update();
        return this.serverPlayer;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ServerPlayerWrapper)) {
            return false;
        }
        ServerPlayerWrapper that = (ServerPlayerWrapper)o;
        this.update();
        that.update();
        if (Objects.equals(this.serverPlayer, that.serverPlayer)) {
            return true;
        }
        return this.wrapped().getUniqueId().equals(that.wrapped().getUniqueId());
    }

    public int hashCode() {
        this.update();
        return Objects.hashCode(this.serverPlayer);
    }
}

