/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.metrics.collectors.implementation;

import com.artillexstudios.axvaults.libs.axapi.metrics.collectors.MetricsCollector;
import com.artillexstudios.axvaults.libs.axapi.utils.logging.LogUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public final class MinecraftVersionMetricsCollector
implements MetricsCollector {
    private static final Pattern pattern = Pattern.compile("MC: (\\d+\\.\\d+(\\.\\d+)?)");
    private final String version;

    public MinecraftVersionMetricsCollector() {
        Matcher matcher = pattern.matcher(Bukkit.getVersion());
        if (!matcher.find()) {
            LogUtils.error("Failed to get version from Bukkit.getVersion(), didn't match pattern! Was: {}", Bukkit.getVersion());
            throw new UnsupportedOperationException();
        }
        this.version = matcher.group(1);
    }

    @Override
    public void collect(JsonArray data) {
        JsonObject object = new JsonObject();
        object.addProperty("@type", "minecraft-version");
        object.addProperty("minecraft-version", this.version);
        data.add(object);
    }
}

