/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.items;

import com.artillexstudios.axvaults.libs.axapi.items.PacketItemModifierListener;
import com.artillexstudios.axvaults.libs.axapi.items.WrappedItemStack;
import com.artillexstudios.axvaults.libs.axapi.packet.ClientboundPacketTypes;
import com.artillexstudios.axvaults.libs.axapi.packet.PacketEvent;
import com.artillexstudios.axvaults.libs.axapi.packet.PacketEvents;
import com.artillexstudios.axvaults.libs.axapi.packet.PacketListener;
import com.artillexstudios.axvaults.libs.axapi.packet.ServerboundPacketTypes;
import com.artillexstudios.axvaults.libs.axapi.packet.wrapper.clientbound.ClientboundContainerSetContentWrapper;
import com.artillexstudios.axvaults.libs.axapi.packet.wrapper.clientbound.ClientboundContainerSetSlotWrapper;
import com.artillexstudios.axvaults.libs.axapi.packet.wrapper.clientbound.ClientboundEntityMetadataWrapper;
import com.artillexstudios.axvaults.libs.axapi.packet.wrapper.clientbound.ClientboundMerchantOffersWrapper;
import com.artillexstudios.axvaults.libs.axapi.packet.wrapper.clientbound.ClientboundSetEquipmentWrapper;
import com.artillexstudios.axvaults.libs.axapi.packet.wrapper.serverbound.ServerboundSetCreativeModeSlotWrapper;
import com.artillexstudios.axvaults.libs.axapi.packetentity.meta.Metadata;
import com.artillexstudios.axvaults.libs.axapi.utils.EquipmentSlot;
import com.artillexstudios.axvaults.libs.axapi.utils.MerchantOffer;
import com.artillexstudios.axvaults.libs.axapi.utils.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.bukkit.entity.Player;

public class PacketItemModifier {
    private static boolean listening = false;
    private static final ObjectArrayList<PacketItemModifierListener> listeners = new ObjectArrayList();

    public static void registerModifierListener(PacketItemModifierListener listener) {
        if (!listening) {
            PacketEvents.INSTANCE.addListener(new PacketListener(){

                @Override
                public void onPacketSending(PacketEvent event) {
                    block6: {
                        block9: {
                            block8: {
                                block7: {
                                    block5: {
                                        if (!PacketItemModifier.isListening()) {
                                            return;
                                        }
                                        if (event.type() != ClientboundPacketTypes.CONTAINER_SET_SLOT) break block5;
                                        ClientboundContainerSetSlotWrapper wrapper = new ClientboundContainerSetSlotWrapper(event);
                                        PacketItemModifier.callModify(wrapper.stack(), event.player(), Context.SET_SLOT);
                                        break block6;
                                    }
                                    if (event.type() != ClientboundPacketTypes.CONTAINER_CONTENT) break block7;
                                    ClientboundContainerSetContentWrapper wrapper = new ClientboundContainerSetContentWrapper(event);
                                    for (WrappedItemStack item : wrapper.items()) {
                                        PacketItemModifier.callModify(item, event.player(), Context.SET_CONTENTS);
                                    }
                                    PacketItemModifier.callModify(wrapper.carriedItem(), event.player(), Context.SET_CONTENTS);
                                    break block6;
                                }
                                if (event.type() != ClientboundPacketTypes.SET_EQUIPMENT) break block8;
                                ClientboundSetEquipmentWrapper wrapper = new ClientboundSetEquipmentWrapper(event);
                                for (Pair<EquipmentSlot, WrappedItemStack> item : wrapper.items()) {
                                    PacketItemModifier.callModify(item.second(), event.player(), Context.EQUIPMENT);
                                }
                                break block6;
                            }
                            if (event.type() != ClientboundPacketTypes.MERCHANT_OFFERS) break block9;
                            ClientboundMerchantOffersWrapper wrapper = new ClientboundMerchantOffersWrapper(event);
                            for (MerchantOffer offer : wrapper.merchantOffers()) {
                                PacketItemModifier.callModify(offer.item1(), event.player(), Context.MERCHANT_OFFER);
                                offer.item2().ifPresent(cost -> PacketItemModifier.callModify(cost, event.player(), Context.MERCHANT_OFFER));
                                PacketItemModifier.callModify(offer.output(), event.player(), Context.MERCHANT_OFFER);
                            }
                            break block6;
                        }
                        if (event.type() != ClientboundPacketTypes.SET_ENTITY_DATA) break block6;
                        ClientboundEntityMetadataWrapper wrapper = new ClientboundEntityMetadataWrapper(event);
                        for (Metadata.DataItem<?> item : wrapper.items()) {
                            Object obj = item.getValue();
                            if (!(obj instanceof WrappedItemStack)) continue;
                            WrappedItemStack stack = (WrappedItemStack)obj;
                            PacketItemModifier.callModify(stack, event.player(), Context.DROPPED_ITEM);
                        }
                    }
                }

                @Override
                public void onPacketReceive(PacketEvent event) {
                    if (event.type() == ServerboundPacketTypes.SET_CREATIVE_MODE_SLOT) {
                        ServerboundSetCreativeModeSlotWrapper wrapper = new ServerboundSetCreativeModeSlotWrapper(event);
                        PacketItemModifier.restore(wrapper.stack());
                    }
                }
            });
        }
        if (!listeners.contains((Object)listener)) {
            listeners.add((Object)listener);
            listening = true;
        }
    }

    public static void unregister(PacketItemModifierListener listener) {
        listeners.remove((Object)listener);
        if (listeners.isEmpty()) {
            listening = false;
        }
    }

    public static boolean isListening() {
        return listening;
    }

    public static void callModify(WrappedItemStack itemStack, Player player, Context context) {
        for (PacketItemModifierListener listener : listeners) {
            listener.modifyItemStack(player, itemStack, context);
        }
    }

    public static void restore(WrappedItemStack itemStack) {
        for (PacketItemModifierListener listener : listeners) {
            listener.restore(itemStack);
        }
    }

    public static enum Context {
        SET_SLOT,
        SET_CONTENTS,
        EQUIPMENT,
        DROPPED_ITEM,
        MERCHANT_OFFER;

    }
}

