/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.hologram;

import com.artillexstudios.axvaults.libs.axapi.AxPlugin;
import com.artillexstudios.axvaults.libs.axapi.executor.ExceptionReportingScheduledThreadPool;
import com.artillexstudios.axvaults.libs.axapi.hologram.HologramLine;
import com.artillexstudios.axvaults.libs.axapi.utils.logging.LogUtils;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class Holograms {
    private static final AxPlugin plugin = (AxPlugin)AxPlugin.getPlugin(AxPlugin.class);
    private static final ConcurrentHashMap<Integer, HologramLine> linesMap = new ConcurrentHashMap();
    private static ScheduledExecutorService hologramUpdater;

    public static void startTicking() {
        Holograms.shutdown();
        hologramUpdater = new ExceptionReportingScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat(plugin.getName() + "-Hologram-Update-Thread").build());
        hologramUpdater.scheduleAtFixedRate(() -> Holograms.getMap(map -> map.forEach((id, line) -> {
            if (!line.hasPlaceholders()) {
                return;
            }
            line.update();
        })), 0L, (Long)Holograms.plugin.flags().HOLOGRAM_UPDATE_TICKS.get() * 50L, TimeUnit.MILLISECONDS);
    }

    public static void shutdown() {
        if (hologramUpdater != null) {
            hologramUpdater.shutdown();
            try {
                hologramUpdater.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException exception) {
                LogUtils.error("An unexpected error occurred while disabling hologram ticker!", exception);
            }
        }
    }

    public static void put(int entityId, HologramLine line) {
        linesMap.put(entityId, line);
    }

    public static void remove(int entityId) {
        linesMap.remove(entityId);
    }

    public static HologramLine byId(int entityId) {
        return linesMap.get(entityId);
    }

    public static void getMap(Consumer<ConcurrentHashMap<Integer, HologramLine>> map) {
        map.accept(linesMap);
    }
}

