/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi.hologram;

import com.artillexstudios.axvaults.libs.axapi.AxPlugin;
import com.artillexstudios.axvaults.libs.axapi.collections.ThreadSafeList;
import com.artillexstudios.axvaults.libs.axapi.events.PacketEntityInteractEvent;
import com.artillexstudios.axvaults.libs.axapi.hologram.Hologram;
import com.artillexstudios.axvaults.libs.axapi.hologram.HologramPage;
import com.artillexstudios.axvaults.libs.axapi.hologram.Holograms;
import com.artillexstudios.axvaults.libs.axapi.items.WrappedItemStack;
import com.artillexstudios.axvaults.libs.axapi.nms.NMSHandlers;
import com.artillexstudios.axvaults.libs.axapi.packetentity.PacketEntity;
import com.artillexstudios.axvaults.libs.axapi.packetentity.meta.EntityMeta;
import com.artillexstudios.axvaults.libs.axapi.packetentity.meta.entity.ArmorStandMeta;
import com.artillexstudios.axvaults.libs.axapi.packetentity.meta.entity.ItemEntityMeta;
import com.artillexstudios.axvaults.libs.axapi.utils.EquipmentSlot;
import com.artillexstudios.axvaults.libs.axapi.utils.StringUtils;
import com.artillexstudios.axvaults.libs.axapi.utils.placeholder.Placeholder;
import com.artillexstudios.axvaults.libs.axapi.utils.placeholder.StaticPlaceholder;
import com.artillexstudios.axvaults.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class HologramLine {
    private static final AxPlugin plugin = (AxPlugin)AxPlugin.getPlugin(AxPlugin.class);
    private final Type type;
    private final ThreadSafeList<Placeholder> placeholders = new ThreadSafeList();
    private final HologramPage page;
    private Consumer<PacketEntityInteractEvent> event;
    private volatile PacketEntity packetEntity = null;
    private volatile boolean hasPlaceholders = false;
    private String content;
    private Location location;

    public HologramLine(HologramPage page, Location location, String content, Type type, List<Placeholder> placeholders) {
        this.page = page;
        this.location = location;
        this.type = type;
        this.placeholders.addAll(placeholders);
        this.event(page.event());
        this.setContent(content);
    }

    public void remove() {
        Holograms.remove(this.packetEntity.id());
        this.packetEntity.remove();
    }

    public void addPlaceholder(Placeholder placeholder) {
        this.placeholders.add(placeholder);
        this.setContent(this.content);
    }

    public boolean hasPlaceholders() {
        return this.hasPlaceholders;
    }

    public void setContent(String content) {
        this.content = content;
        if (this.packetEntity != null) {
            switch (this.type.ordinal()) {
                case 1: {
                    ItemEntityMeta meta = (ItemEntityMeta)this.packetEntity.meta();
                    meta.itemStack(WrappedItemStack.wrap(content));
                    break;
                }
                case 2: 
                case 3: {
                    this.packetEntity.setItem(EquipmentSlot.HELMET, WrappedItemStack.wrap(content));
                    break;
                }
                case 0: {
                    this.hasPlaceholders = false;
                    EntityMeta meta = this.packetEntity.meta();
                    if (!content.isEmpty()) {
                        for (int i = 0; i < this.placeholders.size(); ++i) {
                            Placeholder placeholder = this.placeholders.get(i);
                            if (!(placeholder instanceof StaticPlaceholder)) continue;
                            content = placeholder.parse(null, content);
                        }
                        for (Pattern pattern : (List)HologramLine.plugin.flags().PLACEHOLDER_PATTERNS.get()) {
                            Matcher matcher = pattern.matcher(content);
                            if (!matcher.find()) continue;
                            this.hasPlaceholders = true;
                            break;
                        }
                        meta.customNameVisible(true);
                        meta.name(StringUtils.format(content, new TagResolver[0]));
                        break;
                    }
                    meta.name(null);
                    meta.customNameVisible(false);
                    break;
                }
                case 4: {
                    Holograms.remove(this.packetEntity.id());
                    this.packetEntity.remove();
                    this.packetEntity = NMSHandlers.getNmsHandler().createEntity(EntityType.valueOf((String)content.toUpperCase(Locale.ENGLISH)), this.location);
                    this.setup();
                    this.packetEntity.spawn();
                    break;
                }
            }
            return;
        }
        switch (this.type.ordinal()) {
            case 1: {
                this.packetEntity = NMSHandlers.getNmsHandler().createEntity(EntityType.DROPPED_ITEM, this.location);
                ItemEntityMeta meta = (ItemEntityMeta)this.packetEntity.meta();
                meta.itemStack(WrappedItemStack.wrap(content));
                meta.hasNoGravity(true);
                this.setup();
                this.packetEntity.spawn();
                break;
            }
            case 2: {
                this.packetEntity = NMSHandlers.getNmsHandler().createEntity(EntityType.ARMOR_STAND, this.location);
                this.packetEntity.setItem(EquipmentSlot.HELMET, WrappedItemStack.wrap(this.content));
                EntityMeta meta = this.packetEntity.meta();
                meta.invisible(true);
                this.setup();
                this.packetEntity.spawn();
                break;
            }
            case 0: {
                this.packetEntity = NMSHandlers.getNmsHandler().createEntity(EntityType.ARMOR_STAND, this.location);
                AtomicReference<String> reference = new AtomicReference<String>(content);
                ArmorStandMeta meta = (ArmorStandMeta)this.packetEntity.meta();
                this.hasPlaceholders = false;
                if (!this.content.isEmpty()) {
                    for (int i = 0; i < this.placeholders.size(); ++i) {
                        Placeholder placeholder = this.placeholders.get(i);
                        if (!(placeholder instanceof StaticPlaceholder)) continue;
                        reference.set(placeholder.parse(null, reference.get()));
                    }
                    for (Pattern pattern : (List)HologramLine.plugin.flags().PLACEHOLDER_PATTERNS.get()) {
                        Matcher matcher = pattern.matcher(reference.get());
                        if (!matcher.find()) continue;
                        this.hasPlaceholders = true;
                        break;
                    }
                    meta.customNameVisible(true);
                    meta.name(StringUtils.format(reference.get(), new TagResolver[0]));
                } else {
                    meta.customNameVisible(false);
                    meta.name(null);
                }
                meta.marker(true);
                meta.invisible(true);
                this.setup();
                this.packetEntity.spawn();
                break;
            }
            case 4: {
                this.packetEntity = NMSHandlers.getNmsHandler().createEntity(EntityType.valueOf((String)content.toUpperCase(Locale.ENGLISH)), this.location);
                this.setup();
                this.packetEntity.spawn();
                break;
            }
            case 3: {
                this.packetEntity = NMSHandlers.getNmsHandler().createEntity(EntityType.ARMOR_STAND, this.location);
                ArmorStandMeta meta = (ArmorStandMeta)this.packetEntity.meta();
                this.packetEntity.setItem(EquipmentSlot.HELMET, WrappedItemStack.wrap(this.content));
                meta.invisible(true);
                meta.small(true);
                this.setup();
                this.packetEntity.spawn();
                break;
            }
        }
        Holograms.put(this.packetEntity.id(), this);
    }

    public void event(Consumer<PacketEntityInteractEvent> event) {
        this.event = event;
    }

    public Consumer<PacketEntityInteractEvent> event() {
        return this.event;
    }

    private void setup() {
        this.packetEntity.onInteract(event -> {
            if (this.event != null) {
                this.event.accept((PacketEntityInteractEvent)((Object)event));
            }
            this.page.hologram().changePage(event.getPlayer(), event.isAttack() ? Hologram.PageChangeDirection.BACK : Hologram.PageChangeDirection.FORWARD);
        });
        if (!this.page.isFirstPage()) {
            this.packetEntity.setVisibleByDefault(false);
        }
    }

    public void teleport(Location location) {
        this.location = location;
        this.packetEntity.teleport(location);
    }

    public void hide(Player player) {
        this.packetEntity.hide(player);
    }

    public void show(Player player) {
        this.packetEntity.show(player);
    }

    public Type type() {
        return this.type;
    }

    public void update() {
        this.packetEntity.update();
    }

    public ThreadSafeList<Placeholder> placeholders() {
        return this.placeholders;
    }

    public String content() {
        return this.content;
    }

    public static enum Type {
        TEXT,
        ITEM_STACK,
        HEAD,
        SMALL_HEAD,
        ENTITY,
        UNKNOWN,
        TEXT_DISPLAY;

    }
}

