/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.axapi;

import com.artillexstudios.axvaults.libs.axapi.dependencies.DependencyManagerWrapper;
import com.artillexstudios.axvaults.libs.axapi.events.PacketEntityInteractEvent;
import com.artillexstudios.axvaults.libs.axapi.gui.AnvilListener;
import com.artillexstudios.axvaults.libs.axapi.gui.SignInput;
import com.artillexstudios.axvaults.libs.axapi.hologram.Holograms;
import com.artillexstudios.axvaults.libs.axapi.items.component.DataComponents;
import com.artillexstudios.axvaults.libs.axapi.nms.NMSHandlers;
import com.artillexstudios.axvaults.libs.axapi.nms.wrapper.ServerPlayerWrapper;
import com.artillexstudios.axvaults.libs.axapi.packet.ClientboundPacketTypes;
import com.artillexstudios.axvaults.libs.axapi.packet.PacketEvent;
import com.artillexstudios.axvaults.libs.axapi.packet.PacketEvents;
import com.artillexstudios.axvaults.libs.axapi.packet.PacketListener;
import com.artillexstudios.axvaults.libs.axapi.packet.ServerboundPacketTypes;
import com.artillexstudios.axvaults.libs.axapi.packet.wrapper.clientbound.ClientboundBlockUpdateWrapper;
import com.artillexstudios.axvaults.libs.axapi.packet.wrapper.serverbound.ServerboundInteractWrapper;
import com.artillexstudios.axvaults.libs.axapi.packet.wrapper.serverbound.ServerboundSignUpdateWrapper;
import com.artillexstudios.axvaults.libs.axapi.packetentity.PacketEntity;
import com.artillexstudios.axvaults.libs.axapi.packetentity.tracker.EntityTracker;
import com.artillexstudios.axvaults.libs.axapi.particle.ParticleTypes;
import com.artillexstudios.axvaults.libs.axapi.placeholders.PlaceholderAPIHook;
import com.artillexstudios.axvaults.libs.axapi.placeholders.Placeholders;
import com.artillexstudios.axvaults.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axvaults.libs.axapi.utils.ComponentSerializer;
import com.artillexstudios.axvaults.libs.axapi.utils.Vector3f;
import com.artillexstudios.axvaults.libs.axapi.utils.featureflags.FeatureFlags;
import java.io.File;
import java.net.URLClassLoader;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import revxrsal.zapper.DependencyManager;
import revxrsal.zapper.classloader.URLClassLoaderWrapper;

public abstract class AxPlugin
extends JavaPlugin {
    public EntityTracker tracker;
    private final FeatureFlags flags = new FeatureFlags(this);
    private ComponentSerializer serializer;

    public AxPlugin() {
        DependencyManager manager = new DependencyManager(this.getDescription(), new File(this.getDataFolder(), "libs"), URLClassLoaderWrapper.wrap((URLClassLoader)this.getClassLoader()));
        DependencyManagerWrapper wrapper = new DependencyManagerWrapper(manager);
        wrapper.dependency("org{}apache{}commons:commons-math3:3.6.1");
        wrapper.dependency("com{}github{}ben-manes{}caffeine:caffeine:3.1.8");
        wrapper.relocate("org{}apache{}commons{}math3", "com.artillexstudios.axvaults.libs.axapi.libs.math3");
        wrapper.relocate("com{}github{}benmanes", "com.artillexstudios.axvaults.libs.axapi.libs.caffeine");
        this.dependencies(wrapper);
        manager.load();
        this.updateFlags(this.flags);
    }

    public void updateFlags(FeatureFlags flags) {
    }

    public void onEnable() {
        if (!NMSHandlers.British.initialise(this)) {
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        DataComponents.setDataComponentImpl(NMSHandlers.getNmsHandler().dataComponents());
        Scheduler.scheduler.init(this);
        this.serializer = new ComponentSerializer(this);
        if (((Boolean)this.flags.PACKET_ENTITY_TRACKER_ENABLED.get()).booleanValue()) {
            this.tracker = new EntityTracker(this.flags);
            this.tracker.startTicking();
        }
        PacketEvents.INSTANCE.addListener(new PacketListener(){

            @Override
            public void onPacketReceive(PacketEvent event) {
                if (event.type() == ServerboundPacketTypes.INTERACT) {
                    if (AxPlugin.this.tracker == null) {
                        return;
                    }
                    ServerboundInteractWrapper wrapper = new ServerboundInteractWrapper(event);
                    PacketEntity entity = AxPlugin.this.tracker.getById(wrapper.entityId());
                    if (entity != null) {
                        ServerboundInteractWrapper.InteractionHand interactionHand;
                        Vector3f vector3f;
                        Player player = event.player();
                        boolean bl = wrapper.type() == ServerboundInteractWrapper.ActionType.ATTACK;
                        ServerboundInteractWrapper.Action action = wrapper.action();
                        if (action instanceof ServerboundInteractWrapper.InteractionAtLocationAction) {
                            ServerboundInteractWrapper.InteractionAtLocationAction action2 = (ServerboundInteractWrapper.InteractionAtLocationAction)action;
                            vector3f = action2.location();
                        } else {
                            vector3f = null;
                        }
                        ServerboundInteractWrapper.Action action3 = wrapper.action();
                        if (action3 instanceof ServerboundInteractWrapper.InteractionAction) {
                            ServerboundInteractWrapper.InteractionAction action4 = (ServerboundInteractWrapper.InteractionAction)action3;
                            interactionHand = action4.hand();
                        } else {
                            action3 = wrapper.action();
                            if (action3 instanceof ServerboundInteractWrapper.InteractionAtLocationAction) {
                                ServerboundInteractWrapper.InteractionAtLocationAction interaction = (ServerboundInteractWrapper.InteractionAtLocationAction)action3;
                                interactionHand = interaction.hand();
                            } else {
                                interactionHand = null;
                            }
                        }
                        PacketEntityInteractEvent interactEvent = new PacketEntityInteractEvent(player, entity, bl, vector3f, interactionHand);
                        Bukkit.getPluginManager().callEvent((Event)interactEvent);
                    }
                } else if (event.type() == ServerboundPacketTypes.SIGN_UPDATE) {
                    SignInput signInput = SignInput.remove(event.player());
                    if (signInput == null) {
                        return;
                    }
                    ServerboundSignUpdateWrapper wrapper = new ServerboundSignUpdateWrapper(event);
                    signInput.getListener().accept(event.player(), wrapper.lines());
                    Scheduler.get().runAt(signInput.getLocation(), task -> {
                        ServerPlayerWrapper playerWrapper = ServerPlayerWrapper.wrap(event.player());
                        playerWrapper.sendPacket(new ClientboundBlockUpdateWrapper(signInput.getLocation(), signInput.getLocation().getBlock().getType()));
                    });
                }
            }
        });
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onPlayerQuitEvent(@NotNull PlayerQuitEvent event) {
                ServerPlayerWrapper wrapper = ServerPlayerWrapper.wrap(event.getPlayer());
                wrapper.uninject();
                if (AxPlugin.this.tracker == null) {
                    return;
                }
                AxPlugin.this.tracker.untrackFor(ServerPlayerWrapper.wrap(event.getPlayer()));
            }

            @EventHandler
            public void onPlayerJoinEvent(@NotNull PlayerJoinEvent event) {
                ServerPlayerWrapper wrapper = ServerPlayerWrapper.wrap(event.getPlayer());
                wrapper.inject();
            }

            @EventHandler
            public void onPacketEntityInteractEvent(@NotNull PacketEntityInteractEvent event) {
                event.getPacketEntity().callInteract(event);
            }

            @EventHandler
            public void onPlayerChangedWorldEvent(@NotNull PlayerChangedWorldEvent event) {
                if (AxPlugin.this.tracker == null) {
                    return;
                }
                AxPlugin.this.tracker.untrackFor(ServerPlayerWrapper.wrap(event.getPlayer()));
            }
        }, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new AnvilListener(), (Plugin)this);
        if ((Long)this.flags.HOLOGRAM_UPDATE_TICKS.get() > 0L) {
            Holograms.startTicking();
        }
        ParticleTypes.init();
        ClientboundPacketTypes.init();
        ServerboundPacketTypes.init();
        for (Player player : Bukkit.getOnlinePlayers()) {
            ServerPlayerWrapper wrapper = ServerPlayerWrapper.wrap(player);
            wrapper.inject();
        }
        this.enable();
        Placeholders.lock();
        if (((Boolean)this.flags.PLACEHOLDER_API_HOOK.get()).booleanValue() && Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlaceholderAPIHook().register();
        }
    }

    public void enable() {
    }

    public void onLoad() {
        this.load();
    }

    public void dependencies(DependencyManagerWrapper manager) {
    }

    public void load() {
    }

    public void onDisable() {
        this.disable();
        Scheduler.get().cancelAll();
        for (Player player : Bukkit.getOnlinePlayers()) {
            ServerPlayerWrapper wrapper = ServerPlayerWrapper.wrap(player);
            wrapper.uninject();
        }
        if (this.tracker != null) {
            this.tracker.shutdown();
        }
        Holograms.shutdown();
    }

    public void disable() {
    }

    public void reload() {
    }

    public FeatureFlags flags() {
        return this.flags;
    }

    public ComponentSerializer serializer() {
        return this.serializer;
    }

    public long reloadWithTime() {
        long start = System.currentTimeMillis();
        this.reload();
        return System.currentTimeMillis() - start;
    }
}

