/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.guis;

import com.artillexstudios.axvaults.AxVaults;
import com.artillexstudios.axvaults.guis.ItemPicker;
import com.artillexstudios.axvaults.libs.axapi.libs.boostedyaml.block.implementation.Section;
import com.artillexstudios.axvaults.libs.axapi.reflection.ClassUtils;
import com.artillexstudios.axvaults.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axvaults.libs.axapi.utils.StringUtils;
import com.artillexstudios.axvaults.libs.gui.builder.gui.PaginatedBuilder;
import com.artillexstudios.axvaults.libs.gui.guis.Gui;
import com.artillexstudios.axvaults.libs.gui.guis.GuiItem;
import com.artillexstudios.axvaults.libs.gui.guis.PaginatedGui;
import com.artillexstudios.axvaults.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import com.artillexstudios.axvaults.vaults.Vault;
import com.artillexstudios.axvaults.vaults.VaultManager;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.function.Consumer;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class VaultSelector {
    public void open(@NotNull Player player) {
        this.open(player, 1);
    }

    public void open(@NotNull Player player, int page) {
        Section close;
        Section next;
        int rows = AxVaults.CONFIG.getInt("vault-selector-rows", 6);
        int pageSize = rows * 9 - 9;
        String title = AxVaults.MESSAGES.getString("guis.selector.title");
        if (ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI")) {
            title = PlaceholderAPI.setPlaceholders((Player)player, (String)title);
        }
        PaginatedGui gui = ((PaginatedBuilder)((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().title(StringUtils.format(title, new TagResolver[0]))).rows(rows)).pageSize(pageSize).disableAllInteractions()).create();
        for (int i = 0; i < pageSize * (page + 1); ++i) {
            this.getItemOfVault(player, i + 1, gui, guiItem -> {
                if (guiItem == null) {
                    return;
                }
                gui.addItem((GuiItem)guiItem);
            });
        }
        Section prev = AxVaults.MESSAGES.getSection("gui-items.previous-page");
        if (prev != null) {
            GuiItem item1 = new GuiItem(new ItemBuilder(prev).get());
            item1.setAction(event -> gui.previous());
            gui.setItem(rows, 3, item1);
        }
        if ((next = AxVaults.MESSAGES.getSection("gui-items.next-page")) != null) {
            GuiItem item2 = new GuiItem(new ItemBuilder(next).get());
            item2.setAction(event -> {
                gui.next();
                for (int i = 0; i < pageSize; ++i) {
                    this.getItemOfVault(player, gui.getCurrentPageNum() * pageSize + i + 1, gui, guiItem -> {
                        if (guiItem == null) {
                            return;
                        }
                        gui.addItem((GuiItem)guiItem);
                    });
                }
            });
            gui.setItem(rows, 7, item2);
        }
        if ((close = AxVaults.MESSAGES.getSection("gui-items.close")) != null) {
            GuiItem item3 = new GuiItem(new ItemBuilder(close).get());
            item3.setAction(event -> event.getWhoClicked().closeInventory());
            gui.setItem(rows, 5, item3);
        }
        gui.open((HumanEntity)player, page);
    }

    private void getItemOfVault(@NotNull Player player, int num, @NotNull PaginatedGui gui, Consumer<GuiItem> consumer) {
        int maxVaults = AxVaults.CONFIG.getInt("max-vault-amount");
        if (maxVaults != -1 && num > maxVaults) {
            consumer.accept(null);
            return;
        }
        HashMap<String, CallSite> replacements = new HashMap<String, CallSite>();
        replacements.put("%num%", (CallSite)((Object)("" + num)));
        VaultManager.getVaultOfPlayer(player, num, vault -> {
            if (vault != null) {
                replacements.put("%used%", (CallSite)((Object)("" + vault.getSlotsFilled())));
                replacements.put("%max%", (CallSite)((Object)("" + vault.getStorage().getSize())));
                ItemBuilder builder = new ItemBuilder(AxVaults.MESSAGES.getSection("guis.selector.item-owned"));
                builder.setLore(AxVaults.MESSAGES.getStringList("guis.selector.item-owned.lore"), replacements);
                builder.setName(AxVaults.MESSAGES.getString("guis.selector.item-owned.name"), replacements);
                ItemStack it = builder.get();
                if (it.hasItemMeta()) {
                    ItemMeta meta = it.getItemMeta();
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                    it.setItemMeta(meta);
                }
                it.setType(vault.getIcon());
                switch (AxVaults.CONFIG.getInt("selector-item-amount-mode", 1)) {
                    case 1: {
                        it.setAmount(num % 64 == 0 ? 64 : num % 64);
                        break;
                    }
                    case 3: {
                        it.setAmount(Math.max(1, vault.getSlotsFilled()));
                    }
                }
                GuiItem guiItem = new GuiItem(it);
                guiItem.setAction(event -> {
                    if (event.isShiftClick()) {
                        if (!player.hasPermission("axvaults.itempicker")) {
                            AxVaults.MESSAGEUTILS.sendLang((CommandSender)event.getWhoClicked(), "no-permission", new TagResolver[0]);
                            return;
                        }
                        new ItemPicker().open(player, (Vault)vault, gui.getCurrentPageNum(), 1);
                        return;
                    }
                    AxVaults.MESSAGEUTILS.sendLang((CommandSender)event.getWhoClicked(), "vault.opened", replacements);
                    vault.open(player);
                });
                consumer.accept(guiItem);
            } else {
                if (!AxVaults.CONFIG.getBoolean("show-locked-vaults", true)) {
                    consumer.accept(null);
                    return;
                }
                ItemBuilder builder = new ItemBuilder(AxVaults.MESSAGES.getSection("guis.selector.item-locked"));
                builder.setLore(AxVaults.MESSAGES.getStringList("guis.selector.item-locked.lore"), replacements);
                builder.setName(AxVaults.MESSAGES.getString("guis.selector.item-locked.name"), replacements);
                ItemStack it = builder.get();
                if (AxVaults.CONFIG.getInt("selector-item-amount-mode", 1) == 1) {
                    it.setAmount(num % 64 == 0 ? 64 : num % 64);
                }
                consumer.accept(new GuiItem(it));
            }
        });
    }
}

