/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.database.impl;

import com.artillexstudios.axvaults.AxVaults;
import com.artillexstudios.axvaults.database.Database;
import com.artillexstudios.axvaults.libs.axapi.serializers.Serializers;
import com.artillexstudios.axvaults.libs.axapi.utils.StringUtils;
import com.artillexstudios.axvaults.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import com.artillexstudios.axvaults.placed.PlacedVaults;
import com.artillexstudios.axvaults.utils.SerializationUtils;
import com.artillexstudios.axvaults.utils.VaultUtils;
import com.artillexstudios.axvaults.vaults.Vault;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SQLite
implements Database {
    private Connection conn;

    @Override
    public String getType() {
        return "SQLite";
    }

    @Override
    public void setup() {
        try {
            Class.forName("org.sqlite.JDBC");
            this.conn = DriverManager.getConnection(String.format("jdbc:sqlite:%s/data.db", AxVaults.getInstance().getDataFolder()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS `axvaults_data`( `id` INT(128) NOT NULL,`uuid` VARCHAR(36) NOT NULL,`storage` LONGBLOB,`icon` VARCHAR(128));";
        try (PreparedStatement stmt = this.conn.prepareStatement("CREATE TABLE IF NOT EXISTS `axvaults_data`( `id` INT(128) NOT NULL,`uuid` VARCHAR(36) NOT NULL,`storage` LONGBLOB,`icon` VARCHAR(128));");){
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        String CREATE_TABLE2 = "CREATE TABLE IF NOT EXISTS `axvaults_blocks` ( `location` VARCHAR(255) NOT NULL, `number` INT, PRIMARY KEY (`location`) );";
        try (PreparedStatement stmt = this.conn.prepareStatement("CREATE TABLE IF NOT EXISTS `axvaults_blocks` ( `location` VARCHAR(255) NOT NULL, `number` INT, PRIMARY KEY (`location`) );");){
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        this.convert();
    }

    /*
     * Unable to fully structure code
     */
    private void convert() {
        test = "SELECT storage FROM axvaults_data LIMIT 1;";
        try {
            stmt = this.conn.prepareStatement(test);
            try {
                block35: {
                    rs = stmt.executeQuery();
                    try {
                        if (rs.next()) {
                            Serializers.ITEM_ARRAY.deserialize(rs.getBytes(1));
                        }
                        if (rs == null) break block35;
                    }
                    catch (Throwable var4_8) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable var5_11) {
                                var4_8.addSuppressed(var5_11);
                            }
                        }
                        throw var4_8;
                    }
                    rs.close();
                }
                return;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (Exception stmt) {
            sql = "SELECT * FROM axvaults_data;";
            am = 0;
            time = System.currentTimeMillis();
            try {
                stmt = this.conn.prepareStatement(sql);
                try {
                    rs = stmt.executeQuery();
lbl37:
                    // 2 sources

                    try {
                        while (rs.next()) {
                            sql2 = "UPDATE axvaults_data SET storage = ? WHERE id = ? AND uuid = ?";
                            stmt2 = this.conn.prepareStatement(sql2);
                            try {
                                items = SerializationUtils.invFromBits(rs.getBinaryStream("storage"));
                                stmt2.setBytes(1, Serializers.ITEM_ARRAY.serialize(items));
                                stmt2.setInt(2, rs.getInt("id"));
                                stmt2.setString(3, rs.getString("uuid"));
                                stmt2.executeUpdate();
                                if (++am % 50 != 0) continue;
                                Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxVaults] Converted " + am + " vaults so far! (" + (System.currentTimeMillis() - time) + "ms)", new TagResolver[0]));
                            }
                            finally {
                                if (stmt2 == null) ** GOTO lbl37
                                stmt2.close();
                            }
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxVaults] Successfully converted " + am + " vaults in " + (System.currentTimeMillis() - time) + "ms", new TagResolver[0]));
            return;
        }
    }

    @Override
    public CompletableFuture<Void> saveVault(@NotNull Vault vault) {
        Consumer<byte[]> consumer = bytes -> {
            block27: {
                String sql = "SELECT * FROM axvaults_data WHERE uuid = ? AND id = ?;";
                try (PreparedStatement stmt = this.conn.prepareStatement("SELECT * FROM axvaults_data WHERE uuid = ? AND id = ?;");){
                    stmt.setString(1, vault.getUUID().toString());
                    stmt.setInt(2, vault.getId());
                    try (ResultSet rs = stmt.executeQuery();){
                        if (rs.next()) {
                            String sql2 = "UPDATE axvaults_data SET storage = ?, icon = ? WHERE uuid = ? AND id = ?;";
                            try (PreparedStatement stmt2 = this.conn.prepareStatement("UPDATE axvaults_data SET storage = ?, icon = ? WHERE uuid = ? AND id = ?;");){
                                stmt2.setBytes(1, (byte[])bytes);
                                stmt2.setString(2, vault.getRealIcon() == null ? null : vault.getRealIcon().name());
                                stmt2.setString(3, vault.getUUID().toString());
                                stmt2.setInt(4, vault.getId());
                                stmt2.executeUpdate();
                                break block27;
                            }
                        }
                        String sql2 = "INSERT INTO axvaults_data(id, uuid, storage, icon) VALUES (?, ?, ?, ?);";
                        try (PreparedStatement stmt2 = this.conn.prepareStatement("INSERT INTO axvaults_data(id, uuid, storage, icon) VALUES (?, ?, ?, ?);");){
                            stmt2.setInt(1, vault.getId());
                            stmt2.setString(2, vault.getUUID().toString());
                            stmt2.setBytes(3, (byte[])bytes);
                            stmt2.setString(4, vault.getRealIcon() == null ? null : vault.getRealIcon().name());
                            stmt2.executeUpdate();
                        }
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        };
        CompletionStage local = Bukkit.isPrimaryThread() ? VaultUtils.serialize(vault).thenAccept((Consumer)consumer) : VaultUtils.serialize(vault).thenAcceptAsync((Consumer)consumer);
        CompletableFuture<Void> cf = new CompletableFuture<Void>();
        ((CompletableFuture)local).thenRun(() -> cf.complete(null));
        return cf;
    }

    @Override
    public void loadVaults(@NotNull UUID uuid) {
        String sql = "SELECT * FROM axvaults_data WHERE uuid = ?;";
        try (PreparedStatement stmt = this.conn.prepareStatement("SELECT * FROM axvaults_data WHERE uuid = ?;");){
            stmt.setString(1, uuid.toString());
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    ItemStack[] items = Serializers.ITEM_ARRAY.deserialize(rs.getBytes(3));
                    Vault vault = new Vault(uuid, rs.getInt(1), rs.getString(4) == null ? null : Material.valueOf((String)rs.getString(4)));
                    vault.setContents(items);
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isVault(@NotNull Location location) {
        String sql = "SELECT * FROM axvaults_blocks WHERE location = ?;";
        try (PreparedStatement stmt = this.conn.prepareStatement("SELECT * FROM axvaults_blocks WHERE location = ?;");){
            stmt.setString(1, Serializers.LOCATION.serialize(location));
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) return false;
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public void setVault(@NotNull Location location, @Nullable Integer num) {
        String sql = "INSERT INTO `axvaults_blocks`(`location`, `number`) VALUES (?, ?)";
        try (PreparedStatement stmt = this.conn.prepareStatement("INSERT INTO `axvaults_blocks`(`location`, `number`) VALUES (?, ?)");){
            stmt.setString(1, Serializers.LOCATION.serialize(location));
            if (num == null) {
                stmt.setString(2, null);
            } else {
                stmt.setInt(2, num);
            }
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        PlacedVaults.addVault(location, num);
    }

    @Override
    public void removeVault(@NotNull Location location) {
        String sql = "DELETE FROM axvaults_blocks WHERE location = ?;";
        try (PreparedStatement stmt = this.conn.prepareStatement("DELETE FROM axvaults_blocks WHERE location = ?;");){
            stmt.setString(1, Serializers.LOCATION.serialize(location));
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void deleteVault(@NotNull UUID uuid, int num) {
        String sql = "DELETE FROM axvaults_data WHERE uuid = ? AND id = ?;";
        try (PreparedStatement stmt = this.conn.prepareStatement("DELETE FROM axvaults_data WHERE uuid = ? AND id = ?;");){
            stmt.setString(1, uuid.toString());
            stmt.setInt(2, num);
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void load() {
        String sql = "SELECT * FROM axvaults_blocks;";
        try (PreparedStatement stmt = this.conn.prepareStatement("SELECT * FROM axvaults_blocks;");
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                String vault = rs.getString(2);
                Integer vaultInt = vault == null ? null : Integer.valueOf(Integer.parseInt(vault));
                PlacedVaults.addVault(Serializers.LOCATION.deserialize(rs.getString(1)), vaultInt);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void disable() {
        try {
            this.conn.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

