/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults;

import com.artillexstudios.axvaults.commands.CommandManager;
import com.artillexstudios.axvaults.database.Database;
import com.artillexstudios.axvaults.database.impl.H2;
import com.artillexstudios.axvaults.database.impl.MySQL;
import com.artillexstudios.axvaults.database.impl.SQLite;
import com.artillexstudios.axvaults.database.messaging.SQLMessaging;
import com.artillexstudios.axvaults.libraries.Libraries;
import com.artillexstudios.axvaults.libs.axapi.AxPlugin;
import com.artillexstudios.axvaults.libs.axapi.config.Config;
import com.artillexstudios.axvaults.libs.axapi.executor.ThreadedQueue;
import com.artillexstudios.axvaults.libs.axapi.libs.boostedyaml.dvs.versioning.BasicVersioning;
import com.artillexstudios.axvaults.libs.axapi.libs.boostedyaml.settings.dumper.DumperSettings;
import com.artillexstudios.axvaults.libs.axapi.libs.boostedyaml.settings.general.GeneralSettings;
import com.artillexstudios.axvaults.libs.axapi.libs.boostedyaml.settings.loader.LoaderSettings;
import com.artillexstudios.axvaults.libs.axapi.libs.boostedyaml.settings.updater.UpdaterSettings;
import com.artillexstudios.axvaults.libs.axapi.metrics.AxMetrics;
import com.artillexstudios.axvaults.libs.axapi.utils.MessageUtils;
import com.artillexstudios.axvaults.libs.axapi.utils.StringUtils;
import com.artillexstudios.axvaults.libs.axapi.utils.featureflags.FeatureFlags;
import com.artillexstudios.axvaults.libs.bstats.bukkit.Metrics;
import com.artillexstudios.axvaults.libs.kyori.adventure.platform.bukkit.BukkitAudiences;
import com.artillexstudios.axvaults.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import com.artillexstudios.axvaults.listeners.BlackListListener;
import com.artillexstudios.axvaults.listeners.BlockBreakListener;
import com.artillexstudios.axvaults.listeners.InventoryCloseListener;
import com.artillexstudios.axvaults.listeners.PlayerInteractListener;
import com.artillexstudios.axvaults.listeners.PlayerListeners;
import com.artillexstudios.axvaults.schedulers.AutoSaveScheduler;
import com.artillexstudios.axvaults.utils.UpdateNotifier;
import com.artillexstudios.axvaults.vaults.Vault;
import com.artillexstudios.axvaults.vaults.VaultManager;
import java.io.File;
import java.net.URLClassLoader;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import revxrsal.zapper.DependencyManager;
import revxrsal.zapper.classloader.URLClassLoaderWrapper;

public final class AxVaults
extends AxPlugin {
    public static Config CONFIG;
    public static Config MESSAGES;
    public static MessageUtils MESSAGEUTILS;
    private static AxPlugin instance;
    private static ThreadedQueue<Runnable> threadedQueue;
    private static Database database;
    public static BukkitAudiences BUKKITAUDIENCES;
    private static AxMetrics metrics;

    public static ThreadedQueue<Runnable> getThreadedQueue() {
        return threadedQueue;
    }

    public static AxPlugin getInstance() {
        return instance;
    }

    public static Database getDatabase() {
        return database;
    }

    @Override
    public void load() {
        Libraries.load(new DependencyManager(this.getDescription(), new File(this.getDataFolder(), "lib"), URLClassLoaderWrapper.wrap((URLClassLoader)this.getClassLoader())));
    }

    @Override
    public void enable() {
        instance = this;
        int pluginId = 20541;
        new Metrics(this, pluginId);
        CONFIG = new Config(new File(this.getDataFolder(), "config.yml"), this.getResource("config.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("version")).build());
        MESSAGES = new Config(new File(this.getDataFolder(), "messages.yml"), this.getResource("messages.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("version")).build());
        MESSAGEUTILS = new MessageUtils(MESSAGES.getBackingDocument(), "prefix", CONFIG.getBackingDocument());
        BUKKITAUDIENCES = BukkitAudiences.create((Plugin)this);
        threadedQueue = new ThreadedQueue("AxVaults-Datastore-thread");
        database = switch (CONFIG.getString("database.type").toLowerCase()) {
            case "sqlite" -> new SQLite();
            case "mysql" -> new MySQL();
            default -> new H2();
        };
        database.setup();
        database.load();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListeners(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlackListListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerInteractListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockBreakListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryCloseListener(), (Plugin)this);
        CommandManager.load();
        AutoSaveScheduler.start();
        SQLMessaging.start();
        metrics = new AxMetrics(this, 3L);
        metrics.start();
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#55ff00[AxVaults] Loaded plugin!", new TagResolver[0]));
        if (CONFIG.getBoolean("update-notifier.enabled", true)) {
            new UpdateNotifier(this, 5417);
        }
    }

    @Override
    public void disable() {
        if (metrics != null) {
            metrics.cancel();
        }
        for (Vault vault : VaultManager.getVaults()) {
            AxVaults.getDatabase().saveVault(vault);
        }
        AutoSaveScheduler.stop();
        SQLMessaging.stop();
        database.disable();
        threadedQueue.stop();
    }

    @Override
    public void updateFlags(FeatureFlags flags) {
        flags.USE_LEGACY_HEX_FORMATTER.set(true);
    }
}

