/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.vaults;

import com.artillexstudios.axvaults.AxVaults;
import com.artillexstudios.axvaults.hooks.HookManager;
import com.artillexstudios.axvaults.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axvaults.libs.axapi.utils.StringUtils;
import com.artillexstudios.axvaults.utils.SoundUtils;
import com.artillexstudios.axvaults.vaults.VaultPlayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Vault
implements InventoryHolder {
    private final VaultPlayer vaultPlayer;
    private Inventory storage;
    private final int id;
    private Material icon;
    private long lastOpen = System.currentTimeMillis();
    private final AtomicBoolean changed = new AtomicBoolean(false);

    public Vault(VaultPlayer vaultPlayer, int id, Material icon, @Nullable ItemStack[] contents) {
        this.vaultPlayer = vaultPlayer;
        this.id = id;
        this.storage = Bukkit.createInventory((InventoryHolder)this, (int)(vaultPlayer.getRows() * 9), (String)this.getTitle());
        if (contents != null) {
            this.setContents(contents);
        }
        vaultPlayer.getVaultMap().put(id, this);
        this.icon = icon;
    }

    @ApiStatus.Internal
    public void setContents(ItemStack[] items) {
        if (this.storage.getSize() < items.length) {
            for (int i = 0; i < this.storage.getSize(); ++i) {
                this.storage.setItem(i, items[i]);
            }
            Player player = Bukkit.getPlayer((UUID)this.vaultPlayer.getUUID());
            for (int i = this.storage.getSize(); i < items.length; ++i) {
                if (items[i] == null) continue;
                HashMap remaining = this.storage.addItem(new ItemStack[]{items[i]});
                if (player == null) continue;
                Scheduler.get().runAt(player.getLocation(), () -> remaining.forEach((k, v) -> player.getLocation().getWorld().dropItem(player.getLocation(), v)));
            }
            return;
        }
        this.storage.setContents(items);
    }

    public Inventory getStorage() {
        return this.storage;
    }

    public VaultPlayer getVaultPlayer() {
        return this.vaultPlayer;
    }

    public UUID getUUID() {
        return this.vaultPlayer.getUUID();
    }

    public int getId() {
        return this.id;
    }

    public long getLastOpen() {
        return this.lastOpen;
    }

    public AtomicBoolean hasChanged() {
        return this.changed;
    }

    public void setIcon(Material icon) {
        this.changed.set(true);
        this.icon = icon;
    }

    public Material getIcon() {
        if (this.icon == null) {
            return Material.valueOf((String)AxVaults.MESSAGES.getString("guis.selector.item-owned.material", "BARREL"));
        }
        return this.icon;
    }

    @Nullable
    public Material getRealIcon() {
        return this.icon;
    }

    public int getSlotsFilled() {
        int am = 0;
        for (ItemStack it : this.storage.getContents()) {
            if (it == null) continue;
            ++am;
        }
        return am;
    }

    public void open(@NotNull Player player) {
        if (AxVaults.isStopping()) {
            return;
        }
        this.changed.set(true);
        if (this.vaultPlayer.getRows() != this.storage.getSize()) {
            this.reload();
        }
        player.openInventory(this.storage);
        SoundUtils.playSound(player, AxVaults.MESSAGES.getString("sounds.open"));
        this.lastOpen = System.currentTimeMillis();
    }

    public boolean isOpened() {
        return !this.storage.getViewers().isEmpty();
    }

    public void reload() {
        Inventory newStorage = Bukkit.createInventory((InventoryHolder)this, (int)(this.vaultPlayer.getRows() * 9), (String)this.getTitle());
        ItemStack[] contents = this.storage.getContents();
        ArrayList viewers = new ArrayList(this.storage.getViewers());
        Iterator viewerIterator = viewers.iterator();
        while (viewerIterator.hasNext()) {
            ((HumanEntity)viewerIterator.next()).openInventory(newStorage);
            viewerIterator.remove();
        }
        this.storage.clear();
        this.storage = newStorage;
        this.setContents(contents);
    }

    private String getTitle() {
        String title = AxVaults.MESSAGES.getString("guis.vault.title").replace("%num%", "" + this.id);
        title = HookManager.getPlaceholderParser().setPlaceholders(Bukkit.getOfflinePlayer((UUID)this.vaultPlayer.getUUID()), title);
        return StringUtils.formatToString(title, new TagResolver[0]);
    }

    public String toString() {
        return "Vault{vaultPlayer=" + String.valueOf(this.vaultPlayer.getUUID()) + ", changed=" + String.valueOf(this.changed) + ", lastOpen=" + this.lastOpen + ", icon=" + String.valueOf(this.icon) + ", id=" + this.id + ", storage=" + this.getSlotsFilled() + "/" + this.storage.getSize() + "}";
    }

    @NotNull
    public Inventory getInventory() {
        return this.storage;
    }
}

