/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axvaults.libs.lamp.core;

import com.artillexstudios.axvaults.libs.lamp.CommandHandler;
import com.artillexstudios.axvaults.libs.lamp.command.ArgumentStack;
import com.artillexstudios.axvaults.libs.lamp.command.CommandActor;
import com.artillexstudios.axvaults.libs.lamp.command.CommandParameter;
import com.artillexstudios.axvaults.libs.lamp.command.ExecutableCommand;
import com.artillexstudios.axvaults.libs.lamp.core.BaseCommandCategory;
import com.artillexstudios.axvaults.libs.lamp.core.BaseCommandHandler;
import com.artillexstudios.axvaults.libs.lamp.core.CommandExecutable;
import com.artillexstudios.axvaults.libs.lamp.core.MutableCommandPath;
import com.artillexstudios.axvaults.libs.lamp.exception.CommandInvocationException;
import com.artillexstudios.axvaults.libs.lamp.exception.InvalidCommandException;
import com.artillexstudios.axvaults.libs.lamp.exception.InvalidNumberException;
import com.artillexstudios.axvaults.libs.lamp.exception.MissingArgumentException;
import com.artillexstudios.axvaults.libs.lamp.exception.NoSubcommandSpecifiedException;
import com.artillexstudios.axvaults.libs.lamp.exception.TooManyArgumentsException;
import com.artillexstudios.axvaults.libs.lamp.ktx.call.KotlinConstants;
import com.artillexstudios.axvaults.libs.lamp.process.ContextResolver;
import com.artillexstudios.axvaults.libs.lamp.process.ParameterResolver;
import com.artillexstudios.axvaults.libs.lamp.process.ParameterValidator;
import com.artillexstudios.axvaults.libs.lamp.process.ValueResolver;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class BaseCommandDispatcher {
    private final BaseCommandHandler handler;

    public BaseCommandDispatcher(BaseCommandHandler handler) {
        this.handler = handler;
    }

    public Object eval(@NotNull CommandActor actor, @NotNull ArgumentStack arguments) {
        try {
            MutableCommandPath path = MutableCommandPath.empty();
            String argument = (String)arguments.getFirst();
            path.add(argument);
            CommandExecutable executable = this.handler.executables.get(path);
            if (executable != null) {
                arguments.removeFirst();
                return this.execute(executable, actor, arguments);
            }
            BaseCommandCategory category = this.handler.categories.get(path);
            if (category != null) {
                arguments.removeFirst();
                return this.searchCategory(actor, category, path, arguments);
            }
            throw new InvalidCommandException(path, path.getFirst());
        }
        catch (Throwable throwable) {
            this.handler.getExceptionHandler().handleException(throwable, actor);
            return null;
        }
    }

    private Object searchCategory(CommandActor actor, BaseCommandCategory category, MutableCommandPath path, ArgumentStack arguments) {
        CommandExecutable executable;
        if (!arguments.isEmpty()) {
            path.add((String)arguments.getFirst());
        }
        if ((executable = (CommandExecutable)category.commands.get(path)) != null) {
            arguments.removeFirst();
            return this.execute(executable, actor, arguments);
        }
        category.checkPermission(actor);
        BaseCommandCategory found = (BaseCommandCategory)category.getCategories().get(path);
        if (found == null) {
            if (category.defaultAction == null) {
                throw new NoSubcommandSpecifiedException(category);
            }
            return this.execute(category.defaultAction, actor, arguments);
        }
        arguments.removeFirst();
        return this.searchCategory(actor, found, path, arguments);
    }

    private Object execute(@NotNull CommandExecutable executable, @NotNull CommandActor actor, @NotNull ArgumentStack args) {
        Object result;
        List<String> input = args.asImmutableCopy();
        this.handler.conditions.forEach(condition -> condition.test(actor, executable, args.asImmutableView()));
        Object[] methodArguments = this.getMethodArguments(executable, actor, args, input);
        if (!args.isEmpty() && this.handler.failOnExtra) {
            throw new TooManyArgumentsException(executable, args);
        }
        try {
            result = executable.methodCaller.call(methodArguments);
        }
        catch (Throwable throwable) {
            throw new CommandInvocationException(executable, throwable);
        }
        executable.responseHandler.handleResponse(result, actor, executable);
        return result;
    }

    private Object[] getMethodArguments(CommandExecutable executable, CommandActor actor, ArgumentStack args, List<String> input) {
        Object[] values = new Object[executable.parameters.size()];
        for (CommandParameter parameter : executable.parameters) {
            if (ArgumentStack.class.isAssignableFrom(parameter.getType())) {
                values[parameter.getMethodIndex()] = args;
                continue;
            }
            if (parameter.isSwitch()) {
                this.handleSwitch(args, values, parameter);
                continue;
            }
            if (!parameter.isFlag()) continue;
            this.handleFlag(input, actor, args, values, parameter);
        }
        for (CommandParameter parameter : executable.parameters) {
            if (ArgumentStack.class.isAssignableFrom(parameter.getType())) {
                values[parameter.getMethodIndex()] = args;
                continue;
            }
            if (parameter.isSwitch() || parameter.isFlag()) continue;
            ParameterResolver resolver = parameter.getResolver();
            if (!resolver.mutatesArguments()) {
                parameter.checkPermission(actor);
                ContextResolverContext cxt = new ContextResolverContext(input, actor, parameter, values);
                Object value = resolver.resolve(cxt);
                for (ParameterValidator<Object> v : parameter.getValidators()) {
                    v.validate(value, parameter, actor);
                }
                values[parameter.getMethodIndex()] = value;
                continue;
            }
            boolean added = this.addDefaultValues(args, parameter, values);
            if (!added) continue;
            parameter.checkPermission(actor);
            ValueContextR cxt = new ValueContextR(input, actor, parameter, values, args);
            Object value = resolver.resolve(cxt);
            for (ParameterValidator<Object> v : parameter.getValidators()) {
                v.validate(value, parameter, actor);
            }
            values[parameter.getMethodIndex()] = value;
        }
        return values;
    }

    private boolean addDefaultValues(ArgumentStack args, CommandParameter parameter, Object[] values) {
        if (args.isEmpty()) {
            if (parameter.isOptional() && parameter.getDefaultValue().isEmpty()) {
                values[parameter.getMethodIndex()] = KotlinConstants.isKotlinClass(parameter.getJavaParameter().getDeclaringExecutable().getDeclaringClass()) ? KotlinConstants.ABSENT_VALUE : KotlinConstants.defaultPrimitiveValue(parameter.getType());
                return false;
            }
            if (!parameter.getDefaultValue().isEmpty()) {
                args.addAll(parameter.getDefaultValue());
                return true;
            }
            throw new MissingArgumentException(parameter);
        }
        return true;
    }

    private void handleSwitch(ArgumentStack args, Object[] values, CommandParameter parameter) {
        boolean provided = args.remove(this.handler.switchPrefix + parameter.getSwitchName());
        values[parameter.getMethodIndex()] = !provided ? Boolean.valueOf(parameter.getDefaultSwitch()) : Boolean.valueOf(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleFlag(List<String> input, CommandActor actor, ArgumentStack args, Object[] values, CommandParameter parameter) {
        ArgumentStack flagArguments;
        block8: {
            String lookup = this.handler.getFlagPrefix() + parameter.getFlagName();
            int index = args.indexOf(lookup);
            if (index == -1) {
                if (!parameter.isOptional()) throw new MissingArgumentException(parameter);
                if (!parameter.getDefaultValue().isEmpty()) {
                    args.add(lookup);
                    args.addAll(parameter.getDefaultValue());
                    index = args.indexOf(lookup);
                    args.remove(index);
                    flagArguments = ArgumentStack.parse((String)args.remove(index));
                    break block8;
                } else {
                    for (ParameterValidator<Object> v : parameter.getValidators()) {
                        v.validate(null, parameter, actor);
                    }
                    if (KotlinConstants.isKotlinClass(parameter.getJavaParameter().getDeclaringExecutable().getDeclaringClass())) {
                        values[parameter.getMethodIndex()] = KotlinConstants.ABSENT_VALUE;
                        return;
                    }
                    values[parameter.getMethodIndex()] = KotlinConstants.defaultPrimitiveValue(parameter.getType());
                    return;
                }
            }
            args.remove(index);
            if (index >= args.size()) {
                throw new MissingArgumentException(parameter);
            }
            flagArguments = ArgumentStack.copyExact((String)args.remove(index));
        }
        ValueContextR contextR = new ValueContextR(input, actor, parameter, values, flagArguments);
        Object value = parameter.getResolver().resolve(contextR);
        Iterator<ParameterValidator<Object>> iterator = parameter.getValidators().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                values[parameter.getMethodIndex()] = value;
                return;
            }
            ParameterValidator<Object> v = iterator.next();
            v.validate(value, parameter, actor);
        }
    }

    static final class ValueContextR
    extends ParamResolverContext
    implements ValueResolver.ValueResolverContext {
        ArgumentStack argumentStack;

        public ValueContextR(List<String> input, CommandActor actor, CommandParameter parameter, Object[] resolved, ArgumentStack argumentStack) {
            super(input, actor, parameter, resolved);
            this.argumentStack = argumentStack;
        }

        @Override
        public ArgumentStack arguments() {
            return this.argumentStack;
        }

        @Override
        public String popForParameter() {
            return this.arguments().popForParameter(this.parameter());
        }

        @Override
        public String pop() {
            return (String)this.arguments().pop();
        }

        private <T> T num(Function<String, T> f) {
            String input = this.pop();
            try {
                if (input.startsWith("0x")) {
                    return (T)Integer.valueOf(input.substring(2), 16);
                }
                return f.apply(input);
            }
            catch (NumberFormatException e) {
                throw new InvalidNumberException(this.parameter(), input);
            }
        }

        @Override
        public int popInt() {
            return this.num(Integer::parseInt);
        }

        @Override
        public double popDouble() {
            return this.num(Double::parseDouble);
        }

        @Override
        public byte popByte() {
            return this.num(Byte::parseByte);
        }

        @Override
        public short popShort() {
            return this.num(Short::parseShort);
        }

        @Override
        public float popFloat() {
            return this.num(Float::parseFloat).floatValue();
        }

        @Override
        public long popLong() {
            return this.num(Long::parseLong);
        }
    }

    private static final class ContextResolverContext
    extends ParamResolverContext
    implements ContextResolver.ContextResolverContext {
        public ContextResolverContext(List<String> input, CommandActor actor, CommandParameter parameter, Object[] resolved) {
            super(input, actor, parameter, resolved);
        }
    }

    private static abstract class ParamResolverContext
    implements ParameterResolver.ParameterResolverContext {
        private final List<String> input;
        private final CommandActor actor;
        private final CommandParameter parameter;
        private final Object[] resolved;

        @Override
        @NotNull
        public @Unmodifiable List<String> input() {
            return this.input;
        }

        @Override
        @NotNull
        public <A extends CommandActor> A actor() {
            return (A)this.actor;
        }

        @Override
        @NotNull
        public CommandParameter parameter() {
            return this.parameter;
        }

        @Override
        @NotNull
        public ExecutableCommand command() {
            return this.parameter.getDeclaringCommand();
        }

        @Override
        @NotNull
        public CommandHandler commandHandler() {
            return this.parameter.getCommandHandler();
        }

        @Override
        @NotNull
        public <T> T getResolvedParameter(@NotNull CommandParameter parameter) {
            try {
                return (T)this.resolved[parameter.getMethodIndex()];
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException("This parameter has not been resolved yet!");
            }
        }

        @Override
        @NotNull
        public <T> T getResolvedArgument(@NotNull Class<T> type) {
            for (Object o : this.resolved) {
                if (!type.isInstance(o)) continue;
                return (T)o;
            }
            throw new IllegalArgumentException("This parameter has not been resolved yet!");
        }

        public ParamResolverContext(List<String> input, CommandActor actor, CommandParameter parameter, Object[] resolved) {
            this.input = input;
            this.actor = actor;
            this.parameter = parameter;
            this.resolved = resolved;
        }
    }
}

